/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.eunit;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.CommonUtilities;
import org.eclipse.edt.gen.EGLMessages.EGLMessage;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.gen.eunit.Context;
import org.eclipse.edt.gen.eunit.IEUnitGenerationNotifier;
import org.eclipse.edt.gen.eunit.TestCounter;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateException;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;

public class EUnitGenerator
extends Generator {
    protected Context context;
    protected TabbedWriter out;
    protected AbstractGeneratorCommand generator;
    protected List<String> genedLibs;
    protected TestCounter totalCnts;
    private IGenerationMessageRequestor msgReq;
    protected IEUnitGenerationNotifier generationNotifier;
    protected String fDriverPartNameAppend = "";

    public EUnitGenerator(AbstractGeneratorCommand processor, List<String> genedLibs, TestCounter totalCnts, IGenerationMessageRequestor msgReq, IEUnitGenerationNotifier eckGenerationNotifier) {
        this(processor, msgReq, eckGenerationNotifier);
        this.genedLibs = genedLibs;
        this.totalCnts = totalCnts;
    }

    public EUnitGenerator(AbstractGeneratorCommand processor, IGenerationMessageRequestor msgReq, IEUnitGenerationNotifier eckGenerationNotifier) {
        super(processor, msgReq);
        this.generator = processor;
        this.msgReq = msgReq;
        this.out = new TabbedWriter((Writer)new StringWriter());
        this.generationNotifier = eckGenerationNotifier;
    }

    public String getResult() {
        return this.out.getWriter().toString();
    }

    public Context makeContext(AbstractGeneratorCommand processor) {
        this.context = new Context(processor);
        return this.context;
    }

    public boolean visit(Part part) {
        try {
            this.context.invoke("genPart", (Type)part, new Object[]{this.context, this.out});
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected void ContextInvoke(Part part, TestCounter counter) {
        this.context.invoke("genPart", (Type)part, new Object[]{this.context, this.out, counter});
    }

    public void generate(Part part) throws GenerationException {
        try {
            this.generationNotifier.setTaskName("Generating - " + part.getFileName() + "...");
            this.generationNotifier.updateProgress(1);
            if (this.generationNotifier.isAborted()) {
                return;
            }
            if (part instanceof Library) {
                TestCounter counter = new TestCounter();
                this.context.invoke("preGenPart", (Type)part, new Object[]{this.context, counter});
                if (!this.context.getMessageRequestor().isError()) {
                    this.out.getWriter().flush();
                    this.ContextInvoke(part, counter);
                    this.out.flush();
                }
                if (this.totalCnts != null) {
                    this.totalCnts.increment(counter.getCount());
                }
            }
        }
        catch (IOException e) {
            throw new GenerationException((Throwable)e);
        }
        catch (TemplateException e) {
            String[] details1 = new String[]{e.getLocalizedMessage()};
            EGLMessage message1 = EGLMessage.createEGLMessage((Map)this.context.getMessageMapping(), (int)1, (String)"9998", (Object)((Object)e), (String[])details1, (Annotation)CommonUtilities.includeEndOffset((Annotation)part.getAnnotation("EGL_Location"), (EglContext)this.context));
            this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)message1);
            if (e.getCause() != null) {
                String[] details2 = new String[]{e.getCause().toString()};
                EGLMessage message2 = EGLMessage.createEGLMessage((Map)this.context.getMessageMapping(), (int)1, (String)"9999", (Object)((Object)e), (String[])details2, (Annotation)CommonUtilities.includeEndOffset((Annotation)part.getAnnotation("EGL_Location"), (EglContext)this.context));
                this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)message2);
            }
            e.printStackTrace();
        }
        this.out.close();
    }

    public void dumpErrorMessages() {
        for (IGenerationResultsMessage message : this.msgReq.getMessages()) {
            System.out.println(message.getBuiltMessage());
        }
    }

    public void processFile(String fileName) {
    }

    public String getRelativeFileName(Part part) {
        String fileName = part.getTypeSignature();
        fileName = org.eclipse.edt.gen.eunit.CommonUtilities.prependECKGen(fileName);
        this.genedLibs.add(fileName);
        return String.valueOf(fileName.replaceAll("\\.", "/")) + this.getFileExtension();
    }

    public String getFileExtension() {
        return ".egl";
    }

    public void generate(Object objectClass) throws GenerationException {
    }
}

