/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.javascript.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.IEGLDebugTarget;
import org.eclipse.edt.debug.core.IEGLVariable;
import org.eclipse.edt.debug.core.breakpoints.EGLBreakpoint;
import org.eclipse.edt.debug.javascript.internal.model.IVariableQueryCompletion;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugElement;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugMessages;
import org.eclipse.edt.debug.javascript.internal.model.RUIStackFrame;
import org.eclipse.edt.debug.javascript.internal.model.RUIThread;
import org.eclipse.edt.debug.javascript.internal.model.RUIVariable;
import org.eclipse.edt.ide.debug.javascript.internal.server.DebugContext;
import org.eclipse.edt.ide.debug.javascript.internal.utils.RUIDebugUtil;
import org.eclipse.edt.ide.rui.server.EvServer;
import org.eclipse.osgi.util.NLS;

public class RUIDebugTarget
extends RUIDebugElement
implements IEGLDebugTarget,
IBreakpointManagerListener,
ISuspendResume {
    public static final String VAR_VAR = "var_";
    public static final String VAR_VALUE = "var_Value";
    public static final String VAR_SET_VALUE = "var_SetValue";
    public static final String VAR_VARIABLES = "var_Variables";
    private static final IStackFrame[] EMPTY_FRAMES = new IStackFrame[0];
    private ILaunch fLaunch;
    private DebugContext context;
    private RUIThread fThread;
    private IThread[] fThreads;
    private boolean fTerminated;
    private boolean fTerminating;
    private boolean fSuspended;
    private boolean fSuspending;
    private List fStackFrames;
    private List fOldStackFrames;
    private String debugCmd;
    private boolean steppingIn;
    private LocaleInfo localeInfo;
    private IVariableQueryCompletion completion;
    private Object completionSynchObj = new Object();

    public RUIDebugTarget(ILaunch launch) {
        super(null);
        this.fLaunch = launch;
        this.initialize();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == RUIDebugTarget.class || adapter == IEGLDebugTarget.class || adapter == IDebugTarget.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    private void initialize() {
        this.fThread = new RUIThread(this);
        this.fThreads = new IThread[]{this.fThread};
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.fireCreationEvent();
    }

    public void setContext(DebugContext context) {
        this.context = context;
    }

    public String getName() throws DebugException {
        return NLS.bind((String)RUIDebugMessages.rui_debug_target_label, (Object[])new Object[]{((Object)((Object)this)).getClass().getName(), "localhost", EvServer.getInstance().getPortNumber()});
    }

    public IProcess getProcess() {
        return null;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    RUIThread getCurrentThread() {
        return (RUIThread)this.fThreads[0];
    }

    public IThread[] getThreads() throws DebugException {
        return this.fThreads;
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof EGLBreakpoint;
    }

    public boolean canTerminate() {
        return !this.isTerminated() && !this.isTerminating();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public boolean isTerminating() {
        return this.fTerminating;
    }

    public void terminate() throws DebugException {
        this.fTerminating = true;
        if (this.isSuspended()) {
            if (!this.setDebugCommand("disconnect")) {
                this.context.disconnectDebugger();
            }
        } else if (this.context != null) {
            this.context.disconnectDebugger();
        }
        this.context.debugTerminationCleanup();
    }

    public void terminated() {
        this.fSuspending = false;
        this.fSuspended = false;
        this.fTerminating = false;
        this.fTerminated = true;
        this.steppingIn = false;
        try {
            this.fireTerminateEvent();
            this.fireEvent(new DebugEvent((Object)this, 16));
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        }
        catch (Exception exception) {}
    }

    public void windowClosed() {
        if (!this.fTerminating && this.isSuspended() && this.debugCmd == null) {
            this.debugCmd = "silentTerminate";
            int numWaits = 0;
            while (this.debugCmd != null && numWaits < 20) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
                ++numWaits;
            }
        }
        this.terminated();
    }

    public boolean canResume() {
        return !this.isTerminated() && !this.isTerminating() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspending() && !this.isSuspended() && !this.isTerminated();
    }

    public boolean isSuspended() {
        return !this.isTerminated() && this.fSuspended;
    }

    public boolean isSuspending() {
        return !this.isTerminated() && !this.isTerminating() && this.fSuspending;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        IResource resource;
        if (this.supportsBreakpoint(breakpoint) && this.context != null && (resource = RUIDebugUtil.getBreakpointResource(breakpoint)) != null) {
            String file = RUIDebugUtil.encodeValue(RUIDebugUtil.getRelativeBreakpointPath(resource));
            String line = Integer.toString(breakpoint.getMarker().getAttribute("lineNumber", -1));
            String enabled = Boolean.toString(breakpoint.getMarker().getAttribute("org.eclipse.debug.core.enabled", true));
            if (this.isSuspended()) {
                if (!this.setDebugCommand("addBreakpoint " + file + "," + line + "," + enabled)) {
                    this.context.addBreakpoint(file, line, enabled);
                }
            } else {
                this.context.addBreakpoint(file, line, enabled);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        IResource resource;
        if (this.supportsBreakpoint(breakpoint) && this.context != null && (resource = RUIDebugUtil.getBreakpointResource(breakpoint)) != null) {
            String file = RUIDebugUtil.encodeValue(RUIDebugUtil.getRelativeBreakpointPath(resource));
            String line = Integer.toString(breakpoint.getMarker().getAttribute("lineNumber", -1));
            if (this.isSuspended()) {
                if (!this.setDebugCommand("removeBreakpoint " + file + "," + line)) {
                    this.context.removeBreakpoint(file, line);
                }
            } else {
                this.context.removeBreakpoint(file, line);
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint) && this.context != null) {
            IResource resource;
            int oldLine;
            boolean oldEnable;
            IMarker marker = breakpoint.getMarker();
            boolean currentEnable = marker.getAttribute("org.eclipse.debug.core.enabled", true);
            if (delta != null) {
                oldEnable = delta.getAttribute("org.eclipse.debug.core.enabled", true);
                oldLine = delta.getAttribute("lineNumber", -1);
            } else {
                oldEnable = !currentEnable;
                oldLine = marker.getAttribute("lineNumber", -1);
            }
            if (currentEnable != oldEnable && (resource = RUIDebugUtil.getBreakpointResource(breakpoint)) != null) {
                String file = RUIDebugUtil.encodeValue(RUIDebugUtil.getRelativeBreakpointPath(resource));
                String line = Integer.toString(oldLine);
                String enabled = Boolean.toString(currentEnable);
                if (this.isSuspended()) {
                    if (!this.setDebugCommand("changeBreakpoint " + file + "," + line + "," + enabled)) {
                        this.context.changeBreakpoint(file, line, enabled);
                    }
                } else {
                    this.context.changeBreakpoint(file, line, enabled);
                }
            }
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        if (this.context != null) {
            String state = Boolean.toString(enabled);
            if (this.isSuspended()) {
                if (!this.setDebugCommand("breakpointEnablement " + state)) {
                    this.context.breakpointManagerChanged(state);
                }
            } else {
                this.context.breakpointManagerChanged(state);
            }
        }
    }

    protected boolean breakpointsEnabled() {
        return DebugPlugin.getDefault().getBreakpointManager().isEnabled();
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IStackFrame[] getStackFrames() {
        if (!this.isSuspended() || this.fStackFrames == null || this.fStackFrames.size() == 0) {
            return EMPTY_FRAMES;
        }
        return this.fStackFrames.toArray(new IStackFrame[this.fStackFrames.size()]);
    }

    public void stepOver(RUIStackFrame frame) {
        this.steppingIn = false;
        this.setDebugCommand("stepOver " + frame.getId());
    }

    public void stepIn() {
        this.steppingIn = true;
        this.setDebugCommand("stepIn");
    }

    public void stepOut(RUIStackFrame frame) {
        this.steppingIn = false;
        this.setDebugCommand("stepOut " + frame.getId());
    }

    private synchronized boolean setDebugCommand(String str) {
        while (this.debugCmd != null) {
            block4: {
                try {
                    if (this.isSuspended()) break block4;
                    return false;
                }
                catch (Exception exception) {}
            }
            Thread.sleep(10L);
        }
        this.debugCmd = str;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue getVariableValue(final RUIVariable variable) {
        if (!this.isSuspended()) {
            variable.getCurrValue().setValue("");
            return variable.getCurrValue();
        }
        Object object = this.completionSynchObj;
        synchronized (object) {
            final String[] result = new String[2];
            this.completion = new IVariableQueryCompletion(){

                @Override
                public void completed(Object value) {
                    if (value instanceof String[]) {
                        result[0] = ((String[])value)[0];
                        result[1] = ((String[])value)[1];
                    }
                }

                @Override
                public RUIVariable getVariable() {
                    return variable;
                }
            };
            this.setDebugCommand("var_Value " + variable.getStackFrame().getId() + " " + variable.getIndex());
            int timeLeft = 4000;
            while (result[0] == null) {
                try {
                    if (timeLeft == 0) {
                        this.completion.completed(new String[]{"", ""});
                        this.debugCmd = null;
                        continue;
                    }
                    Thread.sleep(10L);
                    timeLeft -= 10;
                }
                catch (Exception exception) {
                    result[0] = "";
                }
            }
            this.completion = null;
            variable.getCurrValue().setValue(result[0]);
            if (result[1] != null && result[1].trim().length() != 0) {
                variable.setType(result[1].trim());
            }
        }
        return variable.getCurrValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setVariableValue(final RUIVariable variable, String LHS, String RHS, String getter, String setter) {
        if (this.isSuspended()) {
            Object object = this.completionSynchObj;
            synchronized (object) {
                block9: {
                    final String[] result = new String[1];
                    this.completion = new IVariableQueryCompletion(){

                        @Override
                        public void completed(Object value) {
                            if (value instanceof String) {
                                result[0] = (String)value;
                            }
                        }

                        @Override
                        public RUIVariable getVariable() {
                            return variable;
                        }
                    };
                    this.setDebugCommand("var_SetValue " + variable.getStackFrame().getId() + " " + variable.getIndex() + " " + LHS + " " + RHS + " " + getter + " " + setter);
                    int timeLeft = 4000;
                    while (result[0] == null) {
                        try {
                            if (timeLeft == 0) {
                                this.completion.completed("0");
                                this.debugCmd = null;
                                continue;
                            }
                            Thread.sleep(10L);
                            timeLeft -= 10;
                        }
                        catch (Exception exception) {
                            result[0] = "";
                        }
                    }
                    this.completion = null;
                    if (result[0] == null || result[0].length() == 0 || result[0].charAt(0) != '1') break block9;
                    return true;
                }
            }
        }
        return false;
    }

    public void suspend() throws DebugException {
        if (this.isSuspended() || this.context == null) {
            return;
        }
        this.fSuspending = true;
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    public void suspend(String reason) {
        this.fSuspending = false;
        this.fSuspended = true;
        int detail = this.getSuspendDetail(reason);
        if (detail != 8) {
            this.steppingIn = false;
        }
        this.fThread.fireSuspendEvent(detail);
        this.fireEvent(new DebugEvent((Object)this.getCurrentThread(), 16));
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEGLVariable[] getVariables(final RUIVariable variable) {
        Object[] result;
        if (!this.isSuspended()) {
            return new IEGLVariable[0];
        }
        Object object = this.completionSynchObj;
        synchronized (object) {
            result = new Object[1];
            this.completion = new IVariableQueryCompletion(){

                @Override
                public void completed(Object value) {
                    if (value instanceof IEGLVariable[]) {
                        result[0] = value;
                    }
                }

                @Override
                public RUIVariable getVariable() {
                    return variable;
                }
            };
            this.setDebugCommand("var_Variables " + variable.getStackFrame().getId() + " " + variable.getIndex());
            int timeLeft = 4000;
            while (result[0] == null) {
                try {
                    if (timeLeft == 0) {
                        this.completion.completed(new RUIVariable[0]);
                        this.debugCmd = null;
                        continue;
                    }
                    Thread.sleep(10L);
                    timeLeft -= 10;
                }
                catch (Exception exception) {
                    result[0] = new RUIVariable[0];
                }
            }
            this.completion = null;
        }
        return (IEGLVariable[])result[0];
    }

    private int getSuspendDetail(String reason) {
        if ("breakpoint".equals(reason)) {
            return 16;
        }
        if ("step".equals(reason)) {
            return 8;
        }
        return 0;
    }

    public void resume() throws DebugException {
        this.steppingIn = false;
        this.setDebugCommand("resume");
    }

    public void resume(String reason) {
        this.fSuspended = false;
        int detail = this.getResumeDetail(reason);
        if (detail != 1) {
            this.steppingIn = false;
        }
        this.fThread.fireResumeEvent(detail);
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    private int getResumeDetail(String reason) {
        if ("clientRequest".equals(reason)) {
            return 32;
        }
        if ("stepOver".equals(reason)) {
            return 2;
        }
        if ("stepIn".equals(reason)) {
            return 1;
        }
        if ("stepOut".equals(reason)) {
            return 4;
        }
        return 0;
    }

    @Override
    public IDebugTarget getDebugTarget() {
        return this;
    }

    public void parseStack(String stackStr) {
        this.fStackFrames = new ArrayList();
        StringTokenizer stackStrings = new StringTokenizer(stackStr, "|");
        while (stackStrings.hasMoreTokens()) {
            String nextStack = stackStrings.nextToken();
            StringTokenizer stackProperties = new StringTokenizer(nextStack, ",");
            String nextFile = RUIDebugUtil.decodeValue(stackProperties.nextToken());
            String nextFunctionName = stackProperties.nextToken();
            int nextLineNum = Integer.parseInt(stackProperties.nextToken());
            int nextFrameId = Integer.parseInt(stackProperties.nextToken());
            RUIStackFrame newFrame = new RUIStackFrame(this.getCurrentThread(), nextFrameId, RUIDebugUtil.getProgramNameFromFile(nextFile), nextFile, nextFunctionName, nextLineNum);
            while (stackProperties.hasMoreTokens()) {
                String varName = stackProperties.nextToken();
                String jsName = stackProperties.nextToken();
                String getterName = stackProperties.nextToken();
                String setterName = stackProperties.nextToken();
                String varIndex = stackProperties.nextToken();
                String varType = this.getTypeFromTokenizer(stackProperties);
                boolean kids = Integer.parseInt(stackProperties.nextToken()) != 0;
                RUIVariable var = new RUIVariable(newFrame, null, varName, jsName, getterName, setterName, varName, varIndex, varType, kids);
                newFrame.addVariable((IVariable)var);
            }
            if (nextLineNum == -1 && this.fStackFrames.size() == 0 || nextLineNum == -1 && "<<undefined>>".equals(nextFile)) continue;
            this.fStackFrames.add(0, newFrame);
        }
        if (this.fOldStackFrames != null && this.fOldStackFrames.size() != 0) {
            int i = 0;
            int size = this.fStackFrames.size();
            while (i < size) {
                RUIStackFrame newFrame = (RUIStackFrame)((Object)this.fStackFrames.get(i));
                RUIStackFrame oldFrame = this.findMatchingOldStackFrame(newFrame, size - i - 1);
                if (oldFrame != null) {
                    oldFrame.initialize(newFrame);
                    this.fStackFrames.set(i, oldFrame);
                }
                ++i;
            }
        }
    }

    private RUIStackFrame findMatchingOldStackFrame(RUIStackFrame newFrame, int depth) {
        if (this.fOldStackFrames == null || this.fOldStackFrames.size() == 0) {
            return null;
        }
        int index = this.fOldStackFrames.size() - depth - 1;
        if (index < 0) {
            return null;
        }
        RUIStackFrame oldFrame = (RUIStackFrame)((Object)this.fOldStackFrames.get(index));
        if (oldFrame.getProgramName().equals(newFrame.getProgramName()) && oldFrame.getFunctionName().equals(newFrame.getFunctionName())) {
            return oldFrame;
        }
        return null;
    }

    private String getTypeFromTokenizer(StringTokenizer tok) {
        String type = tok.nextToken();
        if (type.indexOf(40) != -1 && type.indexOf(41) == -1) {
            type = String.valueOf(type) + "," + tok.nextToken();
        }
        return type;
    }

    public String handleAtLine(Map args) {
        String reason = (String)args.get("suspendReason");
        if (reason != null) {
            IBreakpoint bp;
            if ("breakpoint".equals(reason) && (bp = this.findBreakpointFromArgs(args)) != null) {
                this.getCurrentThread().setBreakpoints(new IBreakpoint[]{bp});
            }
            this.suspend(reason);
        }
        while (this.isSuspended() && this.debugCmd == null) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
        String temp = this.debugCmd;
        this.debugCmd = null;
        if (temp == null || !temp.startsWith(VAR_VAR)) {
            if (this.fStackFrames != null && this.fStackFrames.size() != 0) {
                this.fOldStackFrames = this.fStackFrames;
            }
            this.fStackFrames = null;
        }
        return temp;
    }

    private IBreakpoint findBreakpointFromArgs(Map args) {
        int line;
        String file = (String)args.get("file");
        try {
            line = Integer.parseInt((String)args.get("line"));
        }
        catch (NumberFormatException numberFormatException) {
            line = -1;
        }
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.edt.debug.ui.presentation.java");
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (this.supportsBreakpoint(breakpoint)) {
                try {
                    if (breakpoint.isEnabled() && line == breakpoint.getMarker().getAttribute("lineNumber", -1) && RUIDebugUtil.getRelativeBreakpointPath(RUIDebugUtil.getBreakpointResource(breakpoint)).equals(file)) {
                        return breakpoint;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return null;
    }

    public boolean needsNewStack() {
        return this.fStackFrames == null || this.fStackFrames.size() == 0;
    }

    public void varValue(Map args) {
        if (this.completion != null) {
            String value = (String)args.get("value");
            String type = (String)args.get("type");
            value = value == null ? "" : value;
            type = type == null ? "" : type;
            this.completion.completed(new String[]{value, type});
        }
    }

    public void varSetValue(Map args) {
        if (this.completion != null) {
            this.completion.completed(args.get("success"));
        }
    }

    public void varVariables(String value) {
        if (this.completion != null) {
            ArrayList<RUIVariable> list = new ArrayList<RUIVariable>();
            if (value != null) {
                StringTokenizer varTokenizer = new StringTokenizer(value, ",");
                RUIVariable parent = this.completion.getVariable();
                RUIStackFrame frame = parent.getStackFrame();
                while (varTokenizer.hasMoreTokens()) {
                    String varName = varTokenizer.nextToken();
                    String jsName = varTokenizer.nextToken();
                    String getterName = varTokenizer.nextToken();
                    String setterName = varTokenizer.nextToken();
                    String varIndex = varTokenizer.nextToken();
                    String varType = this.getTypeFromTokenizer(varTokenizer);
                    boolean kids = Integer.parseInt(varTokenizer.nextToken()) != 0;
                    RUIVariable var = new RUIVariable(frame, parent, varName, jsName, getterName, setterName, String.valueOf(parent.getQualifiedName()) + "." + varName, varIndex, varType, kids);
                    list.add(var);
                }
            }
            this.completion.completed(list.toArray(new IEGLVariable[list.size()]));
        }
    }

    public void setVarValue() {
        if (this.completion != null) {
            this.completion.completed(null);
        }
    }

    public boolean isStepInto() {
        return this.steppingIn;
    }

    public LocaleInfo getLocaleInfo() {
        return this.localeInfo;
    }

    public void setLocaleInfo(Map args) {
        String val;
        if (this.localeInfo == null) {
            this.localeInfo = new LocaleInfo();
        }
        if ((val = (String)args.get("decimalSymbol")) != null) {
            this.localeInfo.decimalSymbol = val;
        }
        if ((val = (String)args.get("currencySymbol")) != null) {
            this.localeInfo.currencySymbol = val;
        }
    }

    public class LocaleInfo {
        public String decimalSymbol;
        public String currencySymbol;
    }
}

