/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.editor;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.edt.ide.rui.actions.ActionLaunchExternalBrowser;
import org.eclipse.edt.ide.rui.visualeditor.internal.actions.EvActionPreferences;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvHelp;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvPreviewPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Tooltips;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class EvPreviewToolbar
extends Composite
implements SelectionListener {
    protected ToolItem _itemLaunchExternalBrowser = null;
    protected ToolItem _itemPreferences = null;
    protected ToolItem _itemRefreshWebPage = null;
    protected EvPreviewPage _pagePreview = null;
    protected ToolBar _toolbar = null;

    public EvPreviewToolbar(Composite compositeParent, int style, EvPreviewPage pagePreview) {
        super(compositeParent, style);
        this._pagePreview = pagePreview;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 16;
        gridLayout.marginHeight = 1;
        gridLayout.horizontalSpacing = 2;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        GridData gridData = new GridData(512);
        label.setLayoutData((Object)gridData);
        this._toolbar = new ToolBar((Composite)this, 0x800100);
        gridData = new GridData(128);
        this._toolbar.setLayoutData((Object)gridData);
        this._itemLaunchExternalBrowser = this.createExternalBrowser();
        this._itemPreferences = this.createPreferences();
        this._itemRefreshWebPage = this.createRefreshWebPage();
        EvHelp.setHelp((Control)this._toolbar, EvHelp.PREVIEW_TOOLBAR);
        int i = 0;
        while (i < this._toolbar.getItemCount()) {
            EvHelp.setHelp(this._toolbar.getItem(i).getControl(), EvHelp.PREVIEW_TOOLBAR);
            ++i;
        }
    }

    protected ToolItem createExternalBrowser() {
        ToolItem item = new ToolItem(this._toolbar, 0x800008);
        item.setImage(Activator.getImage("elcl16/launchexternalbrowser_obj.gif"));
        item.addSelectionListener((SelectionListener)this);
        item.setToolTipText(Tooltips.NL_Show_the_web_page_in_an_external_web_browser);
        item.setEnabled(this._pagePreview.getEditor().isRuiHandler());
        return item;
    }

    protected ToolItem createPreferences() {
        ToolItem item = new ToolItem(this._toolbar, 0x800008);
        item.setImage(Activator.getImage("elcl16/preferences_obj.gif"));
        item.addSelectionListener((SelectionListener)this);
        item.setToolTipText(Tooltips.NL_Configure_preferences);
        return item;
    }

    protected ToolItem createRefreshWebPage() {
        ToolItem item = new ToolItem(this._toolbar, 0x800008);
        item.setImage(Activator.getImage("elcl16/refreshwebpage_obj.gif"));
        item.addSelectionListener((SelectionListener)this);
        item.setToolTipText(Tooltips.NL_Refresh_web_page);
        item.setEnabled(this._pagePreview.getEditor().isRuiHandler());
        return item;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._itemPreferences) {
            EvActionPreferences action = new EvActionPreferences();
            action.run();
            this._itemPreferences.getParent().setFocus();
        } else if (event.widget == this._itemRefreshWebPage) {
            this._pagePreview._bFullRefresh = true;
            this._pagePreview.getEditor().modelChanged();
        } else if (event.widget == this._itemLaunchExternalBrowser) {
            String url = this._pagePreview.getBrowserManager().getURL();
            try {
                String ipAddress = InetAddress.getLocalHost().getHostAddress();
                url = "http://" + ipAddress + url.substring(url.indexOf("localhost:") + 9);
            }
            catch (UnknownHostException unknownHostException) {}
            ActionLaunchExternalBrowser action = new ActionLaunchExternalBrowser(url, false);
            action.run();
            this._itemLaunchExternalBrowser.getParent().setFocus();
        }
    }
}

