/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.outline;

import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlay;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlayDropLocation;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.outline.WidgetTransfer;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.PageDataNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorRegistry;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.EvInsertWidgetWizardDialog;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertWidgetWizard;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WidgetDropAdapter
extends ViewerDropAdapter {
    protected Cursor _cursorWait;
    private WidgetTransfer transfer;
    private EvDesignPage designPage;
    private EvDesignOverlay overlay;

    public WidgetDropAdapter(TreeViewer viewer, EvDesignPage designPage, WidgetTransfer transfer, EvDesignOverlay overlay) {
        super((Viewer)viewer);
        this.transfer = transfer;
        this.designPage = designPage;
        this.overlay = overlay;
    }

    public boolean performDrop(Object data) {
        if (data == null) {
            return false;
        }
        if (this._cursorWait == null) {
            this._cursorWait = new Cursor((Device)this.getViewer().getControl().getDisplay(), 1);
        }
        this.getViewer().getControl().setCursor(this._cursorWait);
        int location = this.getCurrentLocation();
        WidgetPart target = (WidgetPart)this.getCurrentTarget();
        if (target == null) {
            target = this.designPage.getWidgetManager().getWidgetRoot();
        }
        int iTargetChildIndex = 0;
        WidgetPart parent = null;
        switch (location) {
            case 3: 
            case 4: {
                iTargetChildIndex = 0;
                parent = target;
                break;
            }
            case 2: {
                parent = target.getParent();
                iTargetChildIndex = parent.getChildIndex(target) + 1;
                break;
            }
            case 1: {
                parent = target.getParent();
                iTargetChildIndex = parent.getChildIndex(target);
            }
        }
        EvDesignOverlayDropLocation targetLocation = new EvDesignOverlayDropLocation();
        targetLocation.widgetParent = parent;
        targetLocation.iIndex = iTargetChildIndex;
        if (data instanceof String) {
            String strWidgetID = data.toString();
            WidgetDescriptor descriptor = WidgetDescriptorRegistry.getInstance(this.designPage.getEditor().getProject()).getDescriptor(strWidgetID);
            this.overlay.doOperationWidgetCreate(descriptor, targetLocation);
        } else if (data instanceof WidgetPart[]) {
            WidgetPart[] toDrop = (WidgetPart[])data;
            int i = 0;
            while (i < toDrop.length) {
                this.overlay.doOperationWidgetMove(toDrop[i], targetLocation);
                ++i;
            }
        } else if (data instanceof PageDataNode) {
            PageDataNode pageDataNode = (PageDataNode)data;
            InsertWidgetWizard insertWidgetWizard = new InsertWidgetWizard(pageDataNode, this.overlay, targetLocation);
            Shell shell = Display.getCurrent().getActiveShell();
            EvInsertWidgetWizardDialog evInsertWidgetWizardDialog = new EvInsertWidgetWizardDialog(shell, (IWizard)insertWidgetWizard);
            evInsertWidgetWizardDialog.setPageSize(600, 400);
            evInsertWidgetWizardDialog.open();
        }
        this.getViewer().getControl().setCursor(null);
        return true;
    }

    public boolean validateDrop(Object target, int op, TransferData type) {
        if (target == null) {
            return false;
        }
        WidgetPart targetWidget = (WidgetPart)target;
        if (targetWidget.getTypeName().equalsIgnoreCase("DojoTree") || targetWidget.getTypeName().equalsIgnoreCase("DojoTreeNode")) {
            return false;
        }
        if (this.transfer.isSupportedType(type) || TemplateTransfer.getInstance().isSupportedType(type)) {
            int location = this.getCurrentLocation();
            if (this.designPage.getEditor().getEditorProvider().isRUIWidget() && this.designPage.getWidgetManager().getWidgetRoot().equals(targetWidget.getParent()) && (1 == location || 2 == location)) {
                return false;
            }
            WidgetDescriptorRegistry registry = WidgetDescriptorRegistry.getInstance(this.designPage.getEditor().getProject());
            WidgetDescriptor descriptor = registry.getDescriptor(targetWidget.getTypeID());
            if (!(descriptor == null || 3 != location || this.isContainer(targetWidget) && descriptor._layoutDescriptor == null)) {
                return false;
            }
            descriptor = registry.getDescriptor(targetWidget.getParent().getTypeID());
            if (3 != location && descriptor != null && descriptor._layoutDescriptor != null) {
                return false;
            }
        }
        if (this.transfer.isSupportedType(type)) {
            WidgetPart selectedWidget = (WidgetPart)this.getSelectedObject();
            if (this.designPage.getWidgetManager().isChildOf(targetWidget, selectedWidget)) {
                return false;
            }
        }
        return true;
    }

    protected boolean isContainer(WidgetPart widget) {
        if (widget.getTypeName().equalsIgnoreCase("box") || widget.getTypeName().equalsIgnoreCase("div") || widget.getTypeName().equalsIgnoreCase("span") || widget.getTypeName().equalsIgnoreCase("grouping") || widget.getTypeName().equalsIgnoreCase("treenode") || widget.getTypeName().equalsIgnoreCase("tree")) {
            return true;
        }
        WidgetDescriptor descriptor = WidgetDescriptorRegistry.getInstance(this.designPage.getEditor().getProject()).getDescriptor(widget.getTypeID());
        if (descriptor != null) {
            return descriptor.isContainer();
        }
        return false;
    }
}

