/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class WidgetPart {
    protected static int MIN_PART_HEIGHT = 16;
    protected static int MIN_PART_WIDTH = 16;
    protected static int COUNTER = 1;
    protected boolean _bMouseOver = false;
    protected boolean _bMoveable = true;
    protected boolean _bSelected = false;
    protected int _iStatementLength = 0;
    protected int _iStatementOffset = 0;
    protected List _listChildren = Collections.synchronizedList(new ArrayList());
    protected Rectangle _rectBounds = new Rectangle(0, 0, 0, 0);
    protected Rectangle _rectDragging = new Rectangle(0, 0, 0, 0);
    protected String _strPackageName = null;
    protected String _strTypeID = null;
    protected String _strTypeName = null;
    protected String _strVariableName = null;
    protected String _strExtraInfo = null;
    protected WidgetPart _widgetParent = null;
    protected HashMap _tempInfoCache = new HashMap();
    protected int _counter = COUNTER++ % Integer.MAX_VALUE;
    private boolean _bidiBoundsFixed = false;

    public void addChildWidget(WidgetPart widgetChild) {
        this._listChildren.add(widgetChild);
    }

    public Rectangle getBounds() {
        return this._rectBounds;
    }

    public Rectangle getBoundsDragging() {
        return this._rectDragging;
    }

    public Point getBoundsOrigin() {
        return new Point(this._rectBounds.x, this._rectBounds.y);
    }

    public int getChildIndex(WidgetPart widgetChild) {
        return this._listChildren.indexOf(widgetChild);
    }

    public List getChildren() {
        return this._listChildren;
    }

    public String getLabel() {
        String type = "";
        String var = null;
        if (this._strTypeName != null && this._strTypeName.length() > 0) {
            type = this._strTypeName;
        }
        if (this._strVariableName != null && this._strVariableName.length() > 0) {
            var = this._strVariableName;
        }
        if (var == null) {
            return type;
        }
        return NLS.bind((String)Messages.NL_Properties_View_Widget_Label, (Object[])new Object[]{type, var}).trim();
    }

    public boolean getMouseOver() {
        return this._bMouseOver;
    }

    public boolean getMoveable() {
        return this._bMoveable;
    }

    public String getPackageName() {
        return this._strPackageName;
    }

    public WidgetPart getParent() {
        return this._widgetParent;
    }

    public boolean getSelected() {
        return this._bSelected;
    }

    public int getStatementLength() {
        return this._iStatementLength;
    }

    public int getStatementOffset() {
        return this._iStatementOffset;
    }

    public String getTypeID() {
        return this._strTypeID;
    }

    public String getTypeName() {
        return this._strTypeName;
    }

    public String getVariableName() {
        return this._strVariableName;
    }

    public String getExtraInfo(String name) {
        String extraInfo = (String)this.getFromCache(name);
        if (extraInfo != null) {
            return extraInfo;
        }
        if (this._strExtraInfo == null) {
            return null;
        }
        int begin = this._strExtraInfo.indexOf(String.valueOf(name) + "=");
        if (begin >= 0) {
            int end = this._strExtraInfo.indexOf(59, begin);
            extraInfo = this._strExtraInfo.substring(begin + name.length() + 1, end);
            this.putIntoCache(name, extraInfo);
            return extraInfo;
        }
        return null;
    }

    public void printWidgetTree(int iIndentation) {
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < iIndentation) {
            strb.append("  ");
            ++i;
        }
        strb.append(this.toString());
        System.out.println(strb.toString());
        Iterator iterChildren = this._listChildren.iterator();
        while (iterChildren.hasNext()) {
            ((WidgetPart)iterChildren.next()).printWidgetTree(iIndentation + 1);
        }
    }

    public void removeAllChildren() {
        this._listChildren.clear();
    }

    public void setBounds(Rectangle rectBounds) {
        this._rectBounds.x = rectBounds.x;
        this._rectBounds.y = rectBounds.y;
        this._rectBounds.width = Math.max(rectBounds.width, MIN_PART_WIDTH);
        this._rectBounds.height = Math.max(rectBounds.height, MIN_PART_HEIGHT);
    }

    public void setBoundsDragging(Rectangle rectDragging) {
        this._rectDragging.x = rectDragging.x;
        this._rectDragging.y = rectDragging.y;
        this._rectDragging.width = rectDragging.width;
        this._rectDragging.height = rectDragging.height;
    }

    public void setBoundsDraggingOrigin(Point ptOrigin) {
        this._rectDragging.x = ptOrigin.x;
        this._rectDragging.y = ptOrigin.y;
    }

    public void setBoundsOrigin(Point ptOrigin) {
        this._rectBounds.x = ptOrigin.x;
        this._rectBounds.y = ptOrigin.y;
    }

    public void setMouseOver(boolean bMouseOver) {
        this._bMouseOver = bMouseOver;
    }

    public void setMoveable(boolean bMoveable) {
        this._bMoveable = bMoveable;
    }

    public void setPackageName(String strPackageName) {
        this._strPackageName = strPackageName;
    }

    public void setParentWidget(WidgetPart widgetParent) {
        this._widgetParent = widgetParent;
    }

    public void setSelected(boolean bSelected) {
        this._bSelected = bSelected;
    }

    public void setStatementLength(int iStatementLength) {
        this._iStatementLength = iStatementLength;
    }

    public void setStatementOffset(int iStatementOffset) {
        this._iStatementOffset = iStatementOffset;
    }

    public void setStatementPosition(int iStatementOffset, int iStatementLength) {
        this._iStatementOffset = iStatementOffset;
        this._iStatementLength = iStatementLength;
    }

    public void setTypeID(String strTypeID) {
        this._strTypeID = strTypeID;
    }

    public void setTypeName(String strTypeName) {
        this._strTypeName = strTypeName;
    }

    public void setVariableName(String strVariableName) {
        this._strVariableName = strVariableName;
    }

    public void setExtraInfo(String strExtraInfo) {
        this._strExtraInfo = strExtraInfo;
    }

    public boolean isSameWith(WidgetPart other) {
        if (other == null) {
            return false;
        }
        return this._counter == other._counter;
    }

    public void putIntoCache(String key, Object value) {
        this._tempInfoCache.put(key, value);
    }

    public Object getFromCache(String key) {
        return this._tempInfoCache.get(key);
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        strb.append("typeName[");
        strb.append(this._strTypeName);
        strb.append("] typeID[");
        strb.append(this._strTypeID);
        strb.append("] package[");
        strb.append(this._strPackageName);
        strb.append("] varName[");
        strb.append(this._strVariableName);
        strb.append("] statement[offset:");
        strb.append(this._iStatementOffset);
        strb.append(" length:");
        strb.append(this._iStatementLength);
        strb.append("] bounds[x:");
        strb.append(this._rectBounds.x);
        strb.append(" y:");
        strb.append(this._rectBounds.y);
        strb.append(" w:");
        strb.append(this._rectBounds.width);
        strb.append(" h:");
        strb.append(this._rectBounds.height);
        strb.append("] moveable[");
        strb.append(this._bMoveable);
        strb.append("] extrainof[");
        strb.append(this._strExtraInfo);
        strb.append("]");
        return strb.toString();
    }

    public boolean isBidiBoundsFixed() {
        return this._bidiBoundsFixed;
    }

    public void setBidiBoundsFixed(boolean b) {
        this._bidiBoundsFixed = b;
    }
}

