/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers;

import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers.BindingHandlerHelper;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers.BindingHandlerManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers.DataTypeBindingHandler;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertDataModel;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertDataNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertDataNodeFactory;

public class ArrayTypeBindingHandler
extends DataTypeBindingHandler {
    @Override
    public void handle(IDataBinding dataBinding, ITypeBinding typeBinding, InsertDataModel insertDataModel) {
        Object parent;
        IAnnotationBinding displayNameAnnotationBinding;
        ArrayTypeBinding arrayTypeBinding = (ArrayTypeBinding)typeBinding;
        String bindingName = (String)insertDataModel.getContext().get("BINDING_NAME");
        InsertDataNode insertDataNode = InsertDataNodeFactory.newInsertDataNode(insertDataModel, bindingName, dataBinding.getType().getName());
        insertDataNode.setArray(true);
        insertDataNode.setContainer(false);
        int elementTypeKind = arrayTypeBinding.getElementType().getKind();
        if (elementTypeKind == 3) {
            PrimitiveTypeBinding primitiveTypeBinding = (PrimitiveTypeBinding)arrayTypeBinding.getElementType();
            insertDataNode.setNodeType("TYPE_PRIMITIVE_ALL");
            insertDataNode.addNodeTypeDetail(BindingHandlerHelper.getPrimitiveInsertDataNodeTypeDetail(primitiveTypeBinding));
        }
        if (elementTypeKind == 17) {
            DataItemBinding dataItemBinding = (DataItemBinding)arrayTypeBinding.getElementType();
            PrimitiveTypeBinding primitiveTypeBinding = dataItemBinding.getPrimitiveTypeBinding();
            insertDataNode.setNodeType("TYPE_PRIMITIVE_ALL");
            insertDataNode.addNodeTypeDetail(BindingHandlerHelper.getPrimitiveInsertDataNodeTypeDetail(primitiveTypeBinding));
        }
        if (elementTypeKind == 7) {
            insertDataNode.setNodeType("TYPE_RECORD_ALL");
        }
        if ((displayNameAnnotationBinding = dataBinding.getAnnotation(BindingHandlerHelper.EGLUI, "displayName")) != null) {
            insertDataNode.setLabelText((String)displayNameAnnotationBinding.getValue());
        }
        if ((parent = insertDataModel.getContext().get("PARENT_INSERT_DATA_NODE")) == null) {
            insertDataModel.addRootDataNode(insertDataNode);
        } else {
            InsertDataNode parentInsertDataNode = (InsertDataNode)parent;
            if (!parentInsertDataNode.getBindingName().equals(insertDataNode.getBindingName())) {
                parentInsertDataNode.addChild(insertDataNode);
                if (parentInsertDataNode.getNodeType().equals("TYPE_RECORD_ALL")) {
                    parentInsertDataNode.removeNodeTypeDetail("TYPE_RECORD_SIMPLE");
                    if (insertDataNode.getNodeType().equals("TYPE_PRIMITIVE_ALL")) {
                        parentInsertDataNode.addNodeTypeDetail("TYPE_RECORD_WITH_PRIMITIVE_ARRAY");
                    }
                    if (insertDataNode.getNodeType().equals("TYPE_RECORD_ALL")) {
                        parentInsertDataNode.addNodeTypeDetail("TYPE_RECORD_WITH_RECORD_ARRAY");
                    }
                }
            }
        }
        insertDataModel.getContext().set("PARENT_INSERT_DATA_NODE", insertDataNode);
        BindingHandlerManager.getInstance().handle(dataBinding, arrayTypeBinding.getElementType(), insertDataModel);
    }
}

