/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers.ArrayTypeBindingHandler;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers.DataItemBindingHandler;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers.FlexibleRecordBindingHandler;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers.IDataTypeBindingHandler;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers.PrimitiveTypeBindingHandler;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertDataModel;

public class BindingHandlerManager {
    private static BindingHandlerManager instance;
    private Map<String, IDataTypeBindingHandler> bindingHandlerRegister = new HashMap<String, IDataTypeBindingHandler>();

    private BindingHandlerManager() {
        this.bindingHandlerRegister.put(this.parseIntToString(7), new FlexibleRecordBindingHandler());
        this.bindingHandlerRegister.put(this.parseIntToString(3), new PrimitiveTypeBindingHandler());
        this.bindingHandlerRegister.put(this.parseIntToString(17), new DataItemBindingHandler());
        this.bindingHandlerRegister.put(this.parseIntToString(2), new ArrayTypeBindingHandler());
    }

    public static BindingHandlerManager getInstance() {
        if (instance == null) {
            instance = new BindingHandlerManager();
        }
        return instance;
    }

    public void handle(IDataBinding dataBinding, ITypeBinding typeBinding, InsertDataModel insertDataModel) {
        IDataTypeBindingHandler handler = this.bindingHandlerRegister.get(this.parseIntToString(typeBinding.getKind()));
        if (handler != null) {
            handler.handle(dataBinding, typeBinding, insertDataModel);
        }
    }

    private String parseIntToString(int i) {
        return Integer.toString(i);
    }
}

