/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.wizards.newvariable;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvEditor;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvHelp;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.newvariable.NewEGLVariableWizardUtil;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.util.EGLNameValidator;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.util.NameFinder;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class NewEGLVariableWizardPage
extends WizardPage {
    private EvEditor evEditor;
    private PartDeclarationInfo selectedPartDeclarationInfo;
    private String fieldName;
    private String fieldType;
    private String fieldTypePackage;
    private boolean isArray;
    private boolean hasDimensions;
    private String firstDimension;
    private String secondDimension;
    private String[] supportedPrimitiveTypes;
    private Group typeCreationGroup;
    private Composite typeAreaComposite;
    private Composite primitiveTypeComposite;
    private Composite dataItemComposite;
    private Composite recordComposite;
    private Text fieldNameText;
    private Combo dataTypeCombo;
    private Text searchDataItemText;
    private Text searchRecordText;
    private Table searchDataItemTable;
    private Table searchRecordTable;
    private Text previewText;
    private Text firstDimensionsText;
    private Text secondDimensionsText;
    private Button isArrayButton;

    protected NewEGLVariableWizardPage(EvEditor evEditor) {
        super(Messages.NL_NEVWP_Title);
        this.setTitle(Messages.NL_NEVWP_Title);
        this.setDescription(Messages.NL_NEVWP_Description);
        this.evEditor = evEditor;
        this.supportedPrimitiveTypes = new String[]{"string", "boolean", "date", "timestamp", "smallint", "int", "bigint", "smallfloat", "float", "decimal"};
        NameFinder.getInstance().initralize(evEditor.getEditorInput());
    }

    public String getFieldTypePackage() {
        return this.fieldTypePackage;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public String getTemplate() {
        String preivew = this.previewText.getText();
        String template = preivew.substring(preivew.lastIndexOf(" "), preivew.length() - 1).trim();
        return template;
    }

    public void createControl(Composite parent) {
        EvHelp.setHelp((Control)parent, EvHelp.NEW_EGL_VARIABLE_WIZARD);
        this.setPageComplete(false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createNewDataVariableArea(composite);
        this.createPreviewArea(composite);
        this.setControl((Control)composite);
    }

    private void clean() {
        this.setPageComplete(false);
        this.fieldName = null;
        this.fieldType = null;
        this.fieldTypePackage = null;
        this.firstDimension = null;
        this.secondDimension = null;
        this.isArray = false;
        this.fieldNameText.setText("");
        this.dataTypeCombo.deselectAll();
        this.searchDataItemText.setText("");
        this.searchRecordText.setText("");
        this.searchDataItemTable.deselectAll();
        this.searchRecordTable.deselectAll();
        this.previewText.setText("");
        this.firstDimensionsText.setText("");
        this.secondDimensionsText.setText("");
        this.firstDimensionsText.setEnabled(false);
        this.secondDimensionsText.setEnabled(false);
    }

    private void createNewDataVariableArea(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(1808));
        group.setLayout((Layout)new GridLayout(3, false));
        Group typeSelectionGroup = new Group((Composite)group, 0);
        typeSelectionGroup.setText(Messages.NL_NEVWP_Type_Selection_Group);
        typeSelectionGroup.setLayoutData((Object)new GridData(2));
        typeSelectionGroup.setLayout((Layout)new GridLayout(1, false));
        final Button recordButton = new Button((Composite)typeSelectionGroup, 16);
        recordButton.setText(Messages.NL_NEVWP_Record_Button);
        recordButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (recordButton.getSelection()) {
                    NewEGLVariableWizardPage.this.clean();
                    ((StackLayout)((NewEGLVariableWizardPage)NewEGLVariableWizardPage.this).typeAreaComposite.getLayout()).topControl = NewEGLVariableWizardPage.this.recordComposite;
                    NewEGLVariableWizardPage.this.typeAreaComposite.layout();
                    NewEGLVariableWizardPage.this.isArrayButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button primitiveTypeButton = new Button((Composite)typeSelectionGroup, 16);
        primitiveTypeButton.setText(Messages.NL_NEVWP_Primitive_Type_Button);
        primitiveTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (primitiveTypeButton.getSelection()) {
                    NewEGLVariableWizardPage.this.clean();
                    ((StackLayout)((NewEGLVariableWizardPage)NewEGLVariableWizardPage.this).typeAreaComposite.getLayout()).topControl = NewEGLVariableWizardPage.this.primitiveTypeComposite;
                    NewEGLVariableWizardPage.this.typeAreaComposite.layout();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.typeCreationGroup = new Group((Composite)group, 0);
        this.typeCreationGroup.setText(Messages.NL_NEVWP_Type_Creation_Group);
        this.typeCreationGroup.setLayoutData((Object)new GridData(1808));
        this.typeCreationGroup.setLayout((Layout)new GridLayout(1, false));
        this.typeAreaComposite = new Composite((Composite)this.typeCreationGroup, 0);
        this.typeAreaComposite.setLayoutData((Object)new GridData(1808));
        this.typeAreaComposite.setLayout((Layout)new StackLayout());
        this.createPrimitiveTypeArea();
        this.createDataItemArea();
        this.createRecordArea();
        Label fieldNameLabel = new Label((Composite)this.typeCreationGroup, 0);
        fieldNameLabel.setText(Messages.NL_NEVWP_Field_Name_Label);
        this.fieldNameText = new Text((Composite)this.typeCreationGroup, 2048);
        this.fieldNameText.setLayoutData((Object)new GridData(768));
        this.fieldNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewEGLVariableWizardPage.this.isFieldNameValid(NewEGLVariableWizardPage.this.fieldNameText.getText())) {
                    NewEGLVariableWizardPage.this.fieldName = NewEGLVariableWizardPage.this.fieldNameText.getText();
                    NewEGLVariableWizardPage.this.updatePreview();
                } else {
                    NewEGLVariableWizardPage.this.setPageComplete(false);
                }
            }
        });
        Group arrayPropertiesGroup = new Group((Composite)group, 0);
        arrayPropertiesGroup.setText(Messages.NL_NEVWP_Array_Properties_Group);
        arrayPropertiesGroup.setLayoutData((Object)new GridData(2));
        arrayPropertiesGroup.setLayout((Layout)new GridLayout(1, false));
        this.isArrayButton = new Button((Composite)arrayPropertiesGroup, 32);
        this.isArrayButton.setText(Messages.NL_NEVWP_Is_Array_Button);
        this.isArrayButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (NewEGLVariableWizardPage.this.isArrayButton.getSelection()) {
                    NewEGLVariableWizardPage.this.isArray = true;
                    NewEGLVariableWizardPage.this.updatePreview();
                } else {
                    NewEGLVariableWizardPage.this.isArray = false;
                    NewEGLVariableWizardPage.this.updatePreview();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private boolean isFieldNameValid(String fieldName) {
        this.setErrorMessage(null);
        if (fieldName == null || fieldName.equals("")) {
            this.setErrorMessage(Messages.NL_NEVWP_Error_Message_Field_Name_Is_None);
            return false;
        }
        if (NameFinder.getInstance().isFieldNameExist(fieldName)) {
            this.setErrorMessage(Messages.NL_NEVWP_Error_Message_Field_Name_Is_Duplicate);
            return false;
        }
        ArrayList messages = EGLNameValidator.validateEGLName(fieldName, "Part", null);
        if (!messages.isEmpty()) {
            this.setErrorMessage(Messages.NL_NEVWP_Error_Message_Field_Name_Is_Not_Valid);
            return false;
        }
        return true;
    }

    private void createPrimitiveTypeArea() {
        this.primitiveTypeComposite = new Composite(this.typeAreaComposite, 0);
        this.primitiveTypeComposite.setLayout((Layout)new GridLayout(1, false));
        Group primitiveTypeDetailGroup = new Group(this.primitiveTypeComposite, 0);
        primitiveTypeDetailGroup.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Group);
        primitiveTypeDetailGroup.setLayout((Layout)new GridLayout(1, false));
        primitiveTypeDetailGroup.setLayoutData((Object)new GridData(1808));
        Composite primitiveTypeDetailComposite = new Composite((Composite)primitiveTypeDetailGroup, 0);
        primitiveTypeDetailComposite.setLayoutData((Object)new GridData(1808));
        primitiveTypeDetailComposite.setLayout((Layout)new FillLayout(512));
        Composite dataTypeComposite = new Composite(primitiveTypeDetailComposite, 0);
        dataTypeComposite.setLayout((Layout)new GridLayout(1, false));
        Label dataTypeLabel = new Label(dataTypeComposite, 0);
        dataTypeLabel.setText(Messages.NL_NEVWP_Primitive_Type_Label);
        this.dataTypeCombo = new Combo(dataTypeComposite, 2056);
        this.dataTypeCombo.setItems(this.supportedPrimitiveTypes);
        Composite dimensionsComposite = new Composite(primitiveTypeDetailComposite, 0);
        dimensionsComposite.setLayout((Layout)new GridLayout(3, false));
        Label dimensionsLabel = new Label(dimensionsComposite, 0);
        GridData dimensionsLabelGridData = new GridData();
        dimensionsLabelGridData.horizontalSpan = 3;
        dimensionsLabel.setText(Messages.NL_NEVWP_Primitive_Dimensions_Label);
        dimensionsLabel.setLayoutData((Object)dimensionsLabelGridData);
        this.firstDimensionsText = new Text(dimensionsComposite, 2048);
        this.firstDimensionsText.setEnabled(false);
        Label middleDimensionsLabel = new Label(dimensionsComposite, 0);
        middleDimensionsLabel.setText(",");
        this.secondDimensionsText = new Text(dimensionsComposite, 2048);
        this.secondDimensionsText.setEnabled(false);
        this.firstDimensionsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String secondDim;
                String firstDim = NewEGLVariableWizardPage.this.firstDimensionsText.getText();
                if (NewEGLVariableWizardPage.this.isDimensionsValid(firstDim, secondDim = NewEGLVariableWizardPage.this.secondDimensionsText.getText())) {
                    NewEGLVariableWizardPage.this.firstDimension = firstDim;
                    NewEGLVariableWizardPage.this.updatePreview();
                } else {
                    NewEGLVariableWizardPage.this.setPageComplete(false);
                }
            }
        });
        this.secondDimensionsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String secondDim;
                String firstDim = NewEGLVariableWizardPage.this.firstDimensionsText.getText();
                if (NewEGLVariableWizardPage.this.isDimensionsValid(firstDim, secondDim = NewEGLVariableWizardPage.this.secondDimensionsText.getText())) {
                    NewEGLVariableWizardPage.this.secondDimension = secondDim;
                    NewEGLVariableWizardPage.this.updatePreview();
                } else {
                    NewEGLVariableWizardPage.this.setPageComplete(false);
                }
            }
        });
        final Text typeDetailMessageText = new Text((Composite)primitiveTypeDetailGroup, 8);
        typeDetailMessageText.setLayoutData((Object)new GridData(768));
        this.dataTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = NewEGLVariableWizardPage.this.dataTypeCombo.getSelectionIndex();
                NewEGLVariableWizardPage.this.fieldType = NewEGLVariableWizardPage.this.supportedPrimitiveTypes[index];
                NewEGLVariableWizardPage.this.setDefaultFieldName(NewEGLVariableWizardPage.this.fieldNameText);
                this.updateTypeDetailMessageText();
                NewEGLVariableWizardPage.this.updatePreview();
            }

            private void disableDimensionsComposite() {
                NewEGLVariableWizardPage.this.firstDimensionsText.setEnabled(false);
                NewEGLVariableWizardPage.this.secondDimensionsText.setEnabled(false);
                NewEGLVariableWizardPage.this.hasDimensions = false;
            }

            private void enableDimensionsComposite(String firstDim, String secondDim) {
                NewEGLVariableWizardPage.this.firstDimensionsText.setEnabled(true);
                NewEGLVariableWizardPage.this.secondDimensionsText.setEnabled(true);
                NewEGLVariableWizardPage.this.secondDimensionsText.setEditable(true);
                NewEGLVariableWizardPage.this.hasDimensions = true;
                NewEGLVariableWizardPage.this.firstDimensionsText.setText(firstDim);
                NewEGLVariableWizardPage.this.secondDimensionsText.setText(secondDim);
                NewEGLVariableWizardPage.this.firstDimension = firstDim;
                NewEGLVariableWizardPage.this.secondDimension = secondDim;
            }

            private void updateTypeDetailMessageText() {
                if (NewEGLVariableWizardPage.this.fieldType != null) {
                    if (NewEGLVariableWizardPage.this.fieldType.equals("bigint")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_Bigint);
                        this.disableDimensionsComposite();
                    }
                    if (NewEGLVariableWizardPage.this.fieldType.equals("bin")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_Bin);
                        this.enableDimensionsComposite("4", "0");
                        NewEGLVariableWizardPage.this.secondDimensionsText.setEditable(false);
                    }
                    if (NewEGLVariableWizardPage.this.fieldType.equals("boolean")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_Boolean);
                        this.disableDimensionsComposite();
                    }
                    if (NewEGLVariableWizardPage.this.fieldType.equals("date")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_Date);
                        this.disableDimensionsComposite();
                    }
                    if (NewEGLVariableWizardPage.this.fieldType.equals("decimal")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_Decimal);
                        this.enableDimensionsComposite("8", "0");
                    }
                    if (NewEGLVariableWizardPage.this.fieldType.equals("float")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_Float);
                        this.disableDimensionsComposite();
                    }
                    if (NewEGLVariableWizardPage.this.fieldType.equals("int")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_Int);
                        this.disableDimensionsComposite();
                    }
                    if (NewEGLVariableWizardPage.this.fieldType.equals("money")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_Money);
                        this.enableDimensionsComposite("16", "2");
                    }
                    if (NewEGLVariableWizardPage.this.fieldType.equals("num")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_Num);
                        this.enableDimensionsComposite("16", "2");
                    }
                    if (NewEGLVariableWizardPage.this.fieldType.equals("smallfloat")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_Smallfloat);
                        this.disableDimensionsComposite();
                    }
                    if (NewEGLVariableWizardPage.this.fieldType.equals("smallint")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_Smallint);
                        this.disableDimensionsComposite();
                    }
                    if (NewEGLVariableWizardPage.this.fieldType.equals("string")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_String);
                        this.disableDimensionsComposite();
                    }
                    if (NewEGLVariableWizardPage.this.fieldType.equals("time")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_Time);
                        this.disableDimensionsComposite();
                    }
                    if (NewEGLVariableWizardPage.this.fieldType.equals("timestamp")) {
                        typeDetailMessageText.setText(Messages.NL_NEVWP_Primitive_Type_Detail_Message_Timestamp);
                        this.disableDimensionsComposite();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private boolean isDimensionsValid(String firstDim, String secondDim) {
        this.setErrorMessage(null);
        if (this.firstDimensionsText.isEnabled() && this.secondDimensionsText.isEnabled()) {
            int iFirstDim;
            block16: {
                block15: {
                    block14: {
                        block12: {
                            int iSecondDim;
                            block13: {
                                block11: {
                                    if (firstDim == null || firstDim.equals("")) {
                                        this.setErrorMessage(Messages.NL_NEVWP_Error_Message_Primitive_Type_Dimensions_Is_None);
                                        return false;
                                    }
                                    try {
                                        iFirstDim = Integer.parseInt(firstDim);
                                        if (iFirstDim >= 0) break block11;
                                        this.setErrorMessage(Messages.NL_NEVWP_Error_Message_Primitive_Type_Dimensions_Is_None);
                                        return false;
                                    }
                                    catch (Exception exception) {
                                        this.setErrorMessage(Messages.NL_NEVWP_Error_Message_Primitive_Type_Dimensions_Is_None);
                                        return false;
                                    }
                                }
                                if (secondDim == null || secondDim.equals("")) break block12;
                                iSecondDim = Integer.parseInt(secondDim);
                                if (iSecondDim >= 0) break block13;
                                this.setErrorMessage(Messages.NL_NEVWP_Error_Message_Primitive_Type_Dimensions_Is_None);
                                return false;
                            }
                            if (iFirstDim >= iSecondDim) break block12;
                            this.setErrorMessage(Messages.NL_NEVWP_Error_Message_Primitive_Type_Dimensions_First_Is_Small_Then_Second);
                            return false;
                        }
                        if (!this.fieldType.equals("bin") || iFirstDim == 4 || iFirstDim == 9 || iFirstDim == 18) break block14;
                        this.setErrorMessage(Messages.NL_NEVWP_Error_Message_Primitive_Type_Dimensions_Is_Not_Valid);
                        return false;
                    }
                    if (!this.fieldType.equals("decimal") || iFirstDim >= 1 && iFirstDim <= 32) break block15;
                    this.setErrorMessage(Messages.NL_NEVWP_Error_Message_Primitive_Type_Dimensions_Is_Not_Valid);
                    return false;
                }
                if (!this.fieldType.equals("money") || iFirstDim >= 2 && iFirstDim <= 32) break block16;
                this.setErrorMessage(Messages.NL_NEVWP_Error_Message_Primitive_Type_Dimensions_Is_Not_Valid);
                return false;
            }
            if (this.fieldType.equals("num") && (iFirstDim < 1 || iFirstDim > 32)) {
                this.setErrorMessage(Messages.NL_NEVWP_Error_Message_Primitive_Type_Dimensions_Is_Not_Valid);
                return false;
            }
        }
        return true;
    }

    private void createDataItemArea() {
        this.dataItemComposite = new Composite(this.typeAreaComposite, 0);
        this.dataItemComposite.setLayout((Layout)new GridLayout(1, false));
        Group searchDataItemGroup = new Group(this.dataItemComposite, 0);
        searchDataItemGroup.setText(Messages.NL_NEVWP_Search_DataItem_Group);
        searchDataItemGroup.setLayout((Layout)new GridLayout(1, false));
        searchDataItemGroup.setLayoutData((Object)new GridData(1808));
        this.searchDataItemText = new Text((Composite)searchDataItemGroup, 2048);
        this.searchDataItemText.setLayoutData((Object)new GridData(768));
        this.searchDataItemText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewEGLVariableWizardPage.this.searchDataItemTable.removeAll();
                NewEGLVariableWizardPage.this.fillSearchTable(NewEGLVariableWizardPage.this.searchDataItemTable, NewEGLVariableWizardUtil.DataType.DataItem, NewEGLVariableWizardPage.this.searchDataItemText.getText());
            }
        });
        this.searchDataItemTable = new Table((Composite)searchDataItemGroup, 2816);
        GridData searchDataItemTableGridData = new GridData(1808);
        searchDataItemTableGridData.heightHint = 100;
        this.searchDataItemTable.setLayoutData((Object)searchDataItemTableGridData);
        this.fillSearchTable(this.searchDataItemTable, NewEGLVariableWizardUtil.DataType.DataItem, null);
        this.searchDataItemTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewEGLVariableWizardPage.this.handleSearchTableSelection(e);
                NewEGLVariableWizardPage.this.fieldType = NewEGLVariableWizardPage.this.selectedPartDeclarationInfo.getPartName();
                NewEGLVariableWizardPage.this.fieldTypePackage = NewEGLVariableWizardPage.this.selectedPartDeclarationInfo.getPackageName();
                NewEGLVariableWizardPage.this.setDefaultFieldName(NewEGLVariableWizardPage.this.fieldNameText);
                NewEGLVariableWizardPage.this.updatePreview();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createRecordArea() {
        this.recordComposite = new Composite(this.typeAreaComposite, 0);
        this.recordComposite.setLayout((Layout)new GridLayout(1, false));
        Group searchRecordGroup = new Group(this.recordComposite, 0);
        searchRecordGroup.setText(Messages.NL_NEVWP_Search_Record_Group);
        searchRecordGroup.setLayout((Layout)new GridLayout(1, false));
        searchRecordGroup.setLayoutData((Object)new GridData(1808));
        this.searchRecordText = new Text((Composite)searchRecordGroup, 2048);
        this.searchRecordText.setLayoutData((Object)new GridData(768));
        this.searchRecordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewEGLVariableWizardPage.this.searchRecordTable.removeAll();
                NewEGLVariableWizardPage.this.fillSearchTable(NewEGLVariableWizardPage.this.searchRecordTable, NewEGLVariableWizardUtil.DataType.Record, NewEGLVariableWizardPage.this.searchRecordText.getText());
            }
        });
        this.searchRecordTable = new Table((Composite)searchRecordGroup, 2816);
        GridData searchRecordTableGridData = new GridData(1808);
        searchRecordTableGridData.heightHint = 100;
        this.searchRecordTable.setLayoutData((Object)searchRecordTableGridData);
        this.fillSearchTable(this.searchRecordTable, NewEGLVariableWizardUtil.DataType.Record, null);
        this.searchRecordTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewEGLVariableWizardPage.this.handleSearchTableSelection(e);
                NewEGLVariableWizardPage.this.fieldType = NewEGLVariableWizardPage.this.selectedPartDeclarationInfo.getPartName();
                NewEGLVariableWizardPage.this.fieldTypePackage = NewEGLVariableWizardPage.this.selectedPartDeclarationInfo.getPackageName();
                NewEGLVariableWizardPage.this.setDefaultFieldName(NewEGLVariableWizardPage.this.fieldNameText);
                NewEGLVariableWizardPage.this.updatePreview();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setDefaultFieldName(Text fieldNameText) {
        String tempFieldName;
        this.fieldName = tempFieldName = "my" + this.fieldType;
        int i = 0;
        while (NameFinder.getInstance().isFieldNameExist(this.fieldName)) {
            this.fieldName = String.valueOf(tempFieldName) + ++i;
        }
        fieldNameText.setText(this.fieldName);
    }

    private void updatePreview() {
        StringBuffer sbPreview = new StringBuffer();
        if (this.fieldName != null && this.fieldType != null) {
            sbPreview.append(this.fieldName).append(" ").append(this.fieldType);
            if (this.hasDimensions) {
                sbPreview.append("(");
                if (this.firstDimension != null && !this.firstDimension.equals("")) {
                    sbPreview.append(this.firstDimension);
                    if (this.secondDimension != null && !this.secondDimension.equals("")) {
                        sbPreview.append(",").append(this.secondDimension);
                    }
                }
                sbPreview.append(")");
            }
            if (this.fieldType.equals("timestamp")) {
                sbPreview.append("(\"YYYYMMDD\")");
            }
            if (this.isArray) {
                sbPreview.append("[").append("]");
            }
            sbPreview.append(";");
            this.setPageComplete(true);
        }
        this.previewText.setText(sbPreview.toString());
    }

    private void fillSearchTable(Table searchTable, NewEGLVariableWizardUtil.DataType dataType, String partName) {
        List<PartDeclarationInfo> partDeclarationInfos = NewEGLVariableWizardUtil.getAvailableParts(EGLCore.create((IProject)this.evEditor.getProject()), dataType);
        for (PartDeclarationInfo partDeclarationInfo : partDeclarationInfos) {
            boolean isAddToTable = false;
            if (partName == null) {
                isAddToTable = true;
            } else if (partDeclarationInfo.getPartName().toUpperCase().startsWith(partName.toUpperCase())) {
                isAddToTable = true;
            }
            if (!isAddToTable) continue;
            StringBuffer sbRecordlabel = new StringBuffer(partDeclarationInfo.getPartName()).append(" (");
            if (partDeclarationInfo.getPackageName() != null) {
                sbRecordlabel.append(partDeclarationInfo.getPackageName()).append("/");
            }
            sbRecordlabel.append(partDeclarationInfo.getFileName()).append(".").append(partDeclarationInfo.getExtension()).append(")");
            TableItem tableItem = new TableItem(searchTable, 0);
            tableItem.setImage(NewEGLVariableWizardUtil.getImage(dataType));
            tableItem.setText(sbRecordlabel.toString());
            tableItem.setData((Object)partDeclarationInfo);
        }
    }

    private void handleSearchTableSelection(SelectionEvent e) {
        Table table = (Table)e.getSource();
        TableItem tableItem = table.getSelection()[0];
        this.selectedPartDeclarationInfo = (PartDeclarationInfo)tableItem.getData();
    }

    private void createPreviewArea(Composite composite) {
        int style = 0;
        if (Locale.getDefault().toString().toLowerCase().indexOf("ar") != -1) {
            style |= 0x2000000;
        }
        Group group = new Group(composite, style);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.NL_NEVWP_Preview_Group);
        this.previewText = new Text((Composite)group, 8);
        this.previewText.setLayoutData((Object)new GridData(768));
    }

    class SupportedPrimitiveType {
        public static final String STRING = "string";
        public static final String DATE = "date";
        public static final String TIME = "time";
        public static final String TIMESTAMP = "timestamp";
        public static final String SMALLINT = "smallint";
        public static final String INT = "int";
        public static final String BIGINT = "bigint";
        public static final String BIN = "bin";
        public static final String SMALLFLOAT = "smallfloat";
        public static final String FLOAT = "float";
        public static final String DECIMAL = "decimal";
        public static final String NUM = "num";
        public static final String NUMBER = "number";
        public static final String MONEY = "money";
        public static final String BOOLEAN = "boolean";

        SupportedPrimitiveType() {
        }
    }
}

