/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.edt.debug.core.breakpoints.EGLLineBreakpoint;
import org.eclipse.edt.debug.internal.ui.actions.BreakpointUtils;
import org.eclipse.edt.ide.ui.editor.IEGLEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointsTarget
implements IToggleBreakpointsTargetExtension {
    public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection) throws CoreException {
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        Job job = new Job("Toggle Line Breakpoint"){

            protected IStatus run(IProgressMonitor monitor) {
                ITextEditor editor = BreakpointUtils.getEditor(part);
                if (editor != null) {
                    IDocumentProvider provider = editor.getDocumentProvider();
                    if (provider == null) {
                        return Status.CANCEL_STATUS;
                    }
                    IEditorInput input = editor.getEditorInput();
                    if (!(input instanceof IFileEditorInput)) {
                        return Status.CANCEL_STATUS;
                    }
                    IDocument document = provider.getDocument((Object)input);
                    if (document != null) {
                        try {
                            ITextSelection textSelection = (ITextSelection)selection;
                            IFile file = ((IFileEditorInput)input).getFile();
                            EGLLineBreakpoint breakpoint = BreakpointUtils.eglLineBreakpointExists((IResource)file, textSelection.getStartLine() + 1);
                            if (breakpoint != null) {
                                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                            } else {
                                int line;
                                if (editor instanceof IEGLEditor) {
                                    IEGLEditor eglEditor = (IEGLEditor)editor;
                                    line = eglEditor.getLineAtOffset(BreakpointUtils.getStatementNode(eglEditor, textSelection.getStartLine()).getOffset()) + 1;
                                } else {
                                    line = textSelection.getStartLine() + 1;
                                }
                                if (line != textSelection.getStartLine() + 1) {
                                    breakpoint = BreakpointUtils.eglLineBreakpointExists((IResource)file, line);
                                }
                                if (breakpoint != null) {
                                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                                } else {
                                    new EGLLineBreakpoint((IResource)file, line, -1, -1, true, false);
                                }
                            }
                        }
                        catch (CoreException coreException) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            ITextEditor textEditor = BreakpointUtils.getEditor(part);
            IEditorInput input = textEditor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                try {
                    if (BreakpointUtils.eglLineBreakpointExists((IResource)((IFileEditorInput)textEditor.getEditorInput()).getFile(), textSelection.getStartLine() + 1) != null) {
                        return true;
                    }
                }
                catch (CoreException coreException) {}
            }
            if (textEditor instanceof IEGLEditor) {
                return BreakpointUtils.isBreakpointValid((IEGLEditor)textEditor, textSelection.getStartLine());
            }
        }
        return false;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

