/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal;

import java.util.ArrayList;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.ISourceReference;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.editor.DocumentProvider;
import org.eclipse.edt.ide.ui.internal.util.EditorUtility;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IDocumentProvider;

public final class EGLUI {
    public static final String ID_ACTION_SET = "org.eclipse.edt.ide.ui.EGLActionSet";
    public static final String ID_NON_WEB_WIZARD_ACTION_SET = "org.eclipse.edt.ide.ui.EGLProjectWizardActionSet";
    public static final String ID_CU_EDITOR = "org.eclipse.edt.ide.ui.CompilationUnitEditor";
    public static final String ID_PACKAGES = "org.eclipse.edt.ide.ui.PackageExplorer";

    private EGLUI() {
    }

    public static IEditorPart openInEditor(IEGLElement element) throws EGLModelException, PartInitException {
        return EditorUtility.openInEditor(element);
    }

    public static void revealInEditor(IEditorPart part, ISourceReference element) {
        if (element instanceof IEGLElement) {
            EGLUI.revealInEditor(part, (IEGLElement)element);
        }
    }

    public static void revealInEditor(IEditorPart part, IEGLElement element) {
        EditorUtility.revealInEditor(part, element);
    }

    public static IWorkingCopy[] getSharedWorkingCopies() {
        return EGLCore.getSharedWorkingCopies((IBufferFactory)EGLUI.getBufferFactory());
    }

    public static IWorkingCopy[] getSharedWorkingCopiesOnEGLPath() {
        IWorkingCopy[] wcs = EGLUI.getSharedWorkingCopies();
        ArrayList<IWorkingCopy> result = new ArrayList<IWorkingCopy>(wcs.length);
        int i = 0;
        while (i < wcs.length) {
            IEGLElement je;
            IWorkingCopy wc = wcs[i];
            if (wc instanceof IEGLElement && (je = (IEGLElement)wc).getEGLProject().isOnEGLPath(je)) {
                result.add(wc);
            }
            ++i;
        }
        return result.toArray(new IWorkingCopy[result.size()]);
    }

    public static IBufferFactory getBufferFactory() {
        DocumentProvider provider = EDTUIPlugin.getDefault().getEGLDocumentProvider();
        if (provider != null) {
            return provider.getBufferFactory();
        }
        return null;
    }

    public static IDocumentProvider getDocumentProvider() {
        return EDTUIPlugin.getDefault().getEGLDocumentProvider();
    }
}

