/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRootContainer;
import org.eclipse.edt.ide.core.internal.model.util.EGLModelUtil;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLElementDelta;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IParent;
import org.eclipse.edt.ide.core.model.ISourceReference;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.IWorkingCopyProvider;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class StandardEGLElementContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers = false;
    protected boolean fProvideWorkingCopy = false;

    public StandardEGLElementContentProvider() {
    }

    public StandardEGLElementContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        this.fProvideMembers = provideMembers;
        this.fProvideWorkingCopy = provideWorkingCopy;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean b) {
        this.fProvideMembers = b;
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public void setProvideWorkingCopy(boolean b) {
        this.fProvideWorkingCopy = b;
    }

    @Override
    public boolean providesWorkingCopies() {
        return this.fProvideWorkingCopy;
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            if (element instanceof IEGLModel) {
                return this.getEGLProjects((IEGLModel)element);
            }
            if (element instanceof IProject && ((IProject)element).hasNature(EGLCore.NATURE_ID)) {
                Object[] rawChildren = this.getPackageFragmentRoots(EGLCore.create((IProject)((IProject)element)));
                return this.removeNonEGLElements(rawChildren);
            }
            if (element instanceof IJavaProject) {
                Object[] rawChildren = this.getPackageFragmentRoots(EGLCore.create((IProject)((IJavaProject)element).getProject()));
                return this.removeNonEGLElements(rawChildren);
            }
            if (element instanceof IEGLProject) {
                return this.getPackageFragmentRoots((IEGLProject)element);
            }
            if (element instanceof EglarPackageFragmentRootContainer) {
                return ((EglarPackageFragmentRootContainer)element).getAllJarPackageFragmentRoot();
            }
            if (element instanceof IPackageFragmentRoot) {
                return this.getPackageFragments((IPackageFragmentRoot)element);
            }
            if (element instanceof IPackageFragment) {
                return this.getPackageContents((IPackageFragment)element);
            }
            if (element instanceof IFolder) {
                return this.getResources((IFolder)element);
            }
            if (this.fProvideMembers && element instanceof ISourceReference && element instanceof IParent) {
                if (this.fProvideWorkingCopy && element instanceof IEGLFile) {
                    element = EGLModelUtil.toWorkingCopy((IEGLFile)((IEGLFile)element));
                }
                return ((IParent)element).getChildren();
            }
        }
        catch (EGLModelException eGLModelException) {
            return NO_CHILDREN;
        }
        catch (CoreException e) {
            EGLLogger.log((Object)this, e.toString());
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren(Object element) {
        Object[] children;
        IEGLProject jp;
        if (this.fProvideMembers) {
            if (element instanceof IEGLFile) {
                return true;
            }
        } else if (element instanceof IEGLFile || element instanceof IFile || element instanceof IClassFile) {
            return false;
        }
        if (element instanceof IEGLProject && !(jp = (IEGLProject)element).getProject().isOpen()) {
            return false;
        }
        if (element instanceof EglarPackageFragmentRootContainer) {
            EglarPackageFragmentRootContainer container = (EglarPackageFragmentRootContainer)element;
            return container.hasJarPackageFragmentRoot();
        }
        if (element instanceof IParent) {
            try {
                if (((IParent)element).hasChildren()) {
                    return true;
                }
            }
            catch (EGLModelException eGLModelException) {
                return true;
            }
        }
        return (children = this.getChildren(element)) != null && children.length > 0;
    }

    public Object getParent(Object element) {
        if (!this.exists(element)) {
            return null;
        }
        return this.internalGetParent(element);
    }

    protected Object[] getPackageFragments(IPackageFragmentRoot root) throws EGLModelException {
        Object[] fragments = root.getChildren();
        Object[] nonEGLResources = root.getNonEGLResources();
        if (nonEGLResources == null) {
            return fragments;
        }
        return StandardEGLElementContentProvider.concatenate(fragments, nonEGLResources);
    }

    protected Object[] getEGLPackageFragmentRoots(IEGLProject project) throws EGLModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        ArrayList<Object> list = new ArrayList<Object>();
        EglarPackageFragmentRootContainer container = null;
        boolean foundJarPkgRoot = false;
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (this.isProjectPackageFragmentRoot(root)) {
                IEGLElement[] children = root.getChildren();
                int k = 0;
                while (k < children.length) {
                    list.add(children[k]);
                    ++k;
                }
            } else if (this.hasChildren(root)) {
                if (root instanceof EglarPackageFragmentRoot && ((EglarPackageFragmentRoot)root).isBinaryProject()) {
                    if (!foundJarPkgRoot) {
                        container = new EglarPackageFragmentRootContainer(project);
                        foundJarPkgRoot = true;
                        list.add(container);
                    }
                    container.addJarPackageFragmentRoot((EglarPackageFragmentRoot)root);
                } else {
                    list.add(root);
                }
            }
            ++i;
        }
        return list.toArray();
    }

    protected Object[] getPackageFragmentRoots(IEGLProject project) throws EGLModelException {
        return StandardEGLElementContentProvider.concatenate(this.getEGLPackageFragmentRoots(project), project.getNonEGLResources());
    }

    protected Object[] getEGLProjects(IEGLModel jm) throws EGLModelException {
        return jm.getEGLProjects();
    }

    protected Object[] getIProjects(IEGLModel jm) throws EGLModelException {
        Object[] eglprojs = this.getEGLProjects(jm);
        int ilen = eglprojs.length;
        Object[] projs = new IProject[ilen];
        int i = 0;
        while (i < ilen) {
            projs[i] = ((IEGLProject)eglprojs[i]).getProject();
            ++i;
        }
        return projs;
    }

    protected Object[] getPackageContents(IPackageFragment fragment) throws EGLModelException {
        if (fragment.getKind() == 1) {
            return StandardEGLElementContentProvider.concatenate(fragment.getEGLFiles(), fragment.getNonEGLResources());
        }
        return StandardEGLElementContentProvider.concatenate(fragment.getClassFiles(), fragment.getNonEGLResources());
    }

    protected Object[] getClassFileMethods(IClassFile classFile) {
        try {
            return StandardEGLElementContentProvider.concatenate(classFile.getPart().getFields(), classFile.getPart().getFunctions());
        }
        catch (EGLModelException eGLModelException) {
            return StandardEGLElementContentProvider.concatenate(new Object[0], new Object[0]);
        }
    }

    protected Object[] getResources(IFolder folder) {
        try {
            IResource[] members = folder.members();
            ArrayList<IResource> nonEGLResources = new ArrayList<IResource>();
            int i = 0;
            while (i < members.length) {
                IEGLElement element;
                IResource o = members[i];
                if (!(o instanceof IFolder && (element = EGLCore.create((IFolder)((IFolder)o))) instanceof IPackageFragmentRoot && element.exists())) {
                    nonEGLResources.add(o);
                }
                ++i;
            }
            return nonEGLResources.toArray();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    protected boolean isClassPathChange(IEGLElementDelta delta) {
        if (delta.getElement().getElementType() != 3) {
            return false;
        }
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    protected Object skipProjectPackageFragmentRoot(IPackageFragmentRoot root) {
        try {
            if (this.isProjectPackageFragmentRoot(root)) {
                return root.getParent();
            }
            return root;
        }
        catch (EGLModelException eGLModelException) {
            return root;
        }
    }

    protected boolean isPackageFragmentEmpty(IEGLElement element) throws EGLModelException {
        IPackageFragment fragment;
        return element instanceof IPackageFragment && !(fragment = (IPackageFragment)element).hasChildren() && fragment.getNonEGLResources().length <= 0 && fragment.hasSubpackages();
    }

    protected boolean isProjectPackageFragmentRoot(IPackageFragmentRoot root) throws EGLModelException {
        IResource resource = root.getResource();
        return resource instanceof IProject;
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof IEGLElement) {
            return ((IEGLElement)element).exists();
        }
        return true;
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IEGLProject) {
            return ((IEGLProject)element).getEGLModel();
        }
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IEGLElement jParent = EGLCore.create((IResource)parent);
            if (jParent != null && jParent.exists()) {
                return jParent;
            }
            return parent;
        }
        if (element instanceof IPackageFragment) {
            IPackageFragmentRoot parent = (IPackageFragmentRoot)((IPackageFragment)element).getParent();
            return this.skipProjectPackageFragmentRoot(parent);
        }
        if (element instanceof IEGLElement) {
            IEGLElement candidate = ((IEGLElement)element).getParent();
            if (candidate != null && candidate.getElementType() == 6) {
                candidate = EGLModelUtil.toOriginal((IEGLFile)((IEGLFile)candidate));
            }
            return candidate;
        }
        return null;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }

    private Object[] removeNonEGLElements(Object[] sourceElements) {
        ArrayList<Object> resultElements = new ArrayList<Object>();
        int j = 0;
        while (j < sourceElements.length) {
            if (sourceElements[j] instanceof IEGLElement) {
                resultElements.add(sourceElements[j]);
            }
            ++j;
        }
        if (resultElements != null) {
            return resultElements.toArray();
        }
        return null;
    }
}

