/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.internal.errors.EGLPartialParser;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;
import org.eclipse.edt.ide.core.internal.errors.TokenStream;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocument;
import org.eclipse.edt.ide.ui.editor.EGLContentAssistInvocationContext;
import org.eclipse.edt.ide.ui.editor.IEGLCompletionProposalComputer;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLTemplateProposal;
import org.eclipse.edt.ide.ui.internal.templates.TemplateEngine;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;

public abstract class EGLAbstractTemplateCompletionProposalComputer
implements IEGLCompletionProposalComputer {
    private TemplateEngine fEngine;
    private EGLPartialParser parser = new EGLPartialParser();

    @Override
    public List computeCompletionProposals(EGLContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!(context instanceof EGLContentAssistInvocationContext)) {
            return Collections.EMPTY_LIST;
        }
        EGLContentAssistInvocationContext eglContext = context;
        ArrayList<EGLTemplateProposal> result = new ArrayList<EGLTemplateProposal>();
        TokenStream tokenStream = new TokenStream(this.getPrefix(eglContext.getViewer(), eglContext.getInvocationOffset()));
        tokenStream.skipPrefix();
        ArrayList prefixNodes = new ArrayList();
        ParseStack parseStack = this.parser.parse(tokenStream);
        prefixNodes.addAll(tokenStream.getPrefixNodes());
        this.fEngine = this.computeCompletionEngine(eglContext);
        if (this.fEngine != null) {
            this.fEngine.reset();
            this.fEngine.complete(tokenStream, eglContext.getViewer(), eglContext.getInvocationOffset(), parseStack, this.getPrefix(prefixNodes));
            EGLTemplateProposal[] templateResults = this.fEngine.getResults();
            int k = 0;
            while (k < templateResults.length) {
                result.add(templateResults[k]);
                ++k;
            }
        }
        return result;
    }

    protected abstract TemplateEngine computeCompletionEngine(EGLContentAssistInvocationContext var1);

    @Override
    public List computeContextInformation(EGLContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void sessionStarted() {
    }

    @Override
    public void sessionEnded() {
        if (this.fEngine != null) {
            this.fEngine.reset();
            this.fEngine = null;
        }
    }

    protected String getPrefix(ITextViewer viewer, int documentOffset) {
        EGLDocument document = (EGLDocument)viewer.getDocument();
        Node node = document.getNewModelNodeAtOffset(documentOffset);
        while (node != null && !(node instanceof Part)) {
            node = node.getParent();
        }
        int previousPartOffset = 0;
        if (node != null) {
            int currentPartOffset = node.getOffset();
            node = document.getNewModelNodeAtOffset(currentPartOffset == 0 ? 0 : currentPartOffset - 1);
            while (node != null && !(node instanceof Part)) {
                node = node.getParent();
            }
            if (node != null) {
                previousPartOffset = node.getOffset();
            }
        }
        String partialSource = "";
        try {
            partialSource = document.get(previousPartOffset, documentOffset - previousPartOffset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return partialSource;
    }

    protected String getPrefix(List prefixNodes) {
        List strippedPrefix = this.stripInitialWhitespaces(prefixNodes);
        StringBuffer buffer = new StringBuffer();
        for (ParseNode node : strippedPrefix) {
            buffer.append(this.getText(node));
        }
        return buffer.length() == 0 ? "" : buffer.toString();
    }

    private List stripInitialWhitespaces(List prefixNodes) {
        int i = 0;
        while (i < prefixNodes.size()) {
            ParseNode node = (ParseNode)prefixNodes.get(i);
            if (!node.isWhiteSpace()) {
                return prefixNodes.subList(i, prefixNodes.size());
            }
            ++i;
        }
        return new ArrayList();
    }

    private String getText(ParseNode node) {
        if (node.isTerminal()) {
            switch (((TerminalNode)node).terminalType) {
                case 7: {
                    return "#sql{}";
                }
                case 8: {
                    return "#dli{}";
                }
            }
        }
        return node.getText();
    }
}

