/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.editor.EGLContentAssistInvocationContext;
import org.eclipse.edt.ide.ui.editor.IEGLCompletionProposalComputer;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposalCategory;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposalComputerRegistry;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLTextMessages;
import org.eclipse.edt.ide.ui.internal.preferences.Messages;
import org.osgi.framework.Bundle;

final class EGLCompletionProposalComputerDescriptor {
    private static final String DEFAULT_CATEGORY_ID = "org.eclipse.edt.ide.ui.defaultProposalCategory";
    private static final String CATEGORY_ID = "categoryId";
    private static final String TYPE = "type";
    private static final String CLASS = "class";
    private static final String ACTIVATE = "activate";
    private static final String PARTITION = "partition";
    private static final Set PARTITION_SET;
    private final String fId;
    private final String fName;
    private final String fClass;
    private final boolean fActivate;
    private final Set fPartitions;
    private final IConfigurationElement fElement;
    private final EGLCompletionProposalComputerRegistry fRegistry;
    private IEGLCompletionProposalComputer fComputer;
    private final EGLCompletionProposalCategory fCategory;
    private String fLastError;
    private boolean fIsReportingDelay = false;
    private long fStart;
    boolean fTriedLoadingComputer = false;

    static {
        HashSet<String> partitions = new HashSet<String>();
        partitions.add("__dftl_partition_content_type");
        partitions.add("___egl_partitioning");
        partitions.add("__egl_singleline_comment");
        partitions.add("__egl_multiline_comment");
        partitions.add("__egl_sql");
        partitions.add("__egl_sqlCondition");
        PARTITION_SET = Collections.unmodifiableSet(partitions);
    }

    EGLCompletionProposalComputerDescriptor(IConfigurationElement element, EGLCompletionProposalComputerRegistry registry, List categories) throws InvalidRegistryObjectException, CoreException {
        Assert.isLegal((registry != null ? 1 : 0) != 0);
        Assert.isLegal((element != null ? 1 : 0) != 0);
        this.fRegistry = registry;
        this.fElement = element;
        IExtension extension = element.getDeclaringExtension();
        this.fId = extension.getUniqueIdentifier();
        this.checkNotNull(this.fId, "id");
        String name = extension.getLabel();
        this.fName = name.length() == 0 ? this.fId : name;
        HashSet<String> partitions = new HashSet<String>();
        IConfigurationElement[] children = element.getChildren(PARTITION);
        if (children.length == 0) {
            this.fPartitions = PARTITION_SET;
        } else {
            int i = 0;
            while (i < children.length) {
                String type = children[i].getAttribute(TYPE);
                this.checkNotNull(type, TYPE);
                partitions.add(type);
                ++i;
            }
            this.fPartitions = Collections.unmodifiableSet(partitions);
        }
        String activateAttribute = element.getAttribute(ACTIVATE);
        this.fActivate = Boolean.valueOf(activateAttribute);
        this.fClass = element.getAttribute(CLASS);
        this.checkNotNull(this.fClass, CLASS);
        String categoryId = element.getAttribute(CATEGORY_ID);
        if (categoryId == null) {
            categoryId = DEFAULT_CATEGORY_ID;
        }
        EGLCompletionProposalCategory category = null;
        for (EGLCompletionProposalCategory cat : categories) {
            if (!cat.getId().equals(categoryId)) continue;
            category = cat;
            break;
        }
        if (category == null) {
            this.fCategory = new EGLCompletionProposalCategory(categoryId, this.fName, registry);
            categories.add(this.fCategory);
        } else {
            this.fCategory = category;
        }
    }

    private void checkNotNull(Object value, String attribute) throws InvalidRegistryObjectException, CoreException {
        if (value == null) {
            Object[] args = new Object[]{this.getId(), this.fElement.getContributor().getName(), attribute};
            String message = Messages.format(EGLTextMessages.CompletionProposalComputerDescriptor_illegal_attribute_message, args);
            Status status = new Status(2, EDTUIPlugin.getPluginId(), 0, message, null);
            throw new CoreException((IStatus)status);
        }
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public Set getPartitions() {
        return this.fPartitions;
    }

    private synchronized IEGLCompletionProposalComputer getComputer(boolean canCreate) throws CoreException, InvalidRegistryObjectException {
        if (this.fComputer == null && canCreate && !this.fTriedLoadingComputer && (this.fActivate || this.isPluginLoaded())) {
            this.fTriedLoadingComputer = true;
            this.fComputer = this.createComputer();
        }
        return this.fComputer;
    }

    private boolean isPluginLoaded() {
        Bundle bundle = this.getBundle();
        return bundle != null && bundle.getState() == 32;
    }

    private Bundle getBundle() {
        String namespace = this.fElement.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Platform.getBundle((String)namespace);
        return bundle;
    }

    public IEGLCompletionProposalComputer createComputer() throws CoreException, InvalidRegistryObjectException {
        return (IEGLCompletionProposalComputer)this.fElement.createExecutableExtension(CLASS);
    }

    /*
     * Exception decompiling
     */
    public List computeCompletionProposals(EGLContentAssistInvocationContext context, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List computeContextInformation(EGLContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!this.isEnabled()) {
            return Collections.EMPTY_LIST;
        }
        try {
            IEGLCompletionProposalComputer computer = this.getComputer(true);
            if (computer == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            List proposals = computer.computeContextInformation(context, monitor);
            if (proposals != null) {
                this.fLastError = computer.getErrorMessage();
                List list = proposals;
                return list;
            }
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
        }
        catch (CoreException coreException) {
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            monitor.done();
        }
        return Collections.EMPTY_LIST;
    }

    public void sessionStarted() {
        if (!this.isEnabled()) {
            return;
        }
        try {
            IEGLCompletionProposalComputer computer = this.getComputer(true);
            if (computer == null) {
                return;
            }
            computer.sessionStarted();
            return;
        }
        catch (InvalidRegistryObjectException x) {
            this.createExceptionStatus(x);
        }
        catch (CoreException x) {
            this.createExceptionStatus(x);
        }
        catch (RuntimeException x) {
            this.createExceptionStatus(x);
        }
    }

    public void sessionEnded() {
        IStatus status;
        if (!this.isEnabled()) {
            return;
        }
        try {
            IEGLCompletionProposalComputer computer = this.getComputer(false);
            if (computer == null) {
                return;
            }
            computer.sessionEnded();
            return;
        }
        catch (InvalidRegistryObjectException x) {
            status = this.createExceptionStatus(x);
        }
        catch (CoreException x) {
            status = this.createExceptionStatus(x);
        }
        catch (RuntimeException x) {
            status = this.createExceptionStatus(x);
        }
        this.fRegistry.informUser(this, status);
    }

    private boolean isEnabled() {
        return this.fCategory.isEnabled();
    }

    EGLCompletionProposalCategory getCategory() {
        return this.fCategory;
    }

    public String getErrorMessage() {
        return this.fLastError;
    }

    IContributor getContributor() {
        try {
            return this.fElement.getContributor();
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            return null;
        }
    }

    private IStatus createExceptionStatus(InvalidRegistryObjectException x) {
        String blame = this.createBlameMessage();
        String reason = EGLTextMessages.CompletionProposalComputerDescriptor_reason_invalid;
        return new Status(1, EDTUIPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, (Throwable)x);
    }

    private String createBlameMessage() {
        Object[] args = new Object[]{this.getName(), this.fElement.getDeclaringExtension().getContributor().getName()};
        String disable = Messages.format(EGLTextMessages.CompletionProposalComputerDescriptor_blame_message, args);
        return disable;
    }

    private IStatus createExceptionStatus(CoreException x) {
        String blame = this.createBlameMessage();
        String reason = EGLTextMessages.CompletionProposalComputerDescriptor_reason_instantiation;
        return new Status(4, EDTUIPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, (Throwable)x);
    }

    private IStatus createExceptionStatus(RuntimeException x) {
        String blame = this.createBlameMessage();
        String reason = EGLTextMessages.CompletionProposalComputerDescriptor_reason_runtime_ex;
        return new Status(2, EDTUIPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, (Throwable)x);
    }
}

