/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FunctionContainerBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.LocalVariableBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.VariableBinding;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.jface.text.ITextViewer;

public class EGLDeclarationProposalHandler
extends EGLAbstractProposalHandler {
    public static final int INTEGER_DATAITEM = 1;
    public static final int NUMERIC_DATAITEM = 2;
    public static final int STRING_DATAITEMS = 3;
    public static final int NUMERIC_STRING_DATAITEMS = 4;
    public static final int ALL_DATAITEMS = 5;
    public static int BASIC_RECORD = 1;
    public static int ENTITY_RECORD = 2;
    public static int EXCEPTION = 4096;
    public static int ALL_RECORDS = ENTITY_RECORD | EXCEPTION;
    private Node functionContainerPart;
    private Node functionPart;
    private boolean parens;

    private static boolean isDataSourceType(ITypeBinding type) {
        return type.getName().equalsIgnoreCase("DataSource") || type.getName().equalsIgnoreCase("SQLDataSource") || type.getName().equalsIgnoreCase("SQLResultSet") || type.getName().equalsIgnoreCase("ScrollableDataSource");
    }

    private static boolean isSqlStatement(ITypeBinding type) {
        return type.getName().equalsIgnoreCase("SQLStatement");
    }

    private static boolean isSqlString(ITypeBinding type) {
        return type.getName().equalsIgnoreCase("string");
    }

    public EGLDeclarationProposalHandler(ITextViewer viewer, int documentOffset, String prefix, Node boundNode) {
        super(viewer, documentOffset, prefix);
        while (!(boundNode instanceof File)) {
            if (boundNode instanceof NestedFunction) {
                this.functionPart = boundNode;
                this.functionContainerPart = boundNode.getParent();
            } else if (boundNode instanceof TopLevelFunction) {
                this.functionPart = boundNode;
                for (Node next : ((File)boundNode.getParent()).getParts()) {
                    if (!(next instanceof Program) && !(next instanceof Library) && !(next instanceof Service) && !(next instanceof Handler)) continue;
                    this.functionContainerPart = next;
                    break;
                }
            } else if (boundNode instanceof Part) {
                this.functionContainerPart = boundNode;
            }
            boundNode = boundNode.getParent();
        }
    }

    public List getProposals(boolean parens, boolean constants) {
        return this.getProposals(null, parens, constants);
    }

    public List getProposals(Node boundNode) {
        return this.getProposals(boundNode, false, true);
    }

    public List getProposals(Node node, boolean parens, boolean constants) {
        this.parens = parens;
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getParameterProposals(false));
        proposals.addAll(this.getContainerVariableProposals(constants, false));
        proposals.addAll(this.getVariableProposals(constants, false));
        if (node != null) {
            proposals.addAll(this.getExceptionDeclarationProposals(node));
        }
        return proposals;
    }

    public List getRecordProposals(int recordTypes) {
        return this.getRecordProposals(recordTypes, false);
    }

    public List getRecordProposals(int recordTypes, boolean allowArray) {
        return this.getRecordProposals(recordTypes, allowArray, false);
    }

    public List getRecordProposals(int recordTypes, boolean allowArray, boolean quoted) {
        return this.getRecordProposals(recordTypes, allowArray, quoted, false);
    }

    public List getRecordProposals(int recordTypes, boolean allowArray, boolean quoted, boolean parens) {
        return this.getRecordProposals(recordTypes, null, allowArray, quoted, parens);
    }

    public List getRecordProposals(int recordTypes, Node node, boolean allowArray, boolean quoted, boolean parens) {
        this.parens = parens;
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getParameterRecordProposals(recordTypes, allowArray, quoted));
        proposals.addAll(this.getContainerVariableRecordProposals(recordTypes, allowArray, quoted));
        proposals.addAll(this.getVariableRecordProposals(recordTypes, allowArray, quoted));
        if (node != null) {
            proposals.addAll(this.getExceptionDeclarationProposals(node));
        }
        return proposals;
    }

    public List getDataItemProposals(int integerType) {
        return this.getDataItemProposals(integerType, true);
    }

    public List getDataItemProposals(int integerType, boolean constants) {
        return this.getDataItemProposals(integerType, constants, false);
    }

    public List getDataItemProposals(int integerType, boolean constants, boolean parens) {
        this.parens = parens;
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getParameterDataItemProposals(integerType));
        proposals.addAll(this.getContainerVariableDataItemProposals(integerType, constants));
        proposals.addAll(this.getVariableDataItemProposals(integerType, constants));
        return proposals;
    }

    public List getServiceProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getVariableProposals(new ServiceTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new ServiceTypeDataBindingFilter(), false, false));
        return proposals;
    }

    public List getDataSourceProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getVariableProposals(new DataSourceTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new DataSourceTypeDataBindingFilter(), false, false));
        return proposals;
    }

    public List getSQLStatementProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getVariableProposals(new SQLStatementTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new SQLStatementTypeDataBindingFilter(), false, false));
        return proposals;
    }

    public List getSQLStringProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getVariableProposals(new SQLStringTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new SQLStringTypeDataBindingFilter(), false, false));
        return proposals;
    }

    private List getAllRecordProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getParameterProposals(new RecordTypeDataBindingFilter(), false));
        proposals.addAll(this.getVariableProposals(new RecordTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new RecordTypeDataBindingFilter(), false, false));
        return proposals;
    }

    private List getAllHandlerProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getVariableProposals(new HandlerTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new HandlerTypeDataBindingFilter(), false, false));
        return proposals;
    }

    private List getAllExternalTypeProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getVariableProposals(new SQLActionTargetsExternalTypeDataBindingFilter(), false, false));
        proposals.addAll(this.getContainerVariableProposals(new SQLActionTargetsExternalTypeDataBindingFilter(), false, false));
        return proposals;
    }

    public List getSQLActioniTargets() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getAllRecordProposals());
        proposals.addAll(this.getAllHandlerProposals());
        proposals.addAll(this.getAllExternalTypeProposals());
        return proposals;
    }

    private List getVariableDataItemProposals(int dataItemType, boolean includeConstants) {
        return this.getVariableProposals(new DataItemTypeDataBindingFilter(dataItemType), includeConstants, false);
    }

    private List getContainerVariableDataItemProposals(int dataItemType, boolean includeConstants) {
        return this.getContainerVariableProposals(new DataItemTypeDataBindingFilter(dataItemType), includeConstants, false);
    }

    private List getParameterDataItemProposals(int dataItemType) {
        return this.getParameterProposals(new DataItemTypeDataBindingFilter(dataItemType), false);
    }

    private List getContainerParameterDataItemProposals(int dataItemType) {
        return this.getContainerVariableProposals(new DataItemTypeDataBindingFilter(dataItemType), true, false);
    }

    private List getContainerParameterRecordProposals(int recordType, boolean allowArray, boolean quoted) {
        return this.getContainerVariableProposals(new RecordSubtypeDataBindingFilter(recordType, allowArray), true, quoted);
    }

    private List getVariableRecordProposals(int recordTypes, boolean allowArray, boolean quoted) {
        return this.getVariableProposals(new RecordSubtypeDataBindingFilter(recordTypes, allowArray), false, quoted);
    }

    private List getParameterProposals(boolean quoted) {
        return this.getParameterProposals(new DefaultDataBindingFilter(), quoted);
    }

    private List getParameterProposals(IDataBindingFilter dataBindingFilter, boolean quoted) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (this.functionPart != null) {
            IFunctionBinding fBinding = this.functionPart instanceof TopLevelFunction ? (IFunctionBinding)((TopLevelFunction)this.functionPart).getName().resolveBinding() : (IFunctionBinding)((IDataBinding)((NestedFunction)this.functionPart).getName().resolveBinding()).getType();
            for (IDataBinding dBinding : fBinding.getParameters()) {
                if (!dBinding.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) || !dataBindingFilter.dataBindingPasses(dBinding) || !this.precondition(dBinding)) continue;
                String proposalString = this.getProposalString(dBinding.getCaseSensitiveName());
                proposals.add(this.createDeclarationProposal(dBinding, proposalString, 50, quoted));
            }
        }
        return proposals;
    }

    private List getParameterRecordProposals(int recordTypes, boolean allowArray, boolean quoted) {
        return this.getParameterProposals(new RecordSubtypeDataBindingFilter(recordTypes, allowArray), quoted);
    }

    public List getProgramParameterRecordProposals(int recordTypes, boolean allowArray, boolean quoted) {
        this.parens = false;
        ArrayList proposals = new ArrayList();
        if (this.functionContainerPart instanceof Program) {
            proposals.addAll(this.getContainerParameterRecordProposals(recordTypes, allowArray, quoted));
        }
        return proposals;
    }

    private String getProposalString(String string) {
        if (this.parens) {
            return "(" + string + ")";
        }
        return string;
    }

    private List getContainerVariableProposals(boolean includeConstants, boolean quoted) {
        return this.getContainerVariableProposals(new DefaultDataBindingFilter(), includeConstants, quoted);
    }

    private List getContainerVariableProposals(IDataBindingFilter dataBindingFilter, boolean includeConstants, boolean quoted) {
        IBinding binding;
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (this.functionContainerPart != null && (binding = ((Part)this.functionContainerPart).getName().resolveBinding()) instanceof FunctionContainerBinding) {
            FunctionContainerBinding pBinding = (FunctionContainerBinding)binding;
            for (IDataBinding dBinding : pBinding.getDeclaredData(true)) {
                if (!dBinding.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) || !dataBindingFilter.dataBindingPasses(dBinding) || !this.precondition(dBinding) || !includeConstants && 3 == dBinding.getKind() && ((ClassFieldBinding)dBinding).isConstant()) continue;
                String proposalString = this.getProposalString(dBinding.getCaseSensitiveName());
                proposals.add(this.createDeclarationProposal(dBinding, proposalString, 50, quoted));
            }
        }
        return proposals;
    }

    private List getContainerVariableRecordProposals(int recordTypes, boolean allowArray, boolean quoted) {
        return this.getContainerVariableProposals(new RecordSubtypeDataBindingFilter(recordTypes, allowArray), false, quoted);
    }

    private List getVariableProposals(boolean includeConstants, boolean quoted) {
        return this.getVariableProposals(new DefaultDataBindingFilter(), includeConstants, quoted);
    }

    private List getVariableProposals(IDataBindingFilter dataBindingFilter, boolean includeConstants, boolean quoted) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (this.functionPart != null) {
            Stack blocks = new Stack();
            blocks.push(new ArrayList());
            List statements = this.functionPart instanceof TopLevelFunction ? ((TopLevelFunction)this.functionPart).getStmts() : ((NestedFunction)this.functionPart).getStmts();
            this.addDeclarations(statements, blocks);
            Iterator iter = blocks.iterator();
            while (iter.hasNext()) {
                for (IDataBinding dBinding : (List)iter.next()) {
                    if (!dBinding.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) || !dataBindingFilter.dataBindingPasses(dBinding) || !this.precondition(dBinding) || !includeConstants && 2 == dBinding.getKind() && ((LocalVariableBinding)dBinding).isConstant()) continue;
                    String proposalString = this.getProposalString(dBinding.getCaseSensitiveName());
                    proposals.add(this.createDeclarationProposal(dBinding, proposalString, 50, quoted));
                }
            }
        }
        return proposals;
    }

    private List getExceptionDeclarationProposals(Node node) {
        return this.getExceptionDeclarationProposals(node, new DefaultDataBindingFilter());
    }

    private List getExceptionDeclarationProposals(Node node, IDataBindingFilter dataBindingFilter) {
        IDataBinding dBinding;
        Name exceptionName;
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        OnExceptionBlock onExceptionBlock = this.getOnExceptionBlock(node);
        if (onExceptionBlock != null && (exceptionName = onExceptionBlock.getExceptionName()) != null && exceptionName.getCanonicalName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) && (dBinding = exceptionName.resolveDataBinding()).getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) && dataBindingFilter.dataBindingPasses(dBinding) && this.precondition(dBinding)) {
            String proposalString = this.getProposalString(dBinding.getCaseSensitiveName());
            proposals.add(this.createDeclarationProposal(dBinding, proposalString, 50, false));
        }
        return proposals;
    }

    private OnExceptionBlock getOnExceptionBlock(Node node) {
        final OnExceptionBlock[] onExceptionBlock = new OnExceptionBlock[1];
        while (node != null) {
            node.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(OnExceptionBlock onExceptionBlk) {
                    onExceptionBlock[0] = onExceptionBlk;
                    return false;
                }
            });
            node = node.getParent();
        }
        return onExceptionBlock[0];
    }

    private boolean addDeclarations(List statements, final Stack blocks) {
        boolean done = false;
        Statement lastStatement = null;
        Iterator iter = statements.iterator();
        while (iter.hasNext() && !done) {
            Statement nextStmt;
            Node next = (Node)iter.next();
            if (!(next instanceof Statement)) continue;
            lastStatement = nextStmt = (Statement)next;
            if (nextStmt.getOffset() > this.getDocumentOffset()) {
                done = true;
                continue;
            }
            if (nextStmt.canIncludeOtherStatements()) {
                Iterator blockIter = nextStmt.getStatementBlocks().iterator();
                while (blockIter.hasNext()) {
                    blocks.push(new ArrayList());
                    nextStmt.accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(ForStatement forStatement) {
                            IBinding binding;
                            if (forStatement.hasVariableDeclaration() && (binding = forStatement.getVariableDeclarationName().resolveBinding()) != null && IBinding.NOT_FOUND_BINDING != binding && binding.isDataBinding()) {
                                ((List)blocks.peek()).add(binding);
                            }
                            return false;
                        }
                    });
                    if (this.addDeclarations((List)blockIter.next(), blocks)) {
                        done = true;
                        continue;
                    }
                    blocks.pop();
                }
                continue;
            }
            nextStmt.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                    Iterator iter = functionDataDeclaration.getNames().iterator();
                    while (iter.hasNext()) {
                        IBinding binding = ((Name)iter.next()).resolveBinding();
                        if (binding == null || IBinding.NOT_FOUND_BINDING == binding || !binding.isDataBinding()) continue;
                        ((List)blocks.peek()).add(binding);
                    }
                    return false;
                }
            });
        }
        if (!done && lastStatement != null && lastStatement.getOffset() + lastStatement.getLength() > this.getDocumentOffset()) {
            done = true;
        }
        return done;
    }

    private String getAdditionalInfo1(IDataBinding variable) {
        if (variable.getType() != null) {
            String type = this.getTypeText(variable);
            switch (variable.getKind()) {
                case 19: {
                    return MessageFormat.format(UINlsStrings.CAProposal_ServiceReferenceDeclarationIn, type, variable.getDeclaringPart().getCaseSensitiveName());
                }
                case 1: {
                    return MessageFormat.format(UINlsStrings.CAProposal_ParameterDeclarationIn, type, variable.getDeclaringPart().getCaseSensitiveName());
                }
                case 0: {
                    return MessageFormat.format(UINlsStrings.CAProposal_ParameterDeclaration, type);
                }
                case 2: {
                    if (((VariableBinding)variable).isConstant()) {
                        return MessageFormat.format(UINlsStrings.CAProposal_ConstantDeclaration, type);
                    }
                    return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclaration, type);
                }
                case 3: {
                    if (((VariableBinding)variable).isConstant()) {
                        return MessageFormat.format(UINlsStrings.CAProposal_ConstantDeclarationIn, type, variable.getDeclaringPart().getCaseSensitiveName());
                    }
                    return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclarationIn, type, variable.getDeclaringPart().getCaseSensitiveName());
                }
            }
            if (this.functionContainerPart == null) {
                return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclaration, type);
            }
            return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclarationIn, type, variable.getDeclaringPart().getCaseSensitiveName());
        }
        if (this.functionContainerPart == null) {
            return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclaration, "");
        }
        return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclarationIn, "", variable.getDeclaringPart().getCaseSensitiveName());
    }

    private String getTypeText(IDataBinding variable) {
        if (variable.getType() != null) {
            return variable.getType().getCaseSensitiveName();
        }
        return "";
    }

    private EGLCompletionProposal createDeclarationProposal(IDataBinding variable, String proposalString, int relevance, boolean quoted) {
        if (quoted) {
            proposalString = "\"" + proposalString + "\"";
        }
        return new EGLCompletionProposal(this.viewer, String.valueOf(variable.getCaseSensitiveName()) + " " + this.getTypeText(variable) + " (" + this.getPartTypeString(variable.getType()) + " " + UINlsStrings.CAProposal_Variable + ")", proposalString, this.getAdditionalInfo1(variable), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), proposalString.length(), relevance);
    }

    protected boolean precondition(IDataBinding dBinding) {
        return true;
    }

    private static class DataItemTypeDataBindingFilter
    implements IDataBindingFilter {
        private int dataItemType;

        public DataItemTypeDataBindingFilter(int dataItemType) {
            this.dataItemType = dataItemType;
        }

        @Override
        public boolean dataBindingPasses(IDataBinding dataBinding) {
            ITypeBinding type = dataBinding.getType();
            if (type != null && IBinding.NOT_FOUND_BINDING != type && 3 == (type = type.getBaseType()).getKind()) {
                PrimitiveTypeBinding primType = (PrimitiveTypeBinding)type;
                Primitive prim = primType.getPrimitive();
                switch (this.dataItemType) {
                    case 5: {
                        return true;
                    }
                    case 3: {
                        return Primitive.isStringType((Primitive)prim);
                    }
                    case 2: {
                        return Primitive.isNumericType((Primitive)prim);
                    }
                    case 4: {
                        return Primitive.isNumericType((Primitive)prim) || Primitive.isStringType((Primitive)prim);
                    }
                    case 1: {
                        if (Primitive.isIntegerType((Primitive)prim)) {
                            return true;
                        }
                        if (primType.getDecimals() != 0 || prim != Primitive.NUM && prim != Primitive.BIN && prim != Primitive.DECIMAL && prim != Primitive.NUMC && prim != Primitive.PACF) break;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static class DataSourceTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(IDataBinding dataBinding) {
            ITypeBinding type = dataBinding.getType();
            if (type != null && IBinding.NOT_FOUND_BINDING != type) {
                if (EGLDeclarationProposalHandler.isDataSourceType(type = type.getBaseType())) {
                    return true;
                }
                if (28 == type.getKind()) {
                    List extendType = ((ExternalTypeBinding)type).getExtendedTypes();
                    for (ITypeBinding aType : extendType) {
                        if (!EGLDeclarationProposalHandler.isDataSourceType(aType)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static class DefaultDataBindingFilter
    implements IDataBindingFilter {
        private DefaultDataBindingFilter() {
        }

        @Override
        public boolean dataBindingPasses(IDataBinding dataBinding) {
            return true;
        }
    }

    private static class HandlerTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(IDataBinding dataBinding) {
            ITypeBinding type = dataBinding.getType();
            return type != null && IBinding.NOT_FOUND_BINDING != type && 10 == (type = type.getBaseType()).getKind();
        }
    }

    private static interface IDataBindingFilter {
        public boolean dataBindingPasses(IDataBinding var1);
    }

    private static class RecordSubtypeDataBindingFilter
    implements IDataBindingFilter {
        private int recordTypes;
        private boolean allowArray;

        public RecordSubtypeDataBindingFilter(int recordTypes, boolean allowArray) {
            this.recordTypes = recordTypes;
            this.allowArray = allowArray;
        }

        @Override
        public boolean dataBindingPasses(IDataBinding dataBinding) {
            ITypeBinding type = dataBinding.getType();
            if (type != null && IBinding.NOT_FOUND_BINDING != type) {
                if (this.allowArray) {
                    type = type.getBaseType();
                }
                switch (type.getKind()) {
                    case 6: 
                    case 7: 
                    case 10: 
                    case 28: {
                        if ((ENTITY_RECORD & this.recordTypes) != ENTITY_RECORD || type.getAnnotation(EGLPERSISTENCE, "Entity") == null) break;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static class RecordTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(IDataBinding dataBinding) {
            ITypeBinding type = dataBinding.getType();
            return type != null && IBinding.NOT_FOUND_BINDING != type && ((type = type.getBaseType()).getKind() == 6 || type.getKind() == 7);
        }
    }

    private static class SQLActionTargetsExternalTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(IDataBinding dataBinding) {
            ITypeBinding type = dataBinding.getType();
            return type != null && IBinding.NOT_FOUND_BINDING != type && (type = type.getBaseType()).getKind() == 28 && !EGLDeclarationProposalHandler.isDataSourceType(type) && !EGLDeclarationProposalHandler.isSqlStatement(type);
        }
    }

    private static class SQLStatementTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(IDataBinding dataBinding) {
            ITypeBinding type = dataBinding.getType();
            return type != null && IBinding.NOT_FOUND_BINDING != type && EGLDeclarationProposalHandler.isSqlStatement(type = type.getBaseType());
        }
    }

    private static class SQLStringTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(IDataBinding dataBinding) {
            ITypeBinding type = dataBinding.getType();
            return type != null && IBinding.NOT_FOUND_BINDING != type && EGLDeclarationProposalHandler.isSqlString(type = type.getBaseType());
        }
    }

    private static class ServiceTypeDataBindingFilter
    implements IDataBindingFilter {
        @Override
        public boolean dataBindingPasses(IDataBinding dataBinding) {
            ITypeBinding type = dataBinding.getType();
            return type != null && IBinding.NOT_FOUND_BINDING != type && (14 == (type = type.getBaseType()).getKind() || 15 == type.getKind());
        }
    }
}

