/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.ConstantFormField;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.compiler.internal.EGLNewPropertiesHandler;
import org.eclipse.edt.compiler.internal.core.lookup.Enumerations.ElementKind;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLPropertyNameProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractPropertyReferenceCompletion;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.edt.ide.ui.internal.util.CapabilityFilterUtility;
import org.eclipse.jface.text.ITextViewer;

public class EGLAnnotationNameReferenceCompletion
extends EGLAbstractPropertyReferenceCompletion {
    @Override
    protected void precompileContexts() {
        this.addContext("package a; program a {@");
    }

    @Override
    protected List returnCompletionProposals(final ParseStack parseStack, final String prefix, final ITextViewer viewer, final int documentOffset) {
        this.viewer = viewer;
        this.documentOffset = documentOffset;
        final ArrayList proposals = new ArrayList();
        this.getBoundASTNode(viewer, documentOffset, new String[]{"", "a{}", "a", "}};", "a};"}, new EGLAbstractReferenceCompletion.CompletedNodeVerifier(){

            @Override
            public boolean nodeIsValid(Node astNode) {
                return EGLAnnotationNameReferenceCompletion.this.getSettingsBlock(astNode) != null;
            }
        }, new EGLAbstractReferenceCompletion.IBoundNodeProcessor(){

            @Override
            public void processBoundNode(Node boundNode) {
                if (EGLAnnotationNameReferenceCompletion.this.isState(parseStack, (Integer)EGLAnnotationNameReferenceCompletion.this.validStates.get(0))) {
                    Node settingsBlock = EGLAnnotationNameReferenceCompletion.this.getSettingsBlock(boundNode);
                    Node container = settingsBlock.getParent();
                    AnnotationGatherer aGatherer = EGLAnnotationNameReferenceCompletion.this.getAnnotationGatherer(container, settingsBlock);
                    proposals.addAll(aGatherer.getProposals(viewer, documentOffset, prefix));
                }
            }
        });
        return proposals;
    }

    private AnnotationGatherer getAnnotationGatherer(Node container, Node settingsBlock) {
        if (container instanceof Part) {
            switch (((Part)container).getPartType()) {
                case 0: {
                    return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.PROGRAMPART, settingsBlock);
                }
                case 1: {
                    return new ForElementKindAnnotationGatherer(new EnumerationDataBinding[]{ElementKind.RECORDPART, ElementKind.STRUCTUREDRECORDPART, ElementKind.VGUIRECORDPART}, settingsBlock);
                }
                case 2: {
                    return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.FUNCTIONPART, settingsBlock);
                }
                case 3: {
                    return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.DATAITEMPART, settingsBlock);
                }
                case 4: {
                    return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.FORMPART, settingsBlock);
                }
                case 5: {
                    return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.FORMGROUPPART, settingsBlock);
                }
                case 6: {
                    return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.DATATABLEPART, settingsBlock);
                }
                case 8: {
                    return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.LIBRARYPART, settingsBlock);
                }
                case 9: {
                    return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.HANDLERPART, settingsBlock);
                }
                case 10: {
                    return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.SERVICEPART, settingsBlock);
                }
                case 11: {
                    return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.INTERFACEPART, settingsBlock);
                }
                case 12: {
                    return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.DELEGATEPART, settingsBlock);
                }
                case 13: {
                    return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.EXTERNALTYPEPART, settingsBlock);
                }
            }
        } else if (container instanceof UseStatement) {
            Name firstName = (Name)((UseStatement)container).getNames().get(0);
            IBinding binding = firstName.resolveBinding();
            if (Binding.isValidBinding((IBinding)binding) && binding.isTypeBinding()) {
                switch (((ITypeBinding)binding).getKind()) {
                    case 5: {
                        return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.DATATABLEUSE, settingsBlock);
                    }
                    case 9: {
                        return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.FORMGROUPUSE, settingsBlock);
                    }
                }
            }
        } else {
            if (container instanceof NestedFunction) {
                return new ForElementKindAnnotationGatherer((EnumerationDataBinding)ElementKind.FUNCTIONMBR, settingsBlock);
            }
            IDataBinding nameBinding = null;
            if (container instanceof ClassDataDeclaration) {
                nameBinding = ((Name)((ClassDataDeclaration)container).getNames().get(0)).resolveDataBinding();
            }
            if (container instanceof FunctionDataDeclaration) {
                nameBinding = ((Name)((FunctionDataDeclaration)container).getNames().get(0)).resolveDataBinding();
            }
            if (container instanceof VariableFormField) {
                nameBinding = ((VariableFormField)container).getName().resolveDataBinding();
            }
            if (container instanceof ConstantFormField) {
                nameBinding = ((ConstantFormField)container).resolveBinding();
            }
            if (container instanceof StructureItem) {
                nameBinding = (IDataBinding)((StructureItem)container).resolveBinding();
            }
            if (Binding.isValidBinding((IBinding)nameBinding)) {
                ITypeBinding nameType;
                IPartSubTypeAnnotationTypeBinding subType;
                CompoundAnnotationGatherer result = new CompoundAnnotationGatherer(settingsBlock);
                IPartBinding declaringPart = nameBinding.getDeclaringPart();
                if (Binding.isValidBinding((IBinding)declaringPart) && Binding.isValidBinding((IBinding)(subType = declaringPart.getSubType()))) {
                    result.addGatherer(new ForMemberAnnotationsAnnotationGatherer(subType.getName(), settingsBlock));
                }
                if (Binding.isValidBinding((IBinding)(nameType = nameBinding.getType()))) {
                    switch (nameType.getKind()) {
                        case 2: {
                            result.addGatherer(new ForNameAnnotationGatherer("maxSize", settingsBlock));
                            break;
                        }
                        case 21: {
                            result.addGatherer(new ForNameAnnotationGatherer("caseSensitive", settingsBlock));
                            result.addGatherer(new ForNameAnnotationGatherer("ordering", settingsBlock));
                            break;
                        }
                        case 14: 
                        case 15: {
                            result.addGatherer(new ForNameAnnotationGatherer("bindService", settingsBlock));
                        }
                    }
                }
                return result;
            }
        }
        return new AllNonSubtypeAnnotationGatherer(settingsBlock);
    }

    private Node getSettingsBlock(Node astNode) {
        while (astNode != null && !(astNode instanceof SettingsBlock)) {
            astNode = astNode.getParent();
        }
        return astNode;
    }

    private static class AllNonSubtypeAnnotationGatherer
    extends AnnotationGatherer {
        public AllNonSubtypeAnnotationGatherer(Node settingsBlock) {
            super(settingsBlock);
        }

        @Override
        protected Collection getPropertyRules() {
            return EGLNewPropertiesHandler.getPropertyRules((int)127);
        }
    }

    private static abstract class AnnotationGatherer {
        private Node settingsBlock;

        protected AnnotationGatherer(Node settingsBlock) {
            this.settingsBlock = settingsBlock;
        }

        public Collection getProposals(ITextViewer viewer, int documentOffset, String prefix) {
            return new EGLPropertyNameProposalHandler(viewer, documentOffset, prefix, true).getProposals(CapabilityFilterUtility.filterPropertyRules(this.getPropertyRules()), Arrays.asList(this.settingsBlock));
        }

        protected abstract Collection getPropertyRules();
    }

    private static class CompoundAnnotationGatherer
    extends AnnotationGatherer {
        private List aGatherers = new ArrayList();

        public CompoundAnnotationGatherer(Node settingsBlock) {
            super(settingsBlock);
        }

        public void addGatherer(AnnotationGatherer gatherer) {
            this.aGatherers.add(gatherer);
        }

        @Override
        protected Collection getPropertyRules() {
            ArrayList result = new ArrayList();
            Iterator iter = this.aGatherers.iterator();
            while (iter.hasNext()) {
                result.addAll(((AnnotationGatherer)iter.next()).getPropertyRules());
            }
            return result;
        }
    }

    private static class ForElementKindAnnotationGatherer
    extends AnnotationGatherer {
        private EnumerationDataBinding[] elementKinds;

        public ForElementKindAnnotationGatherer(EnumerationDataBinding elementKind, Node settingsBlock) {
            this(new EnumerationDataBinding[]{elementKind}, settingsBlock);
        }

        public ForElementKindAnnotationGatherer(EnumerationDataBinding[] elementKinds, Node settingsBlock) {
            super(settingsBlock);
            this.elementKinds = elementKinds;
        }

        @Override
        protected Collection getPropertyRules() {
            return EGLNewPropertiesHandler.createRulesForElementKinds((EnumerationDataBinding[])this.elementKinds);
        }
    }

    private static class ForMemberAnnotationsAnnotationGatherer
    extends AnnotationGatherer {
        private String subtypeName;

        public ForMemberAnnotationsAnnotationGatherer(String subtypeName, Node settingsBlock) {
            super(settingsBlock);
            this.subtypeName = subtypeName;
        }

        @Override
        protected Collection getPropertyRules() {
            Collection memberRulers = EGLNewPropertiesHandler.createRulesForMemberAnnotations((String)this.subtypeName);
            Collection filedmbrAnnotation = EGLNewPropertiesHandler.createRulesForElementKinds((EnumerationDataBinding[])new EnumerationDataBinding[]{ElementKind.FIELDMBR});
            memberRulers.addAll(filedmbrAnnotation);
            return memberRulers;
        }
    }

    private static class ForNameAnnotationGatherer
    extends AnnotationGatherer {
        private String annotationName;

        public ForNameAnnotationGatherer(String annotationName, Node settingsBlock) {
            super(settingsBlock);
            this.annotationName = annotationName;
        }

        @Override
        protected Collection getPropertyRules() {
            return EGLNewPropertiesHandler.createRulesFor((String)this.annotationName);
        }
    }
}

