/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FormGroup;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLExceptionProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLPartSearchProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLPredefinedDataTypeProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLPrimitiveProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.edt.ide.ui.internal.editor.util.EGLModelUtility;
import org.eclipse.jface.text.ITextViewer;

public class EGLVariableTypeReferenceCompletion
extends EGLAbstractReferenceCompletion {
    @Override
    protected void precompileContexts() {
        this.addContext("package a; program a var");
        this.addContext("package a; function a() var");
        this.addContext("package a; form a type b var");
        this.addContext("package a; externaltype a var");
    }

    @Override
    protected List returnCompletionProposals(ParseStack parseStack, final String prefix, final ITextViewer viewer, final int documentOffset) {
        final ArrayList proposals = new ArrayList();
        int types = this.getTypes(viewer, documentOffset);
        if (types > 0 && !this.inBlock(viewer, documentOffset)) {
            proposals.addAll(new EGLPartSearchProposalHandler(viewer, documentOffset, prefix, this.editor).getProposals(types));
            proposals.addAll(new EGLPartSearchProposalHandler(viewer, documentOffset, prefix, this.editor).getProposals(512, "", new String[]{"ruiWidget", "ruiHandler", "Entity"}));
            proposals.addAll(new EGLExceptionProposalHandler(viewer, documentOffset, prefix, this.editor).getProposals());
            this.getBoundASTNode(viewer, documentOffset, new String[]{"x; end", "x;", "x", ""}, new EGLAbstractReferenceCompletion.CompletedNodeVerifier(){

                @Override
                public boolean nodeIsValid(Node astNode) {
                    return astNode != null;
                }
            }, new EGLAbstractReferenceCompletion.IBoundNodeProcessor(){

                @Override
                public void processBoundNode(Node boundNode) {
                    proposals.addAll(new EGLPrimitiveProposalHandler(viewer, documentOffset, prefix, boundNode).getProposals());
                    proposals.addAll(new EGLPredefinedDataTypeProposalHandler(viewer, documentOffset, prefix, boundNode).getProposals());
                }
            });
        }
        return proposals;
    }

    private int getTypes(ITextViewer viewer, int documentOffset) {
        IEGLDocument document = (IEGLDocument)viewer.getDocument();
        final int[] result = new int[]{this.getSearchConstantsForDeclarableParts()};
        Part eglPart = EGLModelUtility.getPartNode(document, documentOffset);
        if (eglPart != null) {
            eglPart.accept((IASTVisitor)new DefaultASTVisitor(){

                public void endVisit(FormGroup formGroup) {
                    result[0] = 16;
                }
            });
        }
        return result[0];
    }
}

