/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.internal.search.AllPartsCache;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.deployment.Deployment;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.Parameters;
import org.eclipse.edt.ide.ui.internal.deployment.Service;
import org.eclipse.edt.ide.ui.internal.deployment.Services;
import org.eclipse.edt.ide.ui.internal.deployment.ui.DeploymentUtilities;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBaseBlock;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBaseFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBindingBaseDetailPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDWebServicesDetailPageProvider;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDeploymentDescriptorEditor;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.wizards.WebServicesWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class EGLDDWebServicesBlock
extends EGLDDBaseBlock {
    public static final String HOSTPGM = "HostProgram";
    private static final int COLINDEX_GEN = 0;
    private static final int COLINDEX_IMPL = 1;
    private static final String[] TABLE_WS_COLUMN_PROPERTIES = new String[]{"COL_GEN", "COL_IMPL", "COL_STYLE"};
    private static final int GENWS_NONE = 0;
    private static final int GENWS_REST = 1;
    private static final int GENWS_SOAP = 2;
    private static final int GENWS_SOAPnREST = 3;
    private static final String[] GEN_WS_TYPES = new String[]{SOAMessages.serDeployChoice_disabled, SOAMessages.serDeployChoice_rest};
    private Button fBtnRemoveWS;
    private Button fBtnOpenWSImpl;
    private SectionPart spart;

    private static Image getImageIcon(Object element) {
        if (element instanceof RowItem) {
            RowItem rowitem = (RowItem)element;
            Service ws = rowitem.webservice;
            Service rs = rowitem.restservice;
            if (ws == null && rs != null) {
                String implType;
                String string = implType = rs.getParameters() == null ? null : EGLDDRootHelper.getParameterValue(rs.getParameters(), "implType");
                if (implType != null) {
                    int type = 0;
                    try {
                        type = Integer.valueOf(implType);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    return (type & 0x2000) != 0 ? PluginImages.get("org.eclipse.edt.ide.ui.exttyp_obj.gif") : PluginImages.get("org.eclipse.edt.ide.ui.svc_obj.gif");
                }
            }
        }
        return PluginImages.get("org.eclipse.edt.ide.ui.svc_obj.gif");
    }

    public EGLDDWebServicesBlock(FormPage page) {
        this.fPage = page;
    }

    private Service createNewRestService(String impl, boolean enableGen, int implType) {
        EGLDeploymentRoot root = this.getEGLDeploymentRootInput();
        Service newRS = null;
        if (root != null) {
            Deployment deployment = root.getDeployment();
            DeploymentFactory factory = DeploymentFactory.eINSTANCE;
            Services rss = deployment.getServices();
            if (rss == null) {
                rss = factory.createServices();
                deployment.setServices(rss);
            }
            newRS = factory.createService();
            newRS.setType(org.eclipse.edt.ide.deployment.core.model.Service.SERVICE_REST);
            newRS.setImplementation(impl);
            Parameters params = factory.createParameters();
            newRS.setParameters(params);
            int lastDot = impl.lastIndexOf(46);
            EGLDDRootHelper.addOrUpdateParameter(params, "uriFragment", impl.substring(lastDot > 0 ? lastDot + 1 : 0));
            EGLDDRootHelper.addOrUpdateParameter(params, "enableGeneration", enableGen);
            EGLDDRootHelper.addOrUpdateParameter(params, "implType", implType);
            rss.getService().add((Object)newRS);
        }
        return newRS;
    }

    private Service createNewSoapService(String impl, boolean enableGen, int implType) {
        EGLDeploymentRoot root = this.getEGLDeploymentRootInput();
        Service newWs = null;
        if (root != null) {
            Deployment deployment = root.getDeployment();
            DeploymentFactory factory = DeploymentFactory.eINSTANCE;
            Services wss = deployment.getServices();
            if (wss == null) {
                wss = factory.createServices();
                deployment.setServices(wss);
            }
            newWs = factory.createService();
            wss.getService().add((Object)newWs);
        }
        return newWs;
    }

    private void handleGenWSTypeChanged(RowItem rowitem, int newGenWsType) {
        int implType;
        String impl;
        Service ws = rowitem.webservice;
        Service rs = rowitem.restservice;
        String string = impl = ws != null ? ws.getImplementation() : rs.getImplementation();
        if (ws != null) {
            switch (newGenWsType) {
                case 0: 
                case 1: {
                    break;
                }
            }
            if (rs == null) {
                switch (newGenWsType) {
                    case 0: 
                    case 2: {
                        break;
                    }
                    case 1: 
                    case 3: {
                        Service newrs;
                        implType = 1024;
                        rs.getParameters();
                        rowitem.restservice = newrs = this.createNewRestService(impl, true, implType);
                    }
                }
            }
        }
        if (rs != null) {
            switch (newGenWsType) {
                case 0: 
                case 2: {
                    EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(rs), "enableGeneration", false);
                    break;
                }
                case 1: 
                case 3: {
                    EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(rs), "enableGeneration", true);
                }
            }
            if (ws == null) {
                switch (newGenWsType) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        Service newws;
                        String val;
                        implType = 1024;
                        if (rs.getParameters() != null && (val = EGLDDRootHelper.getParameterValue(rs.getParameters(), "implType")) != null) {
                            try {
                                implType = Integer.valueOf(val);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        rowitem.webservice = newws = this.createNewSoapService(impl, true, implType);
                    }
                }
            }
        }
        this.fPage.getManagedForm().fireSelectionChanged((IFormPart)this.spart, (ISelection)new StructuredSelection((Object)rowitem));
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(parent, 384);
        section.setText(SOAMessages.WSMainSectionTitle);
        section.setDescription(SOAMessages.WSMainSectionDescription);
        section.marginHeight = 5;
        section.marginWidth = 10;
        Composite seprator = toolkit.createCompositeSeparator((Composite)section);
        GridData gd = new GridData(1808);
        gd.heightHint = 3;
        seprator.setLayoutData((Object)gd);
        this.createWebServicesSection(managedForm, section, toolkit, this.getEGLDeploymentRootInput());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), IUIHelpConstants.MODULE_EDITOR_EXTERNALSERVICEPAGE);
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.setPageProvider((IDetailsPageProvider)new EGLDDWebServicesDetailPageProvider());
    }

    private void createWebServicesSection(final IManagedForm managedForm, Section section, FormToolkit toolkit, EGLDeploymentRoot eglDDRoot) {
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        Table t = this.createWebServicesTableControl(client, toolkit);
        Composite buttonComposite = toolkit.createComposite(client);
        layout = new GridLayout(1, true);
        GridData gd = new GridData(2);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gd);
        Button btnAdd = toolkit.createButton(buttonComposite, SOAMessages.AddLabel, 8);
        gd = new GridData(800);
        btnAdd.setLayoutData((Object)gd);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGLDDWebServicesBlock.this.HandleAddPressed();
            }
        });
        this.fBtnRemoveWS = toolkit.createButton(buttonComposite, SOAMessages.RemoveLabel, 8);
        gd = new GridData(800);
        this.fBtnRemoveWS.setLayoutData((Object)gd);
        this.fBtnRemoveWS.setEnabled(false);
        this.fBtnRemoveWS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGLDDWebServicesBlock.this.HandleRemovePressed();
            }
        });
        t.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                EGLDDWebServicesBlock.this.HandleOpenPressed();
            }
        });
        this.fBtnOpenWSImpl = toolkit.createButton(buttonComposite, SOAMessages.OpenLabel, 8);
        gd = new GridData(800);
        this.fBtnOpenWSImpl.setLayoutData((Object)gd);
        this.fBtnOpenWSImpl.setEnabled(false);
        this.fBtnOpenWSImpl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGLDDWebServicesBlock.this.HandleOpenPressed();
            }
        });
        section.setClient((Control)client);
        this.spart = new SectionPart(section);
        managedForm.addPart((IFormPart)this.spart);
        this.fTableViewer = new TableViewer(t);
        CellEditor[] cellEditors = new CellEditor[TABLE_WS_COLUMN_PROPERTIES.length];
        cellEditors[0] = new ComboBoxCellEditor((Composite)t, GEN_WS_TYPES, 8);
        cellEditors[1] = new TextCellEditor((Composite)t);
        this.fTableViewer.setCellEditors(cellEditors);
        this.fTableViewer.setCellModifier((ICellModifier)new WSCellModifier());
        this.fTableViewer.setColumnProperties(TABLE_WS_COLUMN_PROPERTIES);
        this.fTableViewer.setContentProvider((IContentProvider)new WSListContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new WSLabelProvider());
        this.fTableViewer.setInput((Object)this.getEGLDeploymentRootInput());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)EGLDDWebServicesBlock.this.spart, event.getSelection());
                EGLDDWebServicesBlock.this.HandleTableSelectionChanged(event);
            }
        });
        this.fTableViewer.setSorter(new ViewerSorter());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)client, IUIHelpConstants.EGLDD_EDITOR_OVERVIEWPAGE_WS);
    }

    protected void HandleAddPressed() {
        WebServicesWizard wizard = new WebServicesWizard();
        if (this.need2OpenAddWebServicesWizard(wizard)) {
            ((EGLDDBaseFormPage)this.fPage).openWizard((IWizard)wizard);
            String newWSImpl = wizard.getNewlyAddedWebService();
            if (newWSImpl != null) {
                this.fTableViewer.refresh();
                int currCnt = this.fTableViewer.getTable().getItemCount();
                TableItem titem = null;
                boolean found = false;
                int i = 0;
                while (i < currCnt && !found) {
                    titem = this.fTableViewer.getTable().getItem(i);
                    RowItem rowitem = (RowItem)titem.getData();
                    if (rowitem.webservice != null && rowitem.webservice.getImplementation().equals(newWSImpl)) {
                        found = true;
                    }
                    if (!found && rowitem.restservice != null && rowitem.restservice.getImplementation().equals(newWSImpl)) {
                        found = true;
                    }
                    ++i;
                }
                if (found) {
                    this.fTableViewer.setSelection((ISelection)new StructuredSelection(titem.getData()));
                }
            }
        } else {
            MessageDialog.openInformation((Shell)this.fPage.getSite().getShell(), (String)wizard.getWindowTitle(), (String)SOAMessages.NoEGLServicesFoundMsg);
        }
    }

    protected void HandleRemovePressed() {
        IStructuredSelection ssel = (IStructuredSelection)this.fTableViewer.getSelection();
        if (ssel.size() > 0) {
            for (Object obj : ssel) {
                int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
                if (!(obj instanceof RowItem)) continue;
                RowItem rowitem = (RowItem)obj;
                Service ws = rowitem.webservice;
                Service rs = rowitem.restservice;
                EGLDeploymentRoot root = this.getEGLDeploymentRootInput();
                if (root == null) continue;
                Deployment deployment = root.getDeployment();
                Services wss = deployment.getServices();
                boolean wssSuc = true;
                boolean rssSuc = true;
                if (wss != null) {
                    if (ws != null) {
                        wssSuc = wss.getService().remove((Object)ws);
                    }
                    if (rs != null) {
                        rssSuc = wss.getService().remove((Object)rs);
                    }
                }
                if (!wssSuc || !rssSuc) continue;
                EGLDDBaseFormPage.updateTableViewerAfterRemove(selectionIndex, this.fTableViewer, this.fBtnRemoveWS);
                int newCnt = this.fTableViewer.getTable().getItemCount();
                if (newCnt > 0) continue;
                this.fBtnOpenWSImpl.setEnabled(false);
            }
        }
    }

    protected void HandleOpenPressed() {
        Object obj;
        IStructuredSelection ssel = (IStructuredSelection)this.fTableViewer.getSelection();
        if (ssel.size() == 1 && (obj = ssel.getFirstElement()) instanceof RowItem) {
            RowItem rowitem = (RowItem)obj;
            Service ws = rowitem.webservice;
            Service rs = rowitem.restservice;
            String fqImpl = "";
            if (ws != null) {
                fqImpl = ws.getImplementation();
            } else if (rs != null) {
                fqImpl = rs.getImplementation();
            }
            EGLDeploymentDescriptorEditor editor = (EGLDeploymentDescriptorEditor)this.fPage.getEditor();
            EGLDDBindingBaseDetailPage.try2OpenPartInEGLEditor(editor, fqImpl);
        }
    }

    private Table createWebServicesTableControl(Composite client, FormToolkit toolkit) {
        Table t = toolkit.createTable(client, 66306);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 20;
        gd.widthHint = 100;
        t.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        TableLayout tableLayout = new TableLayout();
        int maxWidth = 70;
        maxWidth = EGLDDBaseFormPage.createTableColumn(t, tableLayout, maxWidth, SOAMessages.ColLabelGenerate, 0);
        maxWidth = EGLDDBaseFormPage.createTableColumn(t, tableLayout, maxWidth, SOAMessages.TableColImpl, 1);
        t.setLayout((Layout)tableLayout);
        return t;
    }

    private void HandleTableSelectionChanged(SelectionChangedEvent event) {
        this.fBtnRemoveWS.setEnabled(true);
        this.fBtnOpenWSImpl.setEnabled(true);
    }

    private boolean need2OpenAddWebServicesWizard(WebServicesWizard wizard) {
        EGLDeploymentDescriptorEditor editor = (EGLDeploymentDescriptorEditor)this.fPage.getEditor();
        IProject proj = editor.getProject();
        final IEGLProject eglProj = EGLCore.create((IProject)proj);
        final ArrayList<PartDeclarationInfo> eglServicePartsList = new ArrayList<PartDeclarationInfo>();
        try {
            IRunnableWithProgress searchOp = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IEGLSearchScope projSearchScope = SearchEngine.createEGLSearchScope((IEGLElement[])new IEGLElement[]{eglProj}, (boolean)false);
                        AllPartsCache.getParts((IEGLSearchScope)projSearchScope, (int)1024, (IProgressMonitor)monitor, (Collection)eglServicePartsList);
                        AllPartsCache.getParts((IEGLSearchScope)projSearchScope, (int)8192, (String)EGLDDWebServicesBlock.HOSTPGM, (IProgressMonitor)monitor, (Collection)eglServicePartsList);
                    }
                    catch (EGLModelException e) {
                        EDTUIPlugin.log(e);
                    }
                }
            };
            new ProgressMonitorDialog(this.fPage.getSite().getShell()).run(true, false, searchOp);
        }
        catch (InvocationTargetException e) {
            EDTUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            EDTUIPlugin.log(e);
        }
        eglServicePartsList.addAll(DeploymentUtilities.getSystemServices());
        return wizard.init(this.getEGLDeploymentRootInput(), eglServicePartsList);
    }

    private int getGenWSType(Service ws, Service rs) {
        boolean wsEnabled = false;
        boolean rsEnabled = rs != null && rs.getParameters() != null && Boolean.parseBoolean(EGLDDRootHelper.getParameterValue(rs.getParameters(), "enableGeneration"));
        int genWsType = 3;
        genWsType = ws != null && rs != null ? (wsEnabled && rsEnabled ? 3 : (wsEnabled ? 2 : (rsEnabled ? 1 : 0))) : (ws != null ? (wsEnabled ? 2 : 0) : (rs != null ? (rsEnabled ? 1 : 0) : 0));
        return genWsType;
    }

    public void setFocus() {
        if (this.fTableViewer != null) {
            this.fTableViewer.getTable().setFocus();
        }
    }

    public static class RowItem {
        int index;
        Service webservice;
        Service restservice;

        public boolean equals(Object obj) {
            if (obj instanceof RowItem) {
                boolean isRSEqual;
                boolean isWSEqual;
                RowItem other = (RowItem)obj;
                boolean bl = this.webservice != null ? this.webservice.equals(other.webservice) : (isWSEqual = this.webservice == other.webservice);
                boolean bl2 = this.restservice != null ? this.restservice.equals(other.restservice) : (isRSEqual = this.restservice == other.restservice);
                return this.index == other.index && isWSEqual && isRSEqual;
            }
            return super.equals(obj);
        }
    }

    private class WSCellModifier
    implements ICellModifier {
        private WSCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(TABLE_WS_COLUMN_PROPERTIES[0]);
        }

        public Object getValue(Object element, String property) {
            Object value = null;
            if (element instanceof RowItem) {
                RowItem rowitem = (RowItem)element;
                Service ws = rowitem.webservice;
                Service rs = rowitem.restservice;
                if (property.equals(TABLE_WS_COLUMN_PROPERTIES[0])) {
                    value = EGLDDWebServicesBlock.this.getGenWSType(ws, rs);
                } else if (property.equals(TABLE_WS_COLUMN_PROPERTIES[1])) {
                    if (ws != null) {
                        value = ws.getImplementation();
                    } else if (rs != null) {
                        value = rs.getImplementation();
                    }
                }
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableitem;
            Object tableitemdata;
            if (element instanceof TableItem && (tableitemdata = (tableitem = (TableItem)element).getData()) instanceof RowItem) {
                Integer newIndexInt;
                int newIndex;
                RowItem rowitem = (RowItem)tableitemdata;
                if (property.equals(TABLE_WS_COLUMN_PROPERTIES[0]) && (newIndex = (newIndexInt = (Integer)value).intValue()) >= 0 && newIndex < GEN_WS_TYPES.length) {
                    EGLDDWebServicesBlock.this.handleGenWSTypeChanged(rowitem, newIndex);
                    tableitem.setText(0, GEN_WS_TYPES[newIndex]);
                }
            }
        }
    }

    private class WSLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private WSLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1) {
                return EGLDDWebServicesBlock.getImageIcon(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof RowItem) {
                RowItem rowitem = (RowItem)element;
                Service ws = rowitem.webservice;
                Service rs = rowitem.restservice;
                switch (columnIndex) {
                    case 0: {
                        int genWsType = EGLDDWebServicesBlock.this.getGenWSType(ws, rs);
                        return GEN_WS_TYPES[genWsType];
                    }
                    case 1: {
                        if (ws != null) {
                            return ws.getImplementation();
                        }
                        if (rs == null) break;
                        return rs.getImplementation();
                    }
                }
            }
            return "";
        }

        public String getText(Object element) {
            return this.getColumnText(element, 1);
        }
    }

    public static class WSListContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            HashMap<String, RowItem> children = new HashMap<String, RowItem>();
            ArrayList<RowItem> childrenValues = new ArrayList<RowItem>();
            if (inputElement instanceof EGLDeploymentRoot) {
                EGLDeploymentRoot root = (EGLDeploymentRoot)inputElement;
                Deployment deployment = root.getDeployment();
                Services services = deployment.getServices();
                int i = 0;
                if (services != null) {
                    for (Service s : services.getService()) {
                        RowItem rowitem = null;
                        Object item = children.get(s.getImplementation());
                        if (item != null) {
                            rowitem = (RowItem)item;
                        } else {
                            rowitem = new RowItem();
                            rowitem.index = i++;
                            children.put(s.getImplementation(), rowitem);
                            childrenValues.add(rowitem);
                        }
                        if (!org.eclipse.edt.ide.deployment.core.model.Service.SERVICE_REST.equals(s.getType())) continue;
                        rowitem.restservice = s;
                    }
                }
            }
            return childrenValues.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class WSListLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            return EGLDDWebServicesBlock.getImageIcon(element);
        }

        public String getText(Object element) {
            if (element instanceof RowItem) {
                RowItem rowitem = (RowItem)element;
                Service ws = rowitem.webservice;
                Service rs = rowitem.restservice;
                if (ws != null) {
                    return ws.getImplementation();
                }
                if (rs != null) {
                    return rs.getImplementation();
                }
            }
            return "";
        }
    }
}

