/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor.sql;

import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.ForUpdateClause;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.NoCursorClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WithIDClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.EGLAliasJsfNamesSetting;
import org.eclipse.edt.compiler.internal.EGLVAGCompatibilitySetting;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLSQLParser;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.editor.sql.SQLIOStatementActionInfo;

public class SQLIOStatementUtility {
    public static SQLIOStatementActionInfo getAddSQLIoStatementActionInfo(IEGLDocument document, Node node) {
        SQLIOStatementActionInfo info = new SQLIOStatementActionInfo();
        info.setDocument(document);
        if (node == null) {
            return info;
        }
        try {
            SQLIOStatementUtility.setupActionInfo(node, info);
        }
        catch (Exception e) {
            e.printStackTrace();
            EGLLogger.log(SQLIOStatementUtility.class, e);
        }
        return info;
    }

    private static SQLIOStatementActionInfo setupActionInfo(Node node, final SQLIOStatementActionInfo info) {
        final ICompilerOptions compileOptions = new ICompilerOptions(){

            public boolean isVAGCompatible() {
                return EGLVAGCompatibilitySetting.isVAGCompatibility();
            }

            public boolean isAliasJSFNames() {
                return EGLAliasJsfNamesSetting.isAliasJsfNames();
            }
        };
        info.setCompilerOption(compileOptions);
        if (node instanceof AddStatement) {
            AddStatement addStatement = (AddStatement)node;
            info.setIOType("add".toUpperCase());
            info.setStatement((Statement)addStatement);
            addStatement.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(WithInlineSQLClause inlineSQL) {
                    info.setSqlStatement(inlineSQL.getSqlStmt().getValue());
                    info.setSqlStatementNode((Node)inlineSQL);
                    return false;
                }
            });
        } else if (node instanceof ExecuteStatement) {
            ExecuteStatement executeStatement = (ExecuteStatement)node;
            info.setStatement((Statement)executeStatement);
            info.setIOType("execute".toUpperCase());
        } else if (node instanceof GetByKeyStatement) {
            GetByKeyStatement getStatement = (GetByKeyStatement)node;
            getStatement.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(ForUpdateClause forUpdate) {
                    info.setIOType("get forUpdate".toUpperCase());
                    return false;
                }

                public boolean visit(WithIDClause prepareID) {
                    info.setHasPreparedStatementReference(true);
                    return false;
                }

                public boolean visit(WithInlineSQLClause inlineSQL) {
                    info.setSqlStatement(inlineSQL.getSqlStmt().getValue());
                    info.setSqlStatementNode((Node)inlineSQL);
                    return false;
                }

                public boolean visit(IntoClause intoClause) {
                    info.setIntoClauseNode((Node)intoClause);
                    return false;
                }

                public boolean visit(UsingKeysClause keysClause) {
                    info.setUsingKeysNode((Node)keysClause);
                    return false;
                }

                public boolean visit(UsingClause keysClause) {
                    info.setUsingExisted(true);
                    return false;
                }
            });
            if (info.getIOType() == null) {
                info.setIOType("get".toUpperCase());
            }
            info.setStatement((Statement)getStatement);
        } else if (node instanceof OpenStatement) {
            OpenStatement openStatement = (OpenStatement)node;
            info.setStatement((Statement)openStatement);
            openStatement.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(ForUpdateClause forUpdate) {
                    info.setIOType("open forUpdate".toUpperCase());
                    return false;
                }

                public boolean visit(WithIDClause prepareID) {
                    info.setShouldAddSQLStatement(false);
                    info.setHasPreparedStatementReference(true);
                    return false;
                }

                public boolean visit(WithInlineSQLClause inlineSQL) {
                    info.setShouldAddSQLStatement(false);
                    info.setSqlStatement(inlineSQL.getSqlStmt().getValue());
                    info.setSqlStatementNode((Node)inlineSQL);
                    EGLSQLParser parser = new EGLSQLParser(info.getSqlStatement(), "open", compileOptions);
                    String selectClause = parser.getSelectClause();
                    if (selectClause != null) {
                        info.setOpenWithSelectStatement(true);
                    }
                    return false;
                }

                public boolean visit(IntoClause intoClause) {
                    info.setIntoClauseNode((Node)intoClause);
                    return false;
                }
            });
            if (info.getIOType() == null) {
                info.setIOType("open".toUpperCase());
            }
        } else if (node instanceof ReplaceStatement) {
            ReplaceStatement replaceStatement = (ReplaceStatement)node;
            info.setIOType("replace".toUpperCase());
            info.setStatement((Statement)replaceStatement);
            replaceStatement.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(WithInlineSQLClause inlineSQL) {
                    info.setSqlStatement(inlineSQL.getSqlStmt().getValue());
                    info.setSqlStatementNode((Node)inlineSQL);
                    return false;
                }

                public boolean visit(NoCursorClause noCursor) {
                    info.setNoCursor(true);
                    return false;
                }
            });
        } else if (node instanceof GetByPositionStatement) {
            GetByPositionStatement getByPositionStatement = (GetByPositionStatement)node;
            info.setIOType("get by position".toUpperCase());
            if (getByPositionStatement.isNextDirection()) {
                info.setGetNext(true);
            }
            info.setStatement((Statement)getByPositionStatement);
            getByPositionStatement.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(IntoClause intoClause) {
                    info.setIntoClauseNode((Node)intoClause);
                    return false;
                }
            });
        } else if (node instanceof CloseStatement) {
            info.setIOType("close".toUpperCase());
            info.setStatement((Statement)((CloseStatement)node));
        } else if (node instanceof DeleteStatement) {
            DeleteStatement deleteStatement = (DeleteStatement)node;
            info.setIOType("delete".toUpperCase());
            info.setStatement((Statement)deleteStatement);
            deleteStatement.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(WithInlineSQLClause inlineSQL) {
                    info.setSqlStatement(inlineSQL.getSqlStmt().getValue());
                    info.setSqlStatementNode((Node)inlineSQL);
                    return false;
                }

                public boolean visit(NoCursorClause noCursor) {
                    info.setNoCursor(true);
                    return false;
                }
            });
        }
        return info;
    }
}

