/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.eglarpackager;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarOptionsPage;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackageData;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackageWizardPage;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackagerMessages;
import org.eclipse.edt.ide.ui.internal.eglarpackager.IEglarExportRunnable;
import org.eclipse.edt.ide.ui.internal.eglarpackager.IEglarPackageWizardPage;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class EglarPackageWizard
extends Wizard
implements IExportWizard {
    private static String DIALOG_SETTINGS_KEY = "EglarPackageWizard";
    private boolean fHasNewDialogSettings;
    private boolean fInitializeFromEglarPackage;
    private EglarPackageData fEglarPackage;
    private EglarPackageWizardPage fEglarPackageWizardPage;
    private EglarOptionsPage fEglarOptionsWizardPage;
    private IStructuredSelection fSelection;

    public EglarPackageWizard() {
        IDialogSettings workbenchSettings = EDTUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fHasNewDialogSettings = true;
        } else {
            this.fHasNewDialogSettings = false;
            this.setDialogSettings(section);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fEglarPackageWizardPage) {
            return this.fEglarOptionsWizardPage;
        }
        if (page == this.fEglarOptionsWizardPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public void addPages() {
        this.fEglarPackageWizardPage = new EglarPackageWizardPage(this.fEglarPackage, this.fSelection);
        this.addPage(this.fEglarPackageWizardPage);
        this.fEglarOptionsWizardPage = new EglarOptionsPage(this.fEglarPackage);
        this.addPage(this.fEglarOptionsWizardPage);
        super.addPages();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = this.getValidSelection();
        this.fEglarPackage = new EglarPackageData();
        this.fEglarPackage.setExportEGLSrcFiles(false);
        this.setInitializeFromEglarPackage(false);
        this.setWindowTitle(EglarPackagerMessages.EglarPackageWizard_windowTitle);
        this.setNeedsProgressMonitor(true);
    }

    void setInitializeFromEglarPackage(boolean state) {
        this.fInitializeFromEglarPackage = state;
    }

    protected boolean executeExportOperation(IEglarExportRunnable op) {
        block4: {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() == null) break block4;
                ExceptionHandler.handle((InvocationTargetException)ex, (Shell)this.getShell(), (String)EglarPackagerMessages.EglarPackageWizard_EglarExportError_title, (String)EglarPackagerMessages.EglarPackageWizard_EglarExportError_message);
                return false;
            }
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)EglarPackagerMessages.EglarPackageWizard_EglarExport_title, null, (IStatus)status);
            return !status.matches(4);
        }
        return true;
    }

    protected IStructuredSelection getValidSelection() {
        ISelection currentSelection = EDTUIPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            ArrayList<IEGLProject> selectedElements = this.getProjectsOfSelection(structuredSelection);
            return new StructuredSelection(selectedElements);
        }
        return StructuredSelection.EMPTY;
    }

    private ArrayList<IEGLProject> getProjectsOfSelection(IStructuredSelection structuredSelection) {
        Iterator iter = structuredSelection.iterator();
        ArrayList<IEGLProject> selectedProjects = new ArrayList<IEGLProject>();
        while (iter.hasNext()) {
            Object selectedElement = iter.next();
            IProject temp = null;
            if (selectedElement instanceof IProject) {
                temp = (IProject)selectedElement;
            } else if (selectedElement instanceof IResource) {
                temp = ((IResource)selectedElement).getProject();
            } else if (selectedElement instanceof IEGLElement) {
                temp = ((IEGLElement)selectedElement).getEGLProject().getProject();
            } else if (selectedElement instanceof IPackageFragmentRoot) {
                temp = ((IPackageFragmentRoot)selectedElement).getJavaProject().getProject();
            }
            if (temp == null || !this.checkIfEGLProjectAndNotBin(temp)) continue;
            selectedProjects.add(EGLCore.create((IProject)temp));
        }
        return selectedProjects;
    }

    private boolean checkIfEGLProjectAndNotBin(IProject project) {
        try {
            IEGLProject ieglProject = EGLCore.create((IProject)project);
            if (project.hasNature(EGLCore.NATURE_ID) && !ieglProject.isBinary()) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    boolean isInitializingFromEglarPackage() {
        return this.fInitializeFromEglarPackage;
    }

    public boolean performFinish() {
        this.fEglarPackage.setElements(this.fEglarPackageWizardPage.getSelectedElementsWithoutContainedChildren());
        if (!this.executeExportOperation(this.fEglarPackage.createEglarExportRunnable(this.getShell()))) {
            return false;
        }
        if (this.fHasNewDialogSettings) {
            IDialogSettings workbenchSettings = EDTUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < this.getPageCount()) {
            IWizardPage page = pages[i];
            if (page instanceof IEglarPackageWizardPage) {
                ((IEglarPackageWizardPage)page).finish();
            }
            ++i;
        }
        return true;
    }
}

