/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.CallbackTarget;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocument;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.handlers.EGLHandler;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceConfiguration;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.FileEditorInput;

public class CreateCallbackFunctionHandler
extends EGLHandler {
    private ITextSelection fCurrSelection;
    private Part part;
    private EGLDocument document;
    private String fCurrPkg = "";
    private EGLEditor editor;
    private static String RETARGNAME = "retResult";
    private static String EXPARGNAME = "exp";
    private static String EXPPARAMNAME = "AnyException";

    @Override
    public void run() {
        this.update();
        IFile currentFile = ((FileEditorInput)this.editor.getEditorInput()).getFile();
        EGLFile eglFile = (EGLFile)EGLCore.create((IFile)currentFile);
        final int[] importInsertionOffset = new int[1];
        final ArrayList currImports = new ArrayList();
        File fileAST = this.document.getNewModelEGLFile();
        fileAST.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(File file) {
                return true;
            }

            public boolean visit(PackageDeclaration packageDeclaration) {
                CreateCallbackFunctionHandler.this.fCurrPkg = packageDeclaration.getName().getCanonicalString();
                importInsertionOffset[0] = packageDeclaration.getOffset() + packageDeclaration.getLength();
                return true;
            }

            public boolean visit(ImportDeclaration importDeclaration) {
                currImports.add(importDeclaration);
                importInsertionOffset[0] = importDeclaration.getOffset() + importDeclaration.getLength();
                return true;
            }
        });
        final String newLine = TextUtilities.getDefaultLineDelimiter((IDocument)this.document);
        Part boundPart = EGLFileConfiguration.getBoundPart((IEGLFile)eglFile, this.part.getName().getCanonicalName());
        boundPart.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(CallStatement callStatement) {
                MultiTextEdit compositeEdit = new MultiTextEdit();
                int cursorOffset = CreateCallbackFunctionHandler.this.fCurrSelection.getOffset();
                int endingOffset = callStatement.getOffset() + callStatement.getLength();
                if (callStatement.getOffset() <= cursorOffset && cursorOffset <= endingOffset) {
                    Node ContainerFunction = CreateCallbackFunctionHandler.this.getContainerFunction((Node)callStatement);
                    int insertionOffset = ContainerFunction != null ? ContainerFunction.getOffset() + ContainerFunction.getLength() : 0;
                    Expression serviceFunctionExpr = callStatement.getInvocationTarget();
                    Expression callbackExpr = null;
                    Expression errCallbackExpr = null;
                    CallbackTarget callbackTgt = callStatement.getCallbackTarget();
                    CallbackTarget errCallbackTgt = callStatement.getErrorCallbackTarget();
                    if (callbackTgt != null) {
                        callbackExpr = callbackTgt.getExpression();
                    }
                    if (errCallbackTgt != null) {
                        errCallbackExpr = errCallbackTgt.getExpression();
                    }
                    boolean bCallbackCreated = false;
                    if (callbackExpr != null) {
                        bCallbackCreated = CreateCallbackFunctionHandler.this.createCallbackFunction((TextEdit)compositeEdit, insertionOffset, serviceFunctionExpr, callbackExpr, newLine, currImports, CreateCallbackFunctionHandler.this.fCurrPkg, importInsertionOffset[0]);
                    }
                    boolean bErrCallbackCreated = false;
                    if (errCallbackExpr != null) {
                        bErrCallbackCreated = CreateCallbackFunctionHandler.this.createErrCallbackFunction((TextEdit)compositeEdit, insertionOffset, serviceFunctionExpr, errCallbackExpr, newLine);
                    }
                    if (!bCallbackCreated && !bErrCallbackCreated) {
                        String errMsg = "";
                        if (callbackExpr != null && errCallbackExpr == null) {
                            errMsg = UINlsStrings.bind((String)"A callback function with name ''{0}'' already existed.", (Object)callbackExpr.getCanonicalString());
                        } else if (errCallbackExpr != null && callbackExpr == null) {
                            errMsg = UINlsStrings.bind((String)"An error callback function with name ''{0}'' already existed.", (Object)errCallbackExpr.getCanonicalString());
                        } else if (callbackExpr != null && errCallbackExpr != null) {
                            errMsg = UINlsStrings.bind((String)"A callback function with name ''{0}'' and an error callback function with name ''{1}'' already existed.", (Object)callbackExpr.getCanonicalString(), (Object)errCallbackExpr.getCanonicalString());
                        }
                        MessageDialog.openInformation((Shell)CreateCallbackFunctionHandler.this.editor.getSite().getShell(), (String)"Create callback functions", (String)errMsg);
                    } else {
                        try {
                            if (compositeEdit.hasChildren()) {
                                compositeEdit.apply((IDocument)CreateCallbackFunctionHandler.this.document);
                                String statusBarMsg = "";
                                if (bCallbackCreated && bErrCallbackCreated) {
                                    statusBarMsg = UINlsStrings.bind((String)"Callback function ''{0}'' and error callback function ''{1}'' are created", (Object)callbackExpr.getCanonicalString(), (Object)errCallbackExpr.getCanonicalString());
                                } else if (bCallbackCreated) {
                                    statusBarMsg = UINlsStrings.bind((String)"Callback function ''{0}'' created", (Object)callbackExpr.getCanonicalString());
                                } else if (bErrCallbackCreated) {
                                    statusBarMsg = UINlsStrings.bind((String)"Error callback function ''{0}'' created", (Object)errCallbackExpr.getCanonicalString());
                                }
                                CreateCallbackFunctionHandler.this.setStatusBarMessage(statusBarMsg);
                            }
                        }
                        catch (MalformedTreeException e) {
                            e.printStackTrace();
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return false;
            }
        });
    }

    public void update() {
        this.setEnabled(false);
        this.fCurrSelection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        if (doc instanceof EGLDocument) {
            this.document = (EGLDocument)doc;
            this.part = this.document.getNewModelPartAtOffset(this.fCurrSelection.getOffset());
            if (this.part != null) {
                this.part.accept((IASTVisitor)new AbstractASTVisitor(){

                    public boolean visit(CallStatement callStatement) {
                        int cursorOffset = CreateCallbackFunctionHandler.this.fCurrSelection.getOffset();
                        int endingOffset = callStatement.getOffset() + callStatement.getLength();
                        if (callStatement.getOffset() <= cursorOffset && cursorOffset <= endingOffset && (callStatement.getCallbackTarget() != null || callStatement.getErrorCallbackTarget() != null)) {
                            CreateCallbackFunctionHandler.this.setEnabled(true);
                        }
                        return false;
                    }
                });
            }
        }
    }

    private Node getContainerFunction(Node callstmt) {
        Node parent = callstmt.getParent();
        while (parent != null && !(parent instanceof NestedFunction)) {
            parent = this.getContainerFunction(parent);
        }
        return parent;
    }

    private String getCallbackFunctionString(Expression serviceExpr, Name callbckFuncName, ICallbackArgumentPrinter callbackArgPrinter, String newLine) {
        StringBuffer callBackFuncStr = new StringBuffer();
        callBackFuncStr.append(newLine);
        callBackFuncStr.append(newLine);
        callBackFuncStr.append("\t");
        callBackFuncStr.append("function");
        callBackFuncStr.append(" ");
        String callbackFuncName = callbckFuncName.getCaseSensitiveIdentifier();
        callBackFuncStr.append(callbackFuncName);
        callBackFuncStr.append('(');
        callbackArgPrinter.printArgs(serviceExpr, callBackFuncStr);
        callBackFuncStr.append(')');
        callBackFuncStr.append(newLine);
        callBackFuncStr.append("\t");
        callBackFuncStr.append("end");
        return callBackFuncStr.toString();
    }

    private boolean createErrCallbackFunction(TextEdit textEdit, int insertOffset, Expression serviceExpr, Expression errCallbackExpr, String newLine) {
        boolean createdFunction = false;
        IDataBinding dataBinding = errCallbackExpr.resolveDataBinding();
        if (!Binding.isValidBinding((IBinding)dataBinding)) {
            if (errCallbackExpr.isName()) {
                Name callbackExprName = (Name)errCallbackExpr;
                String funcStr = this.getCallbackFunctionString(serviceExpr, callbackExprName, new ICallbackArgumentPrinter(){

                    @Override
                    public void printArgs(Expression serviceExpr, StringBuffer strbuf) {
                        CreateCallbackFunctionHandler.this.appendArgument(EXPARGNAME, EXPPARAMNAME, true, strbuf);
                    }
                }, newLine);
                textEdit.addChild((TextEdit)new InsertEdit(insertOffset, funcStr));
                createdFunction = true;
            }
        } else {
            createdFunction = false;
        }
        return createdFunction;
    }

    private boolean createCallbackFunction(final TextEdit textEdit, int insertOffset, Expression serviceExpr, Expression callbackExpr, final String newLine, final List currImports, final String currFilePkg, final int newImportInsertOffset) {
        boolean createdFunction = false;
        IDataBinding dataBinding = callbackExpr.resolveDataBinding();
        if (!Binding.isValidBinding((IBinding)dataBinding)) {
            if (callbackExpr.isName()) {
                Name callbackExprName = (Name)callbackExpr;
                String funcStr = this.getCallbackFunctionString(serviceExpr, callbackExprName, new ICallbackArgumentPrinter(){

                    @Override
                    public void printArgs(Expression serviceExpr, StringBuffer strbuf) {
                        CreateCallbackFunctionHandler.this.createCallbackFunctionArguments(serviceExpr, strbuf, newLine, currImports, currFilePkg, newImportInsertOffset, textEdit);
                    }
                }, newLine);
                textEdit.addChild((TextEdit)new InsertEdit(insertOffset, funcStr));
                createdFunction = true;
            }
        } else {
            createdFunction = false;
        }
        return createdFunction;
    }

    private void createCallbackFunctionArguments(Expression serviceExpr, StringBuffer strbuf, String newLine, List currImports, String currFilePkg, int newImportInsertOffset, TextEdit textEdit) {
        ITypeBinding serviceExprBinding = serviceExpr.resolveTypeBinding();
        if (serviceExprBinding != null && serviceExprBinding.getKind() == 20) {
            HashSet<String> argNames = new HashSet<String>();
            HashSet insertedImports = new HashSet();
            FunctionBinding svrFuncBinding = (FunctionBinding)serviceExprBinding;
            List params = svrFuncBinding.getParameters();
            boolean isFirst = true;
            for (Object obj : params) {
                FunctionParameterBinding paramBinding;
                if (!(obj instanceof FunctionParameterBinding) || !(paramBinding = (FunctionParameterBinding)obj).isOutput() && !paramBinding.isInputOutput()) continue;
                String argName = paramBinding.getCaseSensitiveName();
                argNames.add(argName);
                this.appendArgument(argName, paramBinding.getType(), isFirst, strbuf, newLine, currImports, currFilePkg, newImportInsertOffset, textEdit, insertedImports);
                isFirst = false;
            }
            ITypeBinding retType = svrFuncBinding.getReturnType();
            if (Binding.isValidBinding((IBinding)retType)) {
                int n = 1;
                String retArgNm = RETARGNAME;
                while (argNames.contains(retArgNm)) {
                    retArgNm = String.valueOf(RETARGNAME) + Integer.toString(n);
                    ++n;
                }
                this.appendArgument(retArgNm, retType, isFirst, strbuf, newLine, currImports, currFilePkg, newImportInsertOffset, textEdit, insertedImports);
                isFirst = false;
            }
        }
    }

    private void appendArgument(String argName, ITypeBinding paramTypeBinding, boolean isFirst, StringBuffer strbuf, String newLine, List currImports, String currFilePkg, int newImportInsertOffset, TextEdit textEdit, Set insertedImports) {
        String qualifier;
        StringBuffer strBufTypeName = new StringBuffer();
        ExtractInterfaceConfiguration.getSimpleTypeString(paramTypeBinding, strBufTypeName);
        this.appendArgument(argName, strBufTypeName.toString(), isFirst, strbuf);
        if (paramTypeBinding.getBaseType().isPartBinding() && !(qualifier = ExtractInterfaceConfiguration.getReferenceTypeParamQualifier(paramTypeBinding, currFilePkg)).equalsIgnoreCase(currFilePkg)) {
            String strImport = String.valueOf(qualifier) + (qualifier.length() > 0 ? "." : "");
            strImport = String.valueOf(strImport) + paramTypeBinding.getBaseType().getCaseSensitiveName();
            boolean existed = false;
            Iterator it = currImports.iterator();
            while (it.hasNext() && !existed) {
                ImportDeclaration importDecl = (ImportDeclaration)it.next();
                String simport = importDecl.getName().getCanonicalName();
                if (importDecl.isOnDemand()) {
                    if (!simport.equalsIgnoreCase(qualifier)) continue;
                    existed = true;
                    continue;
                }
                if (!simport.equalsIgnoreCase(strImport)) continue;
                existed = true;
            }
            if (!existed) {
                existed = insertedImports.contains(strImport);
            }
            if (!existed && strImport.length() > 0) {
                insertedImports.add(strImport);
                StringBuffer importStr = new StringBuffer();
                importStr.append(newLine);
                importStr.append("import");
                importStr.append(' ');
                importStr.append(strImport);
                importStr.append(';');
                textEdit.addChild((TextEdit)new InsertEdit(newImportInsertOffset, importStr.toString()));
            }
        }
    }

    private void appendArgument(String argName, String typeName, boolean isFirst, StringBuffer strbuf) {
        if (!isFirst) {
            strbuf.append(", ");
        }
        strbuf.append(argName);
        strbuf.append(' ');
        strbuf.append(typeName);
        strbuf.append(' ');
        strbuf.append("in");
    }

    protected void setStatusBarMessage(String message) {
        IEditorActionBarContributor contributor = this.editor.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            IStatusLineManager manager = ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
            manager.setMessage(message);
        }
    }

    private static interface ICallbackArgumentPrinter {
        public void printArgs(Expression var1, StringBuffer var2);
    }
}

