/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.HandlerConfiguration;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.HandlerOperation;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.HandlerTemplatePage;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.NewHandlerWizardMessages;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.NewHandlerWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLFileWizard;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizardPage;
import org.eclipse.edt.ide.ui.templates.wizards.TemplateWizardNode;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.edt.ide.ui.wizards.PartTemplateException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewHandlerWizard
extends EGLFileWizard {
    private static final String WIZPAGENAME_HandlerWizardPage = "WIZPAGENAME_HandlerWizardPage";
    private static final String WIZPAGENAME_HandlerTemplatePage = "WIZPAGENAME_HandlerTemplatePage";
    private static String Visual_Editor_Registered_ID = "org.eclipse.edt.ide.rui.visualeditor.EvEditor";
    private NewHandlerWizardPage mainPage;
    private HandlerTemplatePage templatePage;
    private ISelection selection;
    private Object contentObj;

    public NewHandlerWizard() {
        this.setWindowTitle(NewHandlerWizardMessages.NewHandlerWizard_title);
    }

    @Override
    public void addPages() {
        this.mainPage = new NewHandlerWizardPage(WIZPAGENAME_HandlerWizardPage);
        this.addPage((IWizardPage)this.mainPage);
        this.templatePage = new HandlerTemplatePage(WIZPAGENAME_HandlerTemplatePage);
        this.addPage((IWizardPage)this.templatePage);
    }

    @Override
    public boolean performFinish() {
        TemplateWizardNode twn;
        if (!super.performFinish()) {
            return false;
        }
        IWizardNode node = this.templatePage.getSelectedNode();
        if (node instanceof TemplateWizardNode && (twn = (TemplateWizardNode)node).getTemplate().hasWizard() && !twn.getWizard().performFinish()) {
            return false;
        }
        IRunnableWithProgress operation = this.getOperation();
        if (operation != null) {
            try {
                this.getContainer().run(this.canRunForked(), true, this.getOperation());
            }
            catch (InterruptedException e) {
                boolean dialogResult = false;
                if (e.getMessage().indexOf(58) != -1) {
                    PartTemplateException pe = new PartTemplateException(e.getMessage());
                    if (pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_NOT_FOUND) == 0) {
                        dialogResult = ((EGLPartWizardPage)this.getPage(WIZPAGENAME_HandlerWizardPage)).handleTemplateError(pe.getPartType(), pe.getPartDescription());
                    } else if (pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_DISABLED) != 0 && pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_CORRUPTED) == 0) {
                        dialogResult = ((EGLPartWizardPage)this.getPage(WIZPAGENAME_HandlerWizardPage)).handleTemplateError(pe.getPartType(), pe.getPartDescription());
                    }
                    if (dialogResult) {
                        return this.performFinish();
                    }
                    return false;
                }
                EGLLogger.log((Object)this, e);
                return false;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof CoreException) {
                    ErrorDialog.openError((Shell)this.getContainer().getShell(), null, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
                } else {
                    EGLLogger.log((Object)this, e);
                }
                return false;
            }
        }
        this.openResource(this.configuration.getFile());
        return true;
    }

    public void setContentObj(Object obj) {
        this.contentObj = obj;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.getConfiguration().init(workbench, selection);
    }

    @Override
    public EGLPackageConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new HandlerConfiguration();
        }
        return this.configuration;
    }

    protected IRunnableWithProgress getOperation() {
        TemplateWizardNode twn;
        String codeTemplateId = null;
        IWizardNode node = this.templatePage.getSelectedNode();
        if (node instanceof TemplateWizardNode && !(twn = (TemplateWizardNode)node).getTemplate().hasWizard() && twn.getTemplate().getCodeTemplateId() != null) {
            codeTemplateId = twn.getTemplate().getCodeTemplateId();
        }
        HandlerOperation operation = null;
        ISchedulingRule rule = this.getCurrentSchedulingRule();
        operation = rule != null ? new HandlerOperation((HandlerConfiguration)this.getConfiguration(), codeTemplateId, this.contentObj, rule) : new HandlerOperation((HandlerConfiguration)this.getConfiguration(), codeTemplateId, this.contentObj);
        return operation;
    }

    @Override
    protected void openResource(final IFile resource) {
        Display display;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        final IWorkbenchPage activePage = window == null ? null : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IEditorDescriptor desc;
                        String editorID = null;
                        editorID = ((HandlerConfiguration)NewHandlerWizard.this.configuration).getHandlerType() == 1 ? Visual_Editor_Registered_ID : ((desc = IDE.getDefaultEditor((IFile)resource)) == null ? EDTUIPlugin.getDefault().getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor").getId() : desc.getId());
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (String)editorID);
                    }
                    catch (PartInitException e) {
                        EDTUIPlugin.log(e);
                    }
                }
            });
        }
    }
}

