/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import java.util.ArrayList;
import org.eclipse.edt.compiler.core.ast.ConstantFormField;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.outline.AbstractOutlineAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class FormOutlineAdapter
extends AbstractOutlineAdapter {
    public FormOutlineAdapter(EGLEditor editor) {
        super(editor);
        this.nodeIcon = PluginImages.DESC_OBJS_FORM;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        final ArrayList formFields = new ArrayList();
        Node form = (Node)parentElement;
        form.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(NestedForm nestedForm) {
                return true;
            }

            public boolean visit(TopLevelForm topLevelForm) {
                return true;
            }

            public boolean visit(VariableFormField variableFormField) {
                formFields.add(variableFormField);
                return false;
            }

            public boolean visit(ConstantFormField constantFormField) {
                formFields.add(constantFormField);
                return false;
            }
        });
        return formFields.toArray();
    }

    @Override
    public String getText(Object element) {
        Name type = null;
        Name formName = null;
        if (element instanceof TopLevelForm) {
            TopLevelForm form = (TopLevelForm)element;
            formName = form.getName();
            type = form.getSubType();
        } else if (element instanceof NestedForm) {
            NestedForm nestForm = (NestedForm)element;
            formName = nestForm.getName();
            type = nestForm.getSubType();
        }
        return String.valueOf(formName.getCanonicalString()) + (type == null ? "" : " : " + type.getCanonicalString());
    }

    @Override
    public IRegion getHighlightRange(Object element) {
        Name formName = null;
        if (element instanceof TopLevelForm) {
            formName = ((TopLevelForm)element).getName();
        } else if (element instanceof NestedForm) {
            formName = ((NestedForm)element).getName();
        } else {
            return new Region(0, 0);
        }
        return new Region(formName.getOffset(), formName.getLength());
    }
}

