/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import java.util.HashMap;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.ConstantFormField;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.FormGroup;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.outline.ClassFieldDeclarationOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.ConstantFormFieldOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.ConstructorOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.DataItemOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.DataTableOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.DelegateOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.EnumerationOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.ExternalTypeOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.FileOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.FormGroupOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.FormOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.FunctionOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.GenericOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.HandlerOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.IOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.ImportGroup;
import org.eclipse.edt.ide.ui.internal.outline.ImportGroupOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.ImportStatementOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.InterfaceOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.LibraryOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.PackageDeclarationOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.ProgramOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.RecordOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.ServiceOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.StructureContentOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.UseFormStatementOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.UseStatementOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.VariableFormFieldOutlineAdapter;

public class OutlineAdapterFactory {
    private HashMap adapterMap = new HashMap(500);
    private GenericOutlineAdapter genericOutlineAdapter = new GenericOutlineAdapter(null);
    private EGLEditor editor;

    public OutlineAdapterFactory(IEGLDocument document, EGLEditor editor) {
        this.editor = editor;
        this.createAdapters(document);
    }

    private void createAdapters(IEGLDocument document) {
        this.adapterMap.put(File.class, new FileOutlineAdapter(document, this.editor));
        this.adapterMap.put(ImportGroup.class, new ImportGroupOutlineAdapter(this.editor));
        this.adapterMap.put(Program.class, new ProgramOutlineAdapter(this.editor));
        this.adapterMap.put(Interface.class, new InterfaceOutlineAdapter(this.editor));
        this.adapterMap.put(Service.class, new ServiceOutlineAdapter(this.editor));
        this.adapterMap.put(PackageDeclaration.class, new PackageDeclarationOutlineAdapter(this.editor));
        this.adapterMap.put(ImportDeclaration.class, new ImportStatementOutlineAdapter(this.editor));
        this.adapterMap.put(ClassDataDeclaration.class, new ClassFieldDeclarationOutlineAdapter(this.editor));
        this.adapterMap.put(Constructor.class, new ConstructorOutlineAdapter(this.editor));
        this.adapterMap.put(TopLevelFunction.class, new FunctionOutlineAdapter(this.editor));
        this.adapterMap.put(NestedFunction.class, new FunctionOutlineAdapter(this.editor));
        this.adapterMap.put(DataItem.class, new DataItemOutlineAdapter(this.editor));
        this.adapterMap.put(Record.class, new RecordOutlineAdapter(this.editor));
        this.adapterMap.put(StructureItem.class, new StructureContentOutlineAdapter(this.editor));
        this.adapterMap.put(UseStatement.class, new UseStatementOutlineAdapter(this.editor));
        this.adapterMap.put(DataTable.class, new DataTableOutlineAdapter(this.editor));
        this.adapterMap.put(FormGroup.class, new FormGroupOutlineAdapter(this.editor));
        this.adapterMap.put(TopLevelForm.class, new FormOutlineAdapter(this.editor));
        this.adapterMap.put(NestedForm.class, new FormOutlineAdapter(this.editor));
        this.adapterMap.put(UseStatement.class, new UseFormStatementOutlineAdapter(this.editor));
        this.adapterMap.put(VariableFormField.class, new VariableFormFieldOutlineAdapter(this.editor));
        this.adapterMap.put(ConstantFormField.class, new ConstantFormFieldOutlineAdapter(this.editor));
        this.adapterMap.put(Library.class, new LibraryOutlineAdapter(this.editor));
        this.adapterMap.put(Handler.class, new HandlerOutlineAdapter(this.editor));
        this.adapterMap.put(Enumeration.class, new EnumerationOutlineAdapter(this.editor));
        this.adapterMap.put(Delegate.class, new DelegateOutlineAdapter(this.editor));
        this.adapterMap.put(ExternalType.class, new ExternalTypeOutlineAdapter(this.editor));
    }

    public boolean isDisplayableElement(Object element) {
        return this.adapterMap.containsKey(element.getClass());
    }

    public IOutlineAdapter adapt(Object element) {
        IOutlineAdapter adapter = (IOutlineAdapter)this.adapterMap.get(element.getClass());
        return adapter == null ? this.genericOutlineAdapter : adapter;
    }

    public boolean hasOutlineAdapter(Object element) {
        return this.adapterMap.get(element.getClass()) != null;
    }

    public void dispose() {
        IOutlineAdapter adapt2 = null;
        for (IOutlineAdapter adapt2 : this.adapterMap.values()) {
            adapt2.dispose();
        }
    }
}

