/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.outline.AbstractOutlineAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class StructureContentOutlineAdapter
extends AbstractOutlineAdapter {
    public StructureContentOutlineAdapter(EGLEditor editor) {
        super(editor);
        this.nodeIcon = PluginImages.DESC_OBJS_STRUCTUREITEM;
    }

    @Override
    public String getText(Object element) {
        StructureItem item = (StructureItem)element;
        StringBuffer buffer = new StringBuffer();
        if (item.hasLevel()) {
            buffer.append(item.getLevel());
            buffer.append(" ");
        }
        if (item.isEmbedded()) {
            buffer.append("EMBED : ");
            buffer.append(item.getType().getCanonicalName());
        } else if (item.isFiller()) {
            buffer.append(" *");
            if (item.hasOccurs()) {
                buffer.append("[");
                buffer.append(item.getOccurs());
                buffer.append("]");
            }
            if (item.getType() != null) {
                buffer.append(" : ");
                buffer.append(this.formatType(item.getType()));
            }
        } else if (item.getName() != null) {
            buffer.append(item.getName().getCanonicalName());
            if (item.hasOccurs()) {
                buffer.append("[");
                buffer.append(item.getOccurs());
                buffer.append("]");
            }
            if (item.getType() != null) {
                buffer.append(" : ");
                buffer.append(this.formatType(item.getType()));
            }
        }
        return buffer.toString();
    }

    @Override
    public IRegion getHighlightRange(Object element) {
        StructureItem item = (StructureItem)element;
        if (item != null) {
            if (item.isFiller()) {
                return new Region(item.getOffset(), 1);
            }
            if (item.getName() != null) {
                return new Region(item.getName().getOffset(), item.getName().getLength());
            }
            return new Region(item.getOffset(), item.getLength());
        }
        return new Region(0, 0);
    }
}

