/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.packageexplorer;

import java.text.Collator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.util.EGLModelUtil;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLPathContainer;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class EGLElementSorter
extends ViewerSorter {
    private static final int PROJECTS = 1;
    private static final int PACKAGEFRAGMENTROOTS = 2;
    private static final int PACKAGEFRAGMENT = 3;
    private static final int EGLFILES = 4;
    private static final int CLASSFILES = 5;
    private static final int PACKAGE_DECL = 10;
    private static final int IMPORT_CONTAINER = 11;
    private static final int IMPORT_DECLARATION = 12;
    private static final int EGLELEMENTS = 50;
    private static final int OTHERS = 51;
    private Collator collator;

    public int category(Object element) {
        if (element instanceof IEGLElement) {
            IEGLElement je = (IEGLElement)element;
            switch (je.getElementType()) {
                case 11: 
                case 12: {
                    return 10;
                }
                case 13: {
                    return 11;
                }
                case 14: {
                    return 12;
                }
                case 4: {
                    IPackageFragment pack = (IPackageFragment)je;
                    if (pack.getParent().getResource() instanceof IProject) {
                        return 2;
                    }
                    return 3;
                }
                case 3: {
                    return 2;
                }
                case 2: {
                    return 1;
                }
                case 7: {
                    return 5;
                }
                case 6: {
                    return 4;
                }
            }
            return 50;
        }
        if (element instanceof IProject) {
            return 1;
        }
        if (element instanceof IEGLPathContainer) {
            return 2;
        }
        return 51;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (cat1 == 1) {
            IWorkbenchAdapter a1 = (IWorkbenchAdapter)((IAdaptable)e1).getAdapter(IWorkbenchAdapter.class);
            IWorkbenchAdapter a2 = (IWorkbenchAdapter)((IAdaptable)e2).getAdapter(IWorkbenchAdapter.class);
            if (a1 != null && a2 != null) {
                return this.getCollator().compare(a1.getLabel(e1), a2.getLabel(e2));
            }
        }
        if (cat1 == 2) {
            int p2;
            int p1;
            IPackageFragmentRoot root1 = this.getPackageFragmentRoot(e1);
            IPackageFragmentRoot root2 = this.getPackageFragmentRoot(e2);
            if (!root1.getPath().equals((Object)root2.getPath()) && (p1 = this.getEGLPathIndex(root1)) != (p2 = this.getEGLPathIndex(root2))) {
                return p1 - p2;
            }
        }
        String name1 = null;
        String name2 = null;
        if (cat1 == 51 || cat2 == 51) {
            if (cat1 == 51 && e1 instanceof IResource) {
                name1 = ((IResource)e1).getName();
            }
            if (cat2 == 51 && e2 instanceof IResource) {
                name2 = ((IResource)e2).getName();
            }
        } else if (cat1 == 1 || cat1 == 51) {
            return this.compareWithLabelProvider(viewer, e1, e2);
        }
        if (name1 == null) {
            name1 = ((IEGLElement)e1).getElementName();
        }
        if (name2 == null) {
            name2 = ((IEGLElement)e2).getElementName();
        }
        if (name1 != null && name2 != null) {
            int cmp = this.getCollator().compare(name1, name2);
            if (cmp != 0) {
                return cmp;
            }
        } else {
            EGLLogger.log((Object)this, "An error occurred sorting navigator EGL elements.");
        }
        return 0;
    }

    public final Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        return this.collator;
    }

    private int compareWithLabelProvider(Viewer parent, Object e1, Object e2) {
        IBaseLabelProvider prov;
        if (parent instanceof ContentViewer && (prov = ((ContentViewer)parent).getLabelProvider()) instanceof ILabelProvider) {
            ILabelProvider lprov = (ILabelProvider)prov;
            String name1 = lprov.getText(e1);
            String name2 = lprov.getText(e2);
            if (name1 != null && name2 != null) {
                return this.getCollator().compare(name1, name2);
            }
        }
        return 0;
    }

    public String getSortName(Object element) {
        return ((IEGLElement)element).getResource().getName();
    }

    private IPackageFragmentRoot getPackageFragmentRoot(Object element) {
        return EGLModelUtil.getPackageFragmentRoot((IEGLElement)((IEGLElement)element));
    }

    private int getEGLPathIndex(IPackageFragmentRoot root) {
        try {
            IPath rootPath = root.getPath();
            IPackageFragmentRoot[] roots = root.getEGLProject().getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getPath().equals((Object)rootPath)) {
                    return i;
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
        return Integer.MAX_VALUE;
    }
}

