/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.packageexplorer;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.internal.packageexplorer.EGLElementContentProvider;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class EGLNavigatorContentProvider
extends EGLElementContentProvider
implements IPipelinedTreeContentProvider {
    public void getPipelinedChildren(Object parent, Set currentChildren) {
        Object[] children = this.getChildren(parent);
        Iterator iter = currentChildren.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof IResource) || EGLCore.create((IResource)((IResource)obj)) == null && !((IResource)obj).getName().equalsIgnoreCase("EGLGen") && !((IResource)obj).getName().equalsIgnoreCase("EGLbin")) continue;
            iter.remove();
        }
        currentChildren.addAll(Arrays.asList(children));
    }

    public void getPipelinedElements(Object input, Set currentElements) {
        Object[] children = this.getElements(input);
        Iterator iter = currentElements.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof IResource) || EGLCore.create((IResource)((IResource)obj)) == null) continue;
            iter.remove();
        }
        currentElements.addAll(Arrays.asList(children));
    }

    @Override
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)inputElement;
            return root.getProjects();
        }
        if (inputElement instanceof IEGLModel) {
            return ((IEGLModel)inputElement).getWorkspace().getRoot().getProjects();
        }
        if (inputElement instanceof IProject) {
            return super.getElements(EGLCore.create((IProject)((IProject)inputElement)));
        }
        return super.getElements(inputElement);
    }

    @Override
    public Object getParent(Object element) {
        Object parentObj = super.getParent(element);
        IProject proj = null;
        if (parentObj instanceof IProject) {
            proj = (IProject)parentObj;
        } else if (parentObj instanceof IEGLProject) {
            proj = ((IEGLProject)parentObj).getProject();
        } else if (parentObj instanceof IJavaProject) {
            IJavaProject javaProj = (IJavaProject)parentObj;
            proj = javaProj.getProject();
        }
        if (proj != null) {
            return proj;
        }
        return parentObj;
    }

    public Object getPipelinedParent(Object object, Object aSuggestedParent) {
        return this.getParent(object);
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        Object parent = anAddModification.getParent();
        if (parent instanceof IEGLProject) {
            anAddModification.setParent((Object)((IEGLProject)parent).getProject());
        }
        if (parent instanceof IWorkspaceRoot) {
            this.deconvertEGLProjects(anAddModification);
        }
        this.convertToEGLElements(anAddModification);
        return anAddModification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate refreshSynchronization) {
        return this.convertToEGLElements(refreshSynchronization.getRefreshTargets());
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        this.deconvertEGLProjects(aRemoveModification);
        this.convertToEGLElements(aRemoveModification.getChildren());
        return aRemoveModification;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return this.convertToEGLElements(anUpdateSynchronization.getRefreshTargets());
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    private boolean convertToEGLElements(PipelinedShapeModification modification) {
        IEGLElement element;
        Object parent = modification.getParent();
        if (parent instanceof IContainer && (element = EGLCore.create((IResource)((IContainer)parent))) != null && element.exists()) {
            if (!(element instanceof IEGLModel) && !(element instanceof IEGLProject)) {
                modification.setParent((Object)element);
            }
            return this.convertToEGLElements(modification.getChildren());
        }
        return false;
    }

    private boolean convertToEGLElements(Set currentChildren) {
        LinkedHashSet<Object> convertedChildren = new LinkedHashSet<Object>();
        Iterator childrenItr = currentChildren.iterator();
        while (childrenItr.hasNext()) {
            Object child = childrenItr.next();
            if (child instanceof IFolder || child instanceof IFile) {
                IEGLElement newChild = EGLCore.create((IResource)((IResource)child));
                if (newChild == null || !newChild.exists()) continue;
                childrenItr.remove();
                convertedChildren.add(newChild);
                continue;
            }
            if (!(child instanceof IEGLProject)) continue;
            childrenItr.remove();
            convertedChildren.add(((IEGLProject)child).getProject());
        }
        if (!convertedChildren.isEmpty()) {
            currentChildren.addAll(convertedChildren);
            return true;
        }
        return false;
    }

    private void deconvertEGLProjects(PipelinedShapeModification modification) {
        LinkedHashSet<IProject> convertedChildren = new LinkedHashSet<IProject>();
        Iterator iterator = modification.getChildren().iterator();
        while (iterator.hasNext()) {
            Object added = iterator.next();
            if (!(added instanceof IEGLProject)) continue;
            iterator.remove();
            convertedChildren.add(((IEGLProject)added).getProject());
        }
        modification.getChildren().addAll(convertedChildren);
    }
}

