/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.preferences;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.dialogs.OpenPartSelectionDialog;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.preferences.ImportOrganizeConfigurationBlock;
import org.eclipse.edt.ide.ui.internal.util.BusyIndicatorRunnableContext;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ImportOrganizeInputDialog
extends StatusDialog {
    private StringButtonDialogField fNameDialogField;
    private List fExistingEntries;

    public ImportOrganizeInputDialog(Shell parent, List existingEntries) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fExistingEntries = existingEntries;
        String title = UINlsStrings.ImportOrganizeInputDialog_title;
        String label = UINlsStrings.ImportOrganizeInputDialog_name_group_label;
        this.setTitle(title);
        ImportOrganizeInputAdapter adapter = new ImportOrganizeInputAdapter();
        this.fNameDialogField = new StringButtonDialogField(adapter);
        this.fNameDialogField.setLabelText(label);
        this.fNameDialogField.setButtonLabel(UINlsStrings.ImportOrganizeInputDialog_browse_types_label);
        this.fNameDialogField.setDialogFieldListener(adapter);
        this.fNameDialogField.setText("");
    }

    public void setInitialSelection(ImportOrganizeConfigurationBlock.ImportOrderEntry editedEntry) {
        Assert.isNotNull((Object)editedEntry);
        if (editedEntry.name.length() == 0) {
            this.fNameDialogField.setText("");
        } else {
            this.fNameDialogField.setText(editedEntry.name);
        }
    }

    public ImportOrganizeConfigurationBlock.ImportOrderEntry getResult() {
        String val = this.fNameDialogField.getText();
        if ("*".equals(val)) {
            return new ImportOrganizeConfigurationBlock.ImportOrderEntry("");
        }
        return new ImportOrganizeConfigurationBlock.ImportOrderEntry(val);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        this.fNameDialogField.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fNameDialogField.getLabelControl(null), 2);
        int fieldWidthHint = this.convertWidthInCharsToPixels(60);
        LayoutUtil.setWidthHint((Control)this.fNameDialogField.getTextControl(null), fieldWidthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null));
        this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
        ImportOrganizeInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    final void doBrowsePackages() {
        System.out.println("Not supported yet, need to implement EGL Package search");
        MessageDialog.openError((Shell)this.getShell(), (String)"Temp EGL title", (String)"Not yet supported, we cannot search for all the EGL packages in a workspace yet");
    }

    private void doBrowseTypes() {
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        IEGLSearchScope scope = SearchEngine.createWorkspaceScope();
        int style = Short.MAX_VALUE;
        OpenPartSelectionDialog dialog = new OpenPartSelectionDialog(this.getShell(), context, style, scope);
        dialog.setTitle(UINlsStrings.ImportOrganizeInputDialog_ChooseTypeDialog_title);
        dialog.setMessage(UINlsStrings.ImportOrganizeInputDialog_ChooseTypeDialog_description);
        dialog.setFilter(this.fNameDialogField.getText());
        if (dialog.open() == 0) {
            IPart res = (IPart)dialog.getResult()[0];
            this.fNameDialogField.setText(res.getFullyQualifiedName('.'));
        }
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.fNameDialogField.getText();
        if (newText.length() == 0) {
            status.setError("");
        } else if (newText.equals("*")) {
            if (this.doesExist("")) {
                status.setError(UINlsStrings.ImportOrganizeInputDialog_error_entryExists);
            }
        } else {
            IStatus val = EGLConventions.validateEGLTypeName((String)newText);
            if (val.matches(4)) {
                status.setError(UINlsStrings.ImportOrganizeInputDialog_error_invalidName);
            } else if (this.doesExist(newText)) {
                status.setError(UINlsStrings.ImportOrganizeInputDialog_error_entryExists);
            }
        }
        this.updateStatus(status);
    }

    private boolean doesExist(String name) {
        int i = 0;
        while (i < this.fExistingEntries.size()) {
            ImportOrganizeConfigurationBlock.ImportOrderEntry entry = (ImportOrganizeConfigurationBlock.ImportOrderEntry)this.fExistingEntries.get(i);
            if (name.equals(entry.name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, IUIHelpConstants.IMPORT_ORGANIZE_INPUT_DIALOG);
    }

    private class ImportOrganizeInputAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private ImportOrganizeInputAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            ImportOrganizeInputDialog.this.doValidation();
        }

        @Override
        public void changeControlPressed(DialogField field) {
            ImportOrganizeInputDialog.this.doBrowseTypes();
        }
    }
}

