/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.project.wizards;

import java.util.List;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.ui.internal.project.wizard.pages.BasicProjectGeneratorSelectionPage;
import org.eclipse.edt.ide.ui.internal.project.wizards.NewEGLProjectWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.project.templates.ProjectTemplateWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class BasicProjectTemplateWizard
extends ProjectTemplateWizard {
    private BasicProjectGeneratorSelectionPage generatorPage;

    @Override
    public void addPages() {
        this.generatorPage = new BasicProjectGeneratorSelectionPage(NewWizardMessages.GeneratorSelectionPage);
        this.addPage((IWizardPage)this.generatorPage);
        super.addPages();
    }

    @Override
    public boolean performFinish() {
        if (this.generatorPage != null) {
            String[] genIds = this.getGeneratorIds();
            if (genIds != null) {
                ((NewEGLProjectWizard)this.getParentWizard()).getModel().setSelectedGenerators(genIds);
            }
            return this.generatorPage.performOK();
        }
        return true;
    }

    private String[] getGeneratorIds() {
        String[] genIds = null;
        if (this.generatorPage != null) {
            List<String> selectedGenerators = this.generatorPage.getSelectedGenerators();
            genIds = new String[selectedGenerators.size()];
            int index = 0;
            StringBuilder buffer = new StringBuilder(100);
            for (String genName : selectedGenerators) {
                genIds[index] = this.convertGeneratorNameToId(genName);
                if (index != 0) {
                    buffer.append(',');
                }
                buffer.append(genIds[index]);
                ++index;
            }
        }
        return genIds;
    }

    private String convertGeneratorNameToId(String name) {
        if (name != null && name.length() > 0) {
            IGenerator[] generators;
            IGenerator[] iGeneratorArray = generators = EDTCoreIDEPlugin.getPlugin().getGenerators();
            int n = generators.length;
            int n2 = 0;
            while (n2 < n) {
                IGenerator currentGenerator = iGeneratorArray[n2];
                if (currentGenerator.getName().equalsIgnoreCase(name)) {
                    return currentGenerator.getId();
                }
                ++n2;
            }
        }
        return "";
    }
}

