/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record;

import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.record.NewRecordWizardMessages;
import org.eclipse.edt.ide.ui.templates.ITemplate;
import org.eclipse.edt.ide.ui.templates.TemplateManager;
import org.eclipse.edt.ide.ui.templates.wizards.TemplateWizardNode;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TemplateSelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener,
IDoubleClickListener {
    protected TableViewer templateViewer;
    protected Text descriptionText;

    public TemplateSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(NewRecordWizardMessages.TemplateSelectionPage_title);
        this.setDescription(NewRecordWizardMessages.TemplateSelectionPage_description);
        this.setImageDescriptor(PluginImages.DESC_WIZBAN_NEWTEMPLATESELECTION);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, IUIHelpConstants.EGL_NEW_RECORD_TEMPLATE_SELECTION_PAGE);
        container.setLayout((Layout)new GridLayout(2, true));
        Label label = new Label(container, 0);
        label.setText(NewRecordWizardMessages.TemplateSelectionPage_templatesLabel);
        label = new Label(container, 0);
        label.setText(NewRecordWizardMessages.TemplateSelectionPage_descriptionLabel);
        this.templateViewer = new TableViewer(container, 2048);
        Table control = this.templateViewer.getTable();
        GridData data = new GridData(1808);
        data.heightHint = 350;
        data.widthHint = 250;
        control.setLayoutData((Object)data);
        ITemplate[] templates = TemplateManager.getInstance().getTemplates("org.eclipse.edt.ide.ui.records");
        this.templateViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.templateViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.templateViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.templateViewer.setInput((Object)templates);
        this.templateViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.descriptionText = new Text(container, 2632);
        this.descriptionText.setLayoutData((Object)new GridData(1808));
        this.descriptionText.setBackground(control.getBackground());
        this.descriptionText.setForeground(control.getForeground());
        if (templates != null) {
            int i = 0;
            while (i < templates.length) {
                if (templates[i].isDefault()) {
                    this.templateViewer.setSelection((ISelection)new StructuredSelection(new Object[]{templates[i]}), true);
                }
                ++i;
            }
        }
        this.setControl((Control)container);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (o instanceof ITemplate) {
            this.handleSelectedTemplate();
            this.setTemplateDescription(((ITemplate)o).getDescription());
        }
        this.validatePage();
    }

    protected void validatePage() {
        Object o = ((IStructuredSelection)this.templateViewer.getSelection()).getFirstElement();
        if (o instanceof ITemplate) {
            ITemplate template = (ITemplate)o;
            TemplateWizardNode wizNode = (TemplateWizardNode)template.getWizardNode();
            this.handleSelectedTemplate();
            String templateID = ((ITemplate)o).getCodeTemplateId();
            boolean b = wizNode != null && wizNode.isContentCreated() && wizNode.getWizard() != null && wizNode.getWizard().canFinish() || templateID != null;
            this.setPageComplete(b);
        } else {
            this.setPageComplete(false);
        }
    }

    protected void handleSelectedTemplate() {
        Object o = ((IStructuredSelection)this.templateViewer.getSelection()).getFirstElement();
        if (o instanceof ITemplate) {
            ITemplate template = (ITemplate)o;
            TemplateWizardNode wizNode = (TemplateWizardNode)template.getWizardNode();
            if (wizNode != null) {
                wizNode.setParentWizard(this.getWizard());
                this.setSelectedNode(wizNode);
            } else {
                this.setSelectedNode(null);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validatePage();
            this.templateViewer.getTable().setFocus();
        }
    }

    private void setTemplateDescription(String text) {
        this.descriptionText.setText(text != null ? text : "");
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getSource() == this.templateViewer) {
            if (this.getSelectedNode() != null) {
                IWizard wiz = this.getWizard();
                IWizardContainer2 cfr_ignored_0 = (IWizardContainer2)wiz.getContainer();
                WizardDialog d = (WizardDialog)wiz.getContainer();
                d.showPage(this.getNextPage());
            } else if (this.getWizard().canFinish() && this.getWizard().performFinish()) {
                this.getWizard().getContainer().getShell().close();
            }
        }
    }

    private class TreeContentProvider
    implements IStructuredContentProvider {
        private TreeContentProvider() {
        }

        public Object[] getElements(Object input) {
            return (ITemplate[])input;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class TreeLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            if (element instanceof ITemplate && ((ITemplate)element).getIcon() != null) {
                return ((ITemplate)element).getIcon().createImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ITemplate) {
                return ((ITemplate)element).getName();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

