/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.conversion.xmlschema;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.edt.ide.ui.internal.record.NewRecordWizardMessages;
import org.eclipse.edt.ide.ui.internal.record.conversion.IMessageHandler;
import org.eclipse.edt.ide.ui.internal.record.conversion.PartsUtil;
import org.eclipse.edt.ide.ui.internal.record.conversion.xmlschema.WSDLUtil;
import org.eclipse.edt.ide.ui.templates.parts.Annotation;
import org.eclipse.edt.ide.ui.templates.parts.ArrayType;
import org.eclipse.edt.ide.ui.templates.parts.DataItem;
import org.eclipse.edt.ide.ui.templates.parts.DataItemType;
import org.eclipse.edt.ide.ui.templates.parts.DecimalType;
import org.eclipse.edt.ide.ui.templates.parts.Embed;
import org.eclipse.edt.ide.ui.templates.parts.Field;
import org.eclipse.edt.ide.ui.templates.parts.Part;
import org.eclipse.edt.ide.ui.templates.parts.Record;
import org.eclipse.edt.ide.ui.templates.parts.RecordType;
import org.eclipse.edt.ide.ui.templates.parts.SimpleType;
import org.eclipse.edt.ide.ui.templates.parts.Type;

public class PartsFromXMLSchemaUtil
extends PartsUtil {
    private XSModel xsModel = null;

    public PartsFromXMLSchemaUtil(IMessageHandler msgHandler) {
        super(msgHandler);
    }

    @Override
    public Part[] process(Object model, Record wrapRec) {
        XSTypeDefinition type;
        this.xsModel = (XSModel)model;
        LinkedHashMap<String, Part> recs = new LinkedHashMap<String, Part>();
        LinkedHashMap<XSTypeDefinition, Type> types = new LinkedHashMap<XSTypeDefinition, Type>();
        XSNamedMap map = this.xsModel.getComponents((short)3);
        int i = 0;
        while (i < map.getLength()) {
            type = (XSTypeDefinition)map.item(i);
            if (type.getTypeCategory() == 16 && !type.getNamespace().equals("http://www.w3.org/2001/XMLSchema") && !WSDLUtil.isStandardArray(type)) {
                this.processType(type, null, recs, types);
            }
            ++i;
        }
        i = 0;
        while (i < map.getLength()) {
            type = (XSTypeDefinition)map.item(i);
            if (type.getTypeCategory() == 15 && !type.getNamespace().equals("http://www.w3.org/2001/XMLSchema") && !WSDLUtil.isStandardArray(type)) {
                this.processType(type, null, recs, types);
            }
            ++i;
        }
        map = this.xsModel.getComponents((short)2);
        i = 0;
        while (i < map.getLength()) {
            XSObject xsObject = map.item(i);
            this.processElement(xsObject, null, recs, types);
            ++i;
        }
        return recs.values().toArray(new Part[recs.values().size()]);
    }

    private Type processElement(XSObject xsObject, Record wrapRec, LinkedHashMap<String, Part> recs, LinkedHashMap<XSTypeDefinition, Type> types) {
        Type type = null;
        if (xsObject instanceof XSElementDeclaration) {
            XSElementDeclaration xsElement = (XSElementDeclaration)xsObject;
            if (WSDLUtil.isStandardArray(xsElement.getTypeDefinition())) {
                type = this.processStandardArray((XSComplexTypeDefinition)xsElement.getTypeDefinition(), wrapRec, recs, types);
            } else if (xsElement.getTypeDefinition().getTypeCategory() == 15) {
                XSComplexTypeDefinition xsComplexType = (XSComplexTypeDefinition)xsElement.getTypeDefinition();
                type = types.get(xsComplexType);
                if (type == null) {
                    String typeName;
                    String rootName = typeName = wrapRec == null || xsComplexType.getName() == null ? xsElement.getName() : xsComplexType.getName();
                    if (this.isAnonymousCollision((XSTypeDefinition)xsComplexType, xsElement, wrapRec, typeName)) {
                        typeName = "_" + wrapRec.getName() + "_" + typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
                    }
                    type = xsComplexType.getContentType() == 1 ? this.processSimpleRecordType(xsComplexType, recs, types, typeName) : this.processRecordType(xsComplexType, recs, types, typeName, rootName);
                } else {
                    type = (Type)type.clone();
                }
            } else {
                XSSimpleTypeDefinition xsSimpleType = (XSSimpleTypeDefinition)xsElement.getTypeDefinition();
                type = types.get(xsSimpleType);
                type = type == null ? this.getPrimitiveType(xsObject, xsSimpleType, xsElement.getName()) : (Type)type.clone();
            }
        } else if (xsObject instanceof XSAttributeDeclaration) {
            XSAttributeDeclaration xsAttr = (XSAttributeDeclaration)xsObject;
            type = this.getPrimitiveType(xsObject, xsAttr.getTypeDefinition(), xsAttr.getName());
        } else {
            System.out.println("Don't know what type this is" + xsObject.toString());
        }
        return type;
    }

    private boolean isAnonymousCollision(XSTypeDefinition type, XSElementDeclaration element, Record wrapRec, String typeName) {
        if (type.getAnonymous() && wrapRec != null) {
            StringList list = this.xsModel.getNamespaces();
            int i = 0;
            while (i < list.getLength()) {
                String namespace = list.item(i);
                if (this.xsModel.getTypeDefinition(typeName, namespace) != null) {
                    return true;
                }
                ++i;
            }
            if (element.getScope() == 2 && element.getEnclosingCTDefinition() != null && !WSDLUtil.isStandardArray((XSTypeDefinition)element.getEnclosingCTDefinition()) && WSDLUtil.findLocalAnonymousElements(this.xsModel, typeName).length > 1) {
                return true;
            }
        }
        return false;
    }

    private Type processStandardArray(XSComplexTypeDefinition complexType, Record wrapRec, LinkedHashMap<String, Part> recs, LinkedHashMap<XSTypeDefinition, Type> types) {
        ArrayType type = new ArrayType();
        XSParticle particle = complexType.getParticle();
        XSObjectList list = ((XSModelGroup)particle.getTerm()).getParticles();
        XSParticle innerParticle = (XSParticle)list.item(0);
        XSElementDeclaration element = (XSElementDeclaration)innerParticle.getTerm();
        Type subType = this.processElement((XSObject)element, wrapRec, recs, types);
        subType.setNullable((element.getNillable() || particle.getMinOccurs() == 0) && !WSDLUtil.isSpecialArrayType(element.getTypeDefinition()));
        type.setElementType(subType);
        return type;
    }

    private Type processSimpleType(XSSimpleTypeDefinition simpleType, LinkedHashMap<String, Part> recs, LinkedHashMap<XSTypeDefinition, Type> types, String fieldName) {
        String typeName = this.getTypeName(fieldName);
        DataItemType type = new DataItemType();
        type.setName(typeName);
        String fn = typeName.toUpperCase().toLowerCase();
        if (recs.get(fn) == null) {
            DataItem dataItem = new DataItem();
            dataItem.setName(typeName);
            dataItem.setType(this.getPrimitiveType(null, simpleType, fieldName));
            recs.put(fn, dataItem);
        }
        return type;
    }

    private Type processType(XSTypeDefinition typeDefinition, Record wrapRec, LinkedHashMap<String, Part> recs, LinkedHashMap<XSTypeDefinition, Type> types) {
        Type type = null;
        if (typeDefinition.getTypeCategory() == 15) {
            XSComplexTypeDefinition xsComplexType = (XSComplexTypeDefinition)typeDefinition;
            String typeName = xsComplexType.getName();
            type = xsComplexType.getContentType() == 1 ? this.processSimpleRecordType(xsComplexType, recs, types, typeName) : this.processRecordType(xsComplexType, recs, types, typeName, typeName);
            types.put((XSTypeDefinition)xsComplexType, type);
        } else if (typeDefinition.getTypeCategory() == 16) {
            XSSimpleTypeDefinition xsSimpleType = (XSSimpleTypeDefinition)typeDefinition;
            String typeName = xsSimpleType.getName();
            type = this.processSimpleType(xsSimpleType, recs, types, typeName);
            types.put((XSTypeDefinition)xsSimpleType, type);
        }
        return type;
    }

    private HashMap<String, String> getFieldNames(XSComplexTypeDefinition xsComplexType, boolean isSimple) {
        XSModelGroup extGroup;
        XSModelGroup xsModelGroup;
        HashMap<String, String> fieldNames = new HashMap<String, String>();
        XSObjectList xsObjectList = xsComplexType.getAttributeUses();
        int i = 0;
        while (i < xsObjectList.getLength()) {
            XSAttributeUse xsAttrUse = (XSAttributeUse)xsObjectList.item(i);
            XSAttributeDeclaration xsAttrDecl = xsAttrUse.getAttrDeclaration();
            if (xsAttrDecl.getEnclosingCTDefinition() == null || xsAttrDecl.getEnclosingCTDefinition() == xsComplexType) {
                String originalName = xsAttrDecl.getName();
                fieldNames.put(originalName.toLowerCase(), originalName);
            }
            ++i;
        }
        if (!isSimple && xsComplexType.getParticle() != null && (xsModelGroup = (XSModelGroup)xsComplexType.getParticle().getTerm()) != (extGroup = WSDLUtil.getExtensionGroup(xsComplexType))) {
            this.getFieldNames(xsModelGroup, extGroup, fieldNames);
        }
        return fieldNames;
    }

    private void getFieldNames(XSModelGroup xsModelGroup, XSModelGroup extGroup, HashMap<String, String> fieldNames) {
        XSObjectList xsObjectList = xsModelGroup.getParticles();
        int i = 0;
        while (i < xsObjectList.getLength()) {
            XSParticle xsParticle = (XSParticle)xsObjectList.item(i);
            if (xsParticle.getTerm() instanceof XSModelGroup) {
                XSModelGroup group = (XSModelGroup)xsParticle.getTerm();
                if (group != extGroup) {
                    this.getFieldNames(group, null, fieldNames);
                }
            } else if (xsParticle.getTerm() instanceof XSElementDeclaration) {
                XSElementDeclaration xsElement = (XSElementDeclaration)xsParticle.getTerm();
                String originalName = xsElement.getName();
                fieldNames.put(originalName.toLowerCase(), originalName);
            }
            ++i;
        }
    }

    private void processChildAttributes(XSComplexTypeDefinition xsComplexType, Record wrapRec, LinkedHashMap<String, Part> recs, LinkedHashMap<XSTypeDefinition, Type> types, HashMap<String, String> fieldNames) {
        XSObjectList xsObjectList = xsComplexType.getAttributeUses();
        int i = 0;
        while (i < xsObjectList.getLength()) {
            XSAttributeUse xsAttrUse = (XSAttributeUse)xsObjectList.item(i);
            XSAttributeDeclaration xsAttrDecl = xsAttrUse.getAttrDeclaration();
            if (xsAttrDecl.getEnclosingCTDefinition() == null || xsAttrDecl.getEnclosingCTDefinition() == xsComplexType) {
                String fieldName;
                String originalName = xsAttrDecl.getName();
                String xmlName = originalName.equals(fieldName = this.getFieldName(originalName, wrapRec.getName(), fieldNames)) ? null : originalName;
                Field field = new Field();
                field.setName(fieldName);
                Type type = this.processElement((XSObject)xsAttrDecl, wrapRec, recs, types);
                type.setNullable(!xsAttrUse.getRequired());
                field.setType(type);
                Annotation annotation = new Annotation();
                annotation.setName("XMLAttribute");
                if (xmlName != null) {
                    annotation.addField("name", "\"" + xmlName + "\"");
                }
                if (xsAttrDecl.getNamespace() != null && xsAttrDecl.getNamespace().length() > 0) {
                    annotation.addField("namespace", "\"" + xsAttrDecl.getNamespace() + "\"");
                }
                field.addAnnotation(annotation);
                wrapRec.addField(field);
            }
            ++i;
        }
    }

    private void processChildElements(XSComplexTypeDefinition xsComplexType, Record wrapRec, LinkedHashMap<String, Part> recs, LinkedHashMap<XSTypeDefinition, Type> types, HashMap<String, String> fieldNames) {
        XSModelGroup extGroup;
        if (xsComplexType.getParticle() == null) {
            return;
        }
        XSModelGroup xsModelGroup = (XSModelGroup)xsComplexType.getParticle().getTerm();
        if (xsModelGroup != (extGroup = WSDLUtil.getExtensionGroup(xsComplexType))) {
            this.processChildGroups(xsModelGroup, extGroup, wrapRec, recs, types, xsModelGroup.getCompositor() == 2, fieldNames);
        }
    }

    private void processChildGroups(XSModelGroup xsModelGroup, XSModelGroup extGroup, Record wrapRec, LinkedHashMap<String, Part> recs, LinkedHashMap<XSTypeDefinition, Type> types, boolean isChoice, HashMap<String, String> fieldNames) {
        XSObjectList xsObjectList = xsModelGroup.getParticles();
        int i = 0;
        while (i < xsObjectList.getLength()) {
            XSParticle xsParticle = (XSParticle)xsObjectList.item(i);
            if (xsParticle.getTerm() instanceof XSModelGroup) {
                XSModelGroup group = (XSModelGroup)xsParticle.getTerm();
                if (group != extGroup) {
                    this.processChildGroups(group, null, wrapRec, recs, types, group.getCompositor() == 2, fieldNames);
                }
            } else if (xsParticle.getTerm() instanceof XSElementDeclaration) {
                String fieldName;
                XSElementDeclaration xsElement = (XSElementDeclaration)xsParticle.getTerm();
                String originalName = xsElement.getName();
                String xmlName = originalName.equals(fieldName = this.getFieldName(originalName, wrapRec.getName(), fieldNames)) ? null : originalName;
                Field field = new Field();
                field.setName(fieldName);
                Type type = this.processElement((XSObject)xsElement, wrapRec, recs, types);
                if (xsParticle.getMaxOccurs() > 1 || xsParticle.getMaxOccursUnbounded() || xsParticle.getMinOccurs() > 1) {
                    ArrayType aType = new ArrayType();
                    aType.setElementType(type);
                    type = aType;
                } else {
                    type.setNullable((xsParticle.getMinOccurs() == 0 || xsElement.getNillable() || isChoice) && !WSDLUtil.isSpecialArrayType(xsElement.getTypeDefinition()));
                }
                field.setType(type);
                if (xmlName != null || xsElement.getNamespace() != null && xsElement.getNamespace().length() > 0 || xsElement.getNillable()) {
                    Annotation annotation = new Annotation();
                    annotation.setName("XMLElement");
                    if (xmlName != null) {
                        annotation.addField("name", "\"" + xmlName + "\"");
                    }
                    if (xsElement.getNamespace() != null && xsElement.getNamespace().length() > 0) {
                        annotation.addField("namespace", "\"" + xsElement.getNamespace() + "\"");
                    }
                    if (xsElement.getNillable()) {
                        annotation.addField("nillable", "true");
                    }
                    field.addAnnotation(annotation);
                }
                wrapRec.addField(field);
            }
            ++i;
        }
    }

    private void processDerivedType(XSComplexTypeDefinition xsComplexType, Record wrapRec, LinkedHashMap<String, Part> recs, LinkedHashMap<XSTypeDefinition, Type> types) {
        XSTypeDefinition derivedType = xsComplexType.getBaseType();
        if (WSDLUtil.isExtensionType(xsComplexType)) {
            if (derivedType instanceof XSComplexTypeDefinition) {
                Embed embed = new Embed();
                Type type = this.processRecordType((XSComplexTypeDefinition)derivedType, recs, types, derivedType.getName(), derivedType.getName());
                embed.setType(type);
                wrapRec.addField(embed);
            } else {
                Type type = types.get(derivedType);
                type = type == null ? this.getPrimitiveType(null, (XSSimpleTypeDefinition)derivedType, derivedType.getName()) : (Type)type.clone();
                Field field = new Field();
                field.setName("egl_value");
                type.setNullable(true);
                field.setType(type);
                wrapRec.addField(field);
            }
        }
    }

    private Type getPrimitiveType(XSObject object, XSSimpleTypeDefinition simpleType, String fieldName) {
        Type type = new SimpleType();
        if (WSDLUtil.isString(simpleType)) {
            type.setName("string");
        } else if (WSDLUtil.isUnicode(simpleType)) {
            type.setName("unicode(" + String.valueOf(WSDLUtil.getItemLength(simpleType)) + ")");
        } else if (WSDLUtil.isLimitedString(simpleType)) {
            type.setName("string(" + String.valueOf(WSDLUtil.getItemLength(simpleType)) + ")");
        } else if (30 == simpleType.getBuiltInKind()) {
            String size = "(31)";
            if (WSDLUtil.getTotalDigits(simpleType) != -1) {
                size = "(" + WSDLUtil.getTotalDigits(simpleType) + ")";
            }
            type.setName("num" + size);
        } else if (4 == simpleType.getBuiltInKind()) {
            type = new DecimalType();
            int[] decimal = WSDLUtil.getDecimalDefinition(simpleType);
            if (decimal != null) {
                ((DecimalType)type).setLength(decimal[0]);
                ((DecimalType)type).setDecimals(decimal[1]);
            } else {
                ((DecimalType)type).setLength(31);
                ((DecimalType)type).setDecimals(0);
            }
        } else if (7 == simpleType.getBuiltInKind()) {
            String eglPattern = WSDLUtil.eglPattern(simpleType);
            if (eglPattern.length() > 0) {
                eglPattern = "(\"" + eglPattern + "\")";
            } else {
                this._msgHandler.addMessage(NewRecordWizardMessages.bind((String)NewRecordWizardMessages.PartsFromXMLSchemaUtil_missingDurationPatternMessage, (Object[])new String[]{object == null ? simpleType.getName() : object.getName()}));
            }
            type.setName("interval" + eglPattern);
        } else if (8 == simpleType.getBuiltInKind()) {
            String eglPattern = WSDLUtil.eglPattern(simpleType);
            if (eglPattern.length() > 0) {
                eglPattern = "(\"" + eglPattern + "\")";
            }
            type.setName("timestamp" + eglPattern);
        } else if (17 == simpleType.getBuiltInKind() && WSDLUtil.getItemLength(simpleType) > 0) {
            type.setName("hex(" + WSDLUtil.getItemLength(simpleType) * 2 + ")");
        } else {
            type.setName(WSDLUtil.getEGLPrimitiveBase(simpleType));
            if (44 == simpleType.getBuiltInKind() || 16 == simpleType.getBuiltInKind()) {
                ArrayType atype = new ArrayType();
                atype.setElementType(type);
                type = atype;
            }
        }
        return type;
    }

    private Type processRecordType(XSComplexTypeDefinition xsNode, LinkedHashMap<String, Part> recs, LinkedHashMap<XSTypeDefinition, Type> types, String recordName, String rootName) {
        String typeName = this.getTypeName(recordName);
        RecordType type = new RecordType();
        type.setName(typeName);
        String fn = typeName.toUpperCase().toLowerCase();
        Record rec = (Record)recs.get(fn);
        if (rec == null) {
            rec = new Record();
            rec.setName(typeName);
            recs.put(fn, rec);
            new PartsFromXMLSchemaUtil(this._msgHandler).processRecord(this.xsModel, xsNode, rec, recs, types);
            if (!typeName.equals(recordName) || xsNode.getNamespace() != null && xsNode.getNamespace().length() > 0) {
                Annotation annotation = new Annotation();
                annotation.setName("XMLRootElement");
                if (!typeName.equals(rootName)) {
                    annotation.addField("name", "\"" + rootName + "\"");
                }
                if (xsNode.getNamespace() != null && xsNode.getNamespace().length() > 0) {
                    annotation.addField("namespace", "\"" + xsNode.getNamespace() + "\"");
                }
                rec.addAnnotation(annotation);
            }
        }
        return type;
    }

    private void processRecord(XSModel model, XSComplexTypeDefinition xsTypeDef, Record wrapRec, LinkedHashMap<String, Part> recs, LinkedHashMap<XSTypeDefinition, Type> types) {
        this.xsModel = model;
        HashMap<String, String> fieldNames = this.getFieldNames(xsTypeDef, false);
        this.processChildAttributes(xsTypeDef, wrapRec, recs, types, fieldNames);
        this.processDerivedType(xsTypeDef, wrapRec, recs, types);
        this.processChildElements(xsTypeDef, wrapRec, recs, types, fieldNames);
    }

    private void processSimpleRecord(XSComplexTypeDefinition xsTypeDef, Record wrapRec, LinkedHashMap<String, Part> recs, LinkedHashMap<XSTypeDefinition, Type> types) {
        HashMap<String, String> fieldNames = this.getFieldNames(xsTypeDef, true);
        this.processChildAttributes(xsTypeDef, wrapRec, recs, types, fieldNames);
        if (WSDLUtil.isExtensionType(xsTypeDef)) {
            this.processDerivedType(xsTypeDef, wrapRec, recs, types);
        } else {
            Field field = new Field();
            field.setName("egl_value");
            SimpleType t = new SimpleType();
            t.setName("string");
            t.setNullable(true);
            field.setType(t);
            wrapRec.addField(field);
        }
    }

    private Type processSimpleRecordType(XSComplexTypeDefinition xsNode, LinkedHashMap<String, Part> recs, LinkedHashMap<XSTypeDefinition, Type> types, String fieldName) {
        String typeName = this.getTypeName(fieldName);
        RecordType type = new RecordType();
        type.setName(typeName);
        String fn = typeName.toUpperCase().toLowerCase();
        Record rec = (Record)recs.get(fn);
        if (rec == null) {
            rec = new Record();
            rec.setName(typeName);
            recs.put(fn, rec);
            Annotation annotation = new Annotation();
            annotation.setName("XMLValue");
            annotation.addField("kind", "XMLStructureKind.simpleContent");
            rec.addAnnotation(annotation);
            new PartsFromXMLSchemaUtil(this._msgHandler).processSimpleRecord(xsNode, rec, recs, types);
        }
        return type;
    }
}

