/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.wizards;

import java.io.StringReader;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.record.NewRecordWizardMessages;
import org.eclipse.edt.ide.ui.internal.record.conversion.IMessageHandler;
import org.eclipse.edt.ide.ui.internal.record.conversion.RecordSource;
import org.eclipse.edt.ide.ui.internal.record.conversion.xmlschema.XMLSchemaConversion;
import org.eclipse.edt.ide.ui.internal.record.wizards.AbstractRecordFromStringInputPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;

public class RecordFromXMLSchemaPage
extends AbstractRecordFromStringInputPage
implements DOMErrorHandler {
    public RecordFromXMLSchemaPage(ISelection selection) {
        super(selection);
        this.setTitle(NewRecordWizardMessages.RecordFromXMLSchemaPage_title);
        this.setDescription(NewRecordWizardMessages.RecordFromXMLSchemaPage_description);
    }

    @Override
    protected String[] getValidInputFileExtensions() {
        return new String[]{"*.xsd", "*"};
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IUIHelpConstants.EGL_NEW_RECORD_FROM_SCHEMA_PAGE);
    }

    @Override
    protected void validatePage() {
        super.validatePage();
        if (this.isPageComplete() && this.createFromStringButton.getSelection() && this.stringText.getText().trim().length() > 0) {
            try {
                DOMImplementationRegistry domRegistry = DOMImplementationRegistry.newInstance();
                XSImplementation xsImpl = (XSImplementation)domRegistry.getDOMImplementation("XS-Loader");
                XSLoader xsLoader = xsImpl.createXSLoader(null);
                xsLoader.getConfig().setParameter("error-handler", this);
                new StringReader(this.stringText.getText().trim());
                xsLoader.load((LSInput)new XMLSchemaConversion.GenericLSInput(this.stringText.getText().trim()));
            }
            catch (Throwable ex) {
                this.error(ex.getMessage());
            }
        }
    }

    @Override
    public boolean handleError(DOMError error) {
        StringBuffer buffer = new StringBuffer();
        if (error.getLocation().getUri() != null) {
            buffer.append("[" + error.getLocation().getUri() + "] ");
        }
        if (error.getLocation().getLineNumber() != -1) {
            buffer.append("[" + error.getLocation().getLineNumber() + "," + error.getLocation().getColumnNumber() + "] ");
        }
        if (buffer.length() > 0) {
            buffer.append(error.getMessage());
            if (error.getSeverity() == 3) {
                this.error(buffer.toString());
            } else {
                ((IMessageHandler)this.getWizard()).addMessage(buffer.toString());
            }
        }
        return error.getSeverity() != 3;
    }

    @Override
    public Object getInput() {
        String input = null;
        int source = 1;
        if (this.createFromStringButton.getSelection()) {
            input = this.stringText.getText();
            source = 1;
        } else if (this.createFromUrlButton.getSelection() || this.createFromFileButton.getSelection() && this.fileText.getText().trim().length() != 0) {
            if (this.createFromUrlButton.getSelection()) {
                input = this.urlText.getText();
                source = 3;
            } else {
                input = this.fileText.getText();
                source = 2;
            }
        }
        RecordSource recordSource = new RecordSource(input, source);
        return recordSource;
    }
}

