/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.deployment.Deployment;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.Parameter;
import org.eclipse.edt.ide.ui.internal.deployment.Parameters;
import org.eclipse.edt.ide.ui.internal.deployment.RUIApplication;
import org.eclipse.edt.ide.ui.internal.deployment.RUIHandler;
import org.eclipse.edt.ide.ui.internal.deployment.Service;
import org.eclipse.edt.ide.ui.internal.deployment.Services;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.refactoring.DeleteProcessor;
import org.eclipse.edt.ide.ui.internal.refactoring.DeleteRefactoringWizard;
import org.eclipse.edt.ide.ui.internal.refactoring.ListDialog;
import org.eclipse.edt.ide.ui.internal.refactoring.rename.RenameEGLFileProcessor;
import org.eclipse.edt.ide.ui.internal.refactoring.rename.RenameEGLFileWizard;
import org.eclipse.edt.ide.ui.internal.refactoring.rename.RenamePartProcessor;
import org.eclipse.edt.ide.ui.internal.refactoring.rename.RenamePartWizard;
import org.eclipse.edt.ide.ui.internal.refactoring.rename.RenameRefactoring;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.CreateTargetQueries;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgPolicy;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.MoveProcessor;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.MoveRefactoring;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReorgQueries;
import org.eclipse.edt.ide.ui.internal.util.CoreUtility;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class RefactoringExecutionStarter {
    public static void startDeleteRefactoring(Object[] elements, Shell shell) throws CoreException {
        DeleteProcessor processor = new DeleteProcessor(elements);
        DeleteRefactoring ref = new DeleteRefactoring((org.eclipse.ltk.core.refactoring.participants.DeleteProcessor)processor);
        if (shell != null) {
            DeleteRefactoringWizard wizard = new DeleteRefactoringWizard(ref, elements);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            try {
                String titleForFailedChecks;
                int status;
                IEGLFile eglFile = null;
                List<IFile> eglddFiles = null;
                String[] serviceQualifiedNames = null;
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof IEGLFile) {
                        eglFile = (IEGLFile)element;
                        break;
                    }
                    ++n2;
                }
                if (eglFile != null) {
                    eglddFiles = CoreUtility.getExistingEGLDDFileHandle(eglFile);
                    Map<String, String> serviceQualifiedMap = RefactoringExecutionStarter.getServiceQualifiedName(elements);
                    if (serviceQualifiedMap.values() != null) {
                        serviceQualifiedNames = new String[serviceQualifiedMap.values().size()];
                        serviceQualifiedNames = serviceQualifiedMap.values().toArray(serviceQualifiedNames);
                    }
                }
                if ((status = op.run(shell, titleForFailedChecks = "")) == 0 && serviceQualifiedNames != null && serviceQualifiedNames.length > 0) {
                    RefactoringExecutionStarter.handleDDEditorResourceRemoval(eglddFiles, serviceQualifiedNames);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            CreateChangeOperation create = new CreateChangeOperation(new CheckConditionsOperation((Refactoring)ref, 6), 4);
            PerformChangeOperation perform = new PerformChangeOperation(create);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)perform, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void startRenameRefactoring(IPart part, Shell shell) throws CoreException {
        if (!RefactoringExecutionStarter.saveEditors(shell)) {
            return;
        }
        RenamePartProcessor processor = new RenamePartProcessor(part);
        RenameRefactoring ref = new RenameRefactoring(processor);
        RenamePartWizard wizard = new RenamePartWizard((Refactoring)ref);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            op.run(shell, UINlsStrings.RenameSupport_dialog_title);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void startRenameRefactoring(IEGLFile eglFile, Shell shell) throws CoreException {
        if (!RefactoringExecutionStarter.saveEditors(shell)) {
            return;
        }
        RenameEGLFileProcessor processor = new RenameEGLFileProcessor(eglFile);
        RenameRefactoring ref = new RenameRefactoring(processor);
        RenameEGLFileWizard wizard = new RenameEGLFileWizard((Refactoring)ref);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        List<IFile> eglddFiles = CoreUtility.getExistingEGLDDFileHandle(eglFile);
        Object[] elements = new Object[]{eglFile};
        Map<String, String> serviceQualifiedMap = RefactoringExecutionStarter.getServiceQualifiedName(elements);
        try {
            int status = op.run(shell, UINlsStrings.RenameSupport_dialog_title);
            if (status == 0) {
                String newServiceName = processor.getNewElementName();
                RefactoringExecutionStarter.handleDDEditorResourceRename(eglddFiles, serviceQualifiedMap, newServiceName);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void startMoveRefactoring(IResource[] resources, IEGLElement[] elements, Shell shell) throws EGLModelException {
        if (!RefactoringExecutionStarter.saveEditors(shell)) {
            return;
        }
        IReorgPolicy.IEGLMovePolicy policy = ReorgPolicyFactory.createMovePolicy(resources, elements);
        if (policy.canEnable()) {
            MoveProcessor processor = new MoveProcessor(policy);
            MoveRefactoring refactoring = new MoveRefactoring(processor);
            ReorgMoveWizard wizard = new ReorgMoveWizard(refactoring);
            processor.setCreateTargetQueries(new CreateTargetQueries((Wizard)wizard));
            processor.setReorgQueries(new ReorgQueries((Wizard)wizard));
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            try {
                op.run(shell, UINlsStrings.MoveSupport_dialog_title);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private RefactoringExecutionStarter() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveEditors(Shell shell) {
        IEditorPart[] dirtyEditors = RefactoringExecutionStarter.getDirtyEditors();
        if (dirtyEditors.length == 0) {
            return true;
        }
        if (!RefactoringExecutionStarter.saveAllDirtyEditors(shell, dirtyEditors)) {
            return false;
        }
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = workspace.getDescription();
            boolean autoBuild = description.isAutoBuilding();
            description.setAutoBuilding(false);
            workspace.setDescription(description);
            try {
                if (!EDTUIPlugin.getActiveWorkbenchWindow().getWorkbench().saveAllEditors(false)) {
                    return false;
                }
            }
            finally {
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
            }
        }
        catch (CoreException e) {
            EGLLogger.log(RefactoringExecutionStarter.class, RefactoringExecutionStarter.class.getName(), e);
            return false;
        }
    }

    private static boolean saveAllDirtyEditors(Shell shell, IEditorPart[] dirtyEditors) {
        ListDialog dialog = new ListDialog(shell);
        dialog.setTitle(UINlsStrings.RefactoringStarter_save_all_resources);
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider(RefactoringExecutionStarter.createDialogLabelProvider());
        dialog.setMessage(UINlsStrings.RefactoringStarter_must_save);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setInput(Arrays.asList(dirtyEditors));
        return dialog.open() == 0;
    }

    private static ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }

    private static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    private static void handleDDEditorResourceRemoval(List<IFile> eglddFiles, String[] serviceQualifiedNames) throws EGLModelException {
        boolean isResourceFound = false;
        for (IFile eglddFile : eglddFiles) {
            if (eglddFile == null || !eglddFile.exists()) continue;
            EGLDeploymentRoot deploymentRoot = null;
            try {
                deploymentRoot = EGLDDRootHelper.getEGLDDFileSharedWorkingModel(eglddFile, false);
                Deployment deployment = deploymentRoot.getDeployment();
                Services services = deployment.getServices();
                RUIApplication ruiApp = deployment.getRuiapplication();
                isResourceFound = RefactoringExecutionStarter.removeDDServices(services, serviceQualifiedNames);
                if (ruiApp != null) {
                    if (isResourceFound) {
                        RefactoringExecutionStarter.removeDDRuiHandlers(ruiApp, serviceQualifiedNames);
                    } else {
                        isResourceFound = RefactoringExecutionStarter.removeDDRuiHandlers(ruiApp, serviceQualifiedNames);
                    }
                }
                if (!isResourceFound || EGLDDRootHelper.isWorkingModelSharedByUserClients(eglddFile)) continue;
                EGLDDRootHelper.saveEGLDDFile(eglddFile, deploymentRoot);
            }
            finally {
                if (deploymentRoot != null) {
                    EGLDDRootHelper.releaseSharedWorkingModel(eglddFile, false);
                }
            }
        }
    }

    private static boolean removeDDServices(Services services, String[] serviceQualifiedNames) {
        boolean isResourceFound = false;
        if (services != null) {
            int i = 0;
            while (i < serviceQualifiedNames.length) {
                Service removedService = null;
                for (Service restService : services.getService()) {
                    if (restService.getImplementation() == null || !restService.getImplementation().equals(serviceQualifiedNames[i])) continue;
                    removedService = restService;
                    isResourceFound = true;
                    break;
                }
                if (removedService != null) {
                    services.getService().remove(removedService);
                }
                ++i;
            }
        }
        return isResourceFound;
    }

    private static boolean removeDDRuiHandlers(RUIApplication ruiApp, String[] serviceQualifiedNames) {
        boolean isResourceFound = false;
        EList ruiHandlers = ruiApp.getRuihandler();
        if (ruiHandlers != null) {
            int i = 0;
            while (i < serviceQualifiedNames.length) {
                RUIHandler removedHandler = null;
                for (RUIHandler handler : ruiHandlers) {
                    if (handler.getImplementation() == null || !handler.getImplementation().equals(serviceQualifiedNames[i])) continue;
                    removedHandler = handler;
                    isResourceFound = true;
                    break;
                }
                if (removedHandler != null) {
                    ruiHandlers.remove(removedHandler);
                }
                ++i;
            }
        }
        return isResourceFound;
    }

    private static void handleDDEditorResourceRename(List<IFile> eglddFiles, Map<String, String> serviceQualifiedNames, String newResourceName) throws EGLModelException {
        boolean isResourceFound = false;
        for (IFile eglddFile : eglddFiles) {
            if (eglddFile != null && eglddFile.exists()) {
                EGLDeploymentRoot deploymentRoot = null;
                try {
                    deploymentRoot = EGLDDRootHelper.getEGLDDFileSharedWorkingModel(eglddFile, false);
                    Deployment deployment = deploymentRoot.getDeployment();
                    Services services = deployment.getServices();
                    RUIApplication ruiApp = deployment.getRuiapplication();
                    String oldResourceImpl = null;
                    Iterator<Map.Entry<String, String>> iterator = serviceQualifiedNames.entrySet().iterator();
                    if (iterator.hasNext()) {
                        Map.Entry<String, String> entry = iterator.next();
                        oldResourceImpl = entry.getValue();
                    }
                    isResourceFound = RefactoringExecutionStarter.renameDDServices(services, oldResourceImpl, newResourceName);
                    if (ruiApp != null) {
                        if (isResourceFound) {
                            RefactoringExecutionStarter.renameDDHandlers(ruiApp, oldResourceImpl, newResourceName);
                        } else {
                            isResourceFound = RefactoringExecutionStarter.renameDDHandlers(ruiApp, oldResourceImpl, newResourceName);
                        }
                    }
                    if (isResourceFound && !EGLDDRootHelper.isWorkingModelSharedByUserClients(eglddFile)) {
                        EGLDDRootHelper.saveEGLDDFile(eglddFile, deploymentRoot);
                    }
                }
                finally {
                    if (deploymentRoot != null) {
                        EGLDDRootHelper.releaseSharedWorkingModel(eglddFile, false);
                    }
                }
            }
            if (isResourceFound) break;
        }
    }

    private static boolean renameDDServices(Services services, String oldServiceImpl, String newServiceName) {
        boolean isResourceFound = false;
        if (services != null) {
            for (Service restService : services.getService()) {
                String serviceImpl = restService.getImplementation();
                if (serviceImpl == null || !serviceImpl.equals(oldServiceImpl)) continue;
                isResourceFound = true;
                Parameters parameters = restService.getParameters();
                EList paraValues = parameters.getParameter();
                String uriFragment = "uriFragment";
                for (Parameter item : paraValues) {
                    if (!uriFragment.equals(item.getName())) continue;
                    item.setValue(newServiceName);
                    break;
                }
                int lastPackageSeparatorPos = serviceImpl.lastIndexOf(".");
                if (lastPackageSeparatorPos == -1) {
                    restService.setImplementation(newServiceName);
                    break;
                }
                restService.setImplementation(String.valueOf(serviceImpl.substring(0, lastPackageSeparatorPos)) + "." + newServiceName);
                break;
            }
        }
        return isResourceFound;
    }

    private static boolean renameDDHandlers(RUIApplication ruiApp, String oldHandlerImpl, String newHandlerName) {
        boolean isResourceFound = false;
        EList ruiHandlers = ruiApp.getRuihandler();
        if (ruiHandlers != null) {
            for (RUIHandler handler : ruiHandlers) {
                String handlerImpl = handler.getImplementation();
                if (handlerImpl == null || !handlerImpl.equals(oldHandlerImpl)) continue;
                isResourceFound = true;
                Parameters parameters = handler.getParameters();
                EList paraValues = parameters.getParameter();
                String htmlFileName = "html_file_name";
                for (Parameter item : paraValues) {
                    if (!htmlFileName.equals(item.getName())) continue;
                    item.setValue(newHandlerName);
                    break;
                }
                int lastPackageSeparatorPos = handlerImpl.lastIndexOf(".");
                if (lastPackageSeparatorPos == -1) {
                    handler.setImplementation(newHandlerName);
                    break;
                }
                handler.setImplementation(String.valueOf(handlerImpl.substring(0, lastPackageSeparatorPos)) + "." + newHandlerName);
                break;
            }
        }
        return isResourceFound;
    }

    private static Map<String, String> getServiceQualifiedName(Object[] removedFiles) {
        HashMap<String, String> qualifiedNames = new HashMap<String, String>();
        int i = 0;
        while (i < removedFiles.length) {
            if (removedFiles[i] instanceof IEGLFile) {
                IEGLFile eglFile = (IEGLFile)removedFiles[i];
                String packageName = eglFile.getParent().getElementName();
                String fileName = eglFile.getElementName();
                if (Util.isEGLFileName((String)fileName)) {
                    fileName = fileName.substring(0, fileName.length() - Util.SUFFIX_EGL.length);
                    if (packageName == null || packageName.length() == 0) {
                        qualifiedNames.put(fileName, fileName);
                    } else {
                        qualifiedNames.put(fileName, String.valueOf(packageName) + '.' + fileName);
                    }
                }
            }
            ++i;
        }
        return qualifiedNames;
    }
}

