/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IImportDeclaration;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.ISourceRange;
import org.eclipse.edt.ide.core.model.ISourceReference;
import org.eclipse.edt.ide.core.search.IEGLSearchResultCollector;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.RefactoringScopeFactory;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.TextChangeCompatibility;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ImportManager;
import org.eclipse.edt.ide.ui.internal.refactoring.util.TextChangeManager;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class MoveReferenceUpdater {
    TextChangeManager manager;
    IProgressMonitor pm;
    IPackageFragment newPackage;
    ImportManager importManager;
    HashMap allPartsMap;

    public MoveReferenceUpdater(TextChangeManager manager, IProgressMonitor pm, IPackageFragment newPackage, IEGLFile[] files) {
        this.manager = manager;
        this.pm = pm;
        this.newPackage = newPackage;
        this.importManager = new ImportManager(newPackage);
        this.setupMap(files);
    }

    public MoveReferenceUpdater(TextChangeManager manager, IProgressMonitor pm, IPackageFragment newPackage, IPart[] parts) {
        this.manager = manager;
        this.pm = pm;
        this.newPackage = newPackage;
        this.importManager = new ImportManager(newPackage);
        this.setupMap(parts);
    }

    private void setupMap(IEGLFile[] files) {
        this.allPartsMap = new HashMap();
        int i = 0;
        while (i < files.length) {
            try {
                this.allPartsMap.put(files[i], files[i].getParts());
            }
            catch (EGLModelException e) {
                e.printStackTrace();
                EDTUIPlugin.log(e);
            }
            ++i;
        }
    }

    private void setupMap(IPart[] parts) {
        List list;
        HashMap<IEGLFile, ArrayList<IPart>> tempMap = new HashMap<IEGLFile, ArrayList<IPart>>();
        int i = 0;
        while (i < parts.length) {
            IEGLFile file = parts[i].getEGLFile();
            list = (ArrayList<IPart>)tempMap.get(file);
            if (list == null) {
                list = new ArrayList<IPart>();
                tempMap.put(file, (ArrayList<IPart>)list);
            }
            list.add(parts[i]);
            ++i;
        }
        this.allPartsMap = new HashMap();
        for (Object key : tempMap.keySet()) {
            list = (List)tempMap.get(key);
            IPart[] arr = list.toArray(new IPart[list.size()]);
            this.allPartsMap.put(key, arr);
        }
    }

    public void run() {
        for (IPart[] parts : this.allPartsMap.values()) {
            this.processParts(parts);
        }
        this.importManager.createChanges(this.manager);
    }

    private void processParts(IPart[] parts) {
        int i = 0;
        while (i < parts.length) {
            try {
                this.processPart(parts[i]);
            }
            catch (EGLModelException e) {
                e.printStackTrace();
                EDTUIPlugin.log(e);
            }
            ++i;
        }
    }

    private void processPart(IPart part) throws EGLModelException {
        IPackageFragment oldPkg = part.getPackageFragment();
        if (oldPkg == this.newPackage) {
            return;
        }
        HashSet addImportFiles = new HashSet();
        HashSet removeImportFiles = new HashSet();
        this.processReferences(part, addImportFiles, removeImportFiles);
        this.addImports(part, addImportFiles);
    }

    private void addImports(IPart part, HashSet addImportFiles) {
        for (IEGLFile file : addImportFiles) {
            if (file == null) continue;
            ImportManager.ImportInfo info = this.importManager.getInfoFor(file);
            info.addImportForPart(part.getElementName());
        }
    }

    private void processReferences(final IPart part, final HashSet addImportFiles, HashSet removeImportFiles) throws EGLModelException {
        final HashSet filesWithSingleTypeImports = new HashSet();
        String elementName = part.getPackageFragment().getElementName();
        String searchString = elementName.equals("") ? part.getElementName() : new String(CharOperation.concat((char[])elementName.toCharArray(), (char[])part.getElementName().toCharArray(), (char)'.'));
        new SearchEngine().search(ResourcesPlugin.getWorkspace(), SearchEngine.createSearchPattern((String)searchString, (int)this.getSearchFor(part), (int)1, (boolean)false), RefactoringScopeFactory.create((IEGLElement)part), true, true, new IEGLSearchResultCollector(){

            public void aboutToStart() {
            }

            public void accept(IResource resource, int start, int end, IEGLElement enclosingElement, int accuracy) throws CoreException {
                IEGLFile enclosingFile;
                if (1 == accuracy) {
                    return;
                }
                IPackageFragment pkg = MoveReferenceUpdater.this.getPackage(enclosingElement);
                if (enclosingElement instanceof IImportDeclaration) {
                    IEGLFile enclosingFile2 = MoveReferenceUpdater.this.getFile(enclosingElement);
                    if (this.samePackage(pkg, MoveReferenceUpdater.this.newPackage, enclosingElement)) {
                        ISourceReference sourceRef = (ISourceReference)enclosingElement;
                        ISourceRange sourceRange = sourceRef.getSourceRange();
                        TextChangeCompatibility.addTextEdit(MoveReferenceUpdater.this.manager.get(enclosingFile2), UINlsStrings.RenamePartRefactoring_update_reference, (TextEdit)new DeleteEdit(sourceRange.getOffset(), sourceRange.getLength()));
                        return;
                    }
                    IEGLFile file = MoveReferenceUpdater.this.getFile(enclosingElement);
                    filesWithSingleTypeImports.add(file);
                    String newPartName = MoveReferenceUpdater.this.newPackage.getElementName();
                    if (newPartName.length() > 0) {
                        newPartName = String.valueOf(newPartName) + ".";
                    }
                    newPartName = String.valueOf(newPartName) + part.getElementName();
                    TextChangeCompatibility.addTextEdit(MoveReferenceUpdater.this.manager.get(enclosingFile2), UINlsStrings.RenamePartRefactoring_update_reference, (TextEdit)new ReplaceEdit(start, end - start, newPartName));
                    return;
                }
                if (end - start == part.getElementName().length()) {
                    if (!this.samePackage(pkg, MoveReferenceUpdater.this.newPackage, enclosingElement)) {
                        enclosingFile = MoveReferenceUpdater.this.getFile(enclosingElement);
                        addImportFiles.add(enclosingFile);
                    }
                } else if (this.samePackage(pkg, MoveReferenceUpdater.this.newPackage, enclosingElement)) {
                    enclosingFile = MoveReferenceUpdater.this.getFile(enclosingElement);
                    TextChangeCompatibility.addTextEdit(MoveReferenceUpdater.this.manager.get(enclosingFile), UINlsStrings.RenamePartRefactoring_update_reference, (TextEdit)new ReplaceEdit(start, end - start, part.getElementName()));
                } else {
                    String newPartName = MoveReferenceUpdater.this.newPackage.getElementName();
                    IEGLFile enclosingFile3 = MoveReferenceUpdater.this.getFile(enclosingElement);
                    if (newPartName.length() > 0) {
                        newPartName = String.valueOf(newPartName) + ".";
                    } else {
                        addImportFiles.add(enclosingFile3);
                    }
                    newPartName = String.valueOf(newPartName) + part.getElementName();
                    TextChangeCompatibility.addTextEdit(MoveReferenceUpdater.this.manager.get(enclosingFile3), UINlsStrings.RenamePartRefactoring_update_reference, (TextEdit)new ReplaceEdit(start, end - start, newPartName));
                }
                for (IEGLFile file : filesWithSingleTypeImports) {
                    if (!addImportFiles.contains(file)) continue;
                    addImportFiles.remove(file);
                }
            }

            public void done() {
            }

            public IProgressMonitor getProgressMonitor() {
                return MoveReferenceUpdater.this.pm;
            }

            private boolean samePackage(IPackageFragment pkg1, IPackageFragment pkg2, IEGLElement enclosingElement) {
                if (pkg1 == pkg2) {
                    return true;
                }
                if (pkg1 == null || pkg2 == null) {
                    return false;
                }
                if (pkg1.equals(pkg2)) {
                    return true;
                }
                IPart part2 = MoveReferenceUpdater.this.getPart(enclosingElement);
                if (part2 == null) {
                    return false;
                }
                IEGLFile file = part2.getEGLFile();
                for (IEGLFile key : MoveReferenceUpdater.this.allPartsMap.keySet()) {
                    if (!file.equals(key)) continue;
                    IPart[] parts = (IPart[])MoveReferenceUpdater.this.allPartsMap.get(key);
                    int j = 0;
                    while (j < parts.length) {
                        if (parts[j].equals(part2)) {
                            return true;
                        }
                        ++j;
                    }
                    return false;
                }
                return false;
            }

            public void accept(IEGLElement element, int start, int end, IResource resource, int accuracy) throws CoreException {
            }
        });
    }

    private int getSearchFor(IPart part) {
        int result = 0;
        if (part instanceof SourcePart) {
            SourcePart sPart = (SourcePart)part;
            if (sPart.isDataItem()) {
                result = 5;
            } else if (sPart.isDataTable()) {
                result = 3;
            } else if (sPart.isDelegate()) {
                result = 15;
            } else if (sPart.isExternalType()) {
                result = 16;
            } else if (sPart.isFormGroup()) {
                result = 7;
            } else if (sPart.isHandler()) {
                result = 12;
            } else if (sPart.isInterface()) {
                result = 14;
            } else if (sPart.isLibrary()) {
                result = 9;
            } else if (sPart.isProgram()) {
                result = 1;
            } else if (sPart.isRecord()) {
                result = 4;
            } else if (sPart.isService()) {
                result = 13;
            } else if (sPart.isFunction()) {
                result = 10;
            } else if (sPart.isForm()) {
                result = 6;
            }
        }
        return result;
    }

    IPackageFragment getPackage(IEGLElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IPackageFragment) {
            return (IPackageFragment)element;
        }
        return this.getPackage(element.getParent());
    }

    IEGLFile getFile(IEGLElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IEGLFile) {
            return (IEGLFile)element;
        }
        return this.getFile(element.getParent());
    }

    IPart getPart(IEGLElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IPart) {
            return (IPart)element;
        }
        return this.getPart(element.getParent());
    }
}

