/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.Checks;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.INewNameQueries;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.INewNameQuery;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Shell;

public class NewNameQueries
implements INewNameQueries {
    private static final String INVALID_NAME_NO_MESSAGE = "";
    private final Wizard fWizard;
    private final Shell fShell;

    public NewNameQueries() {
        this.fShell = null;
        this.fWizard = null;
    }

    public NewNameQueries(Wizard wizard) {
        this.fWizard = wizard;
        this.fShell = null;
    }

    public NewNameQueries(Shell shell) {
        this.fShell = shell;
        this.fWizard = null;
    }

    private Shell getShell() {
        Assert.isTrue((this.fWizard == null || this.fShell == null ? 1 : 0) != 0);
        if (this.fWizard != null) {
            return this.fWizard.getContainer().getShell();
        }
        if (this.fShell != null) {
            return this.fShell;
        }
        return EDTUIPlugin.getActiveWorkbenchShell();
    }

    @Override
    public INewNameQuery createNewEGLFileNameQuery(IEGLFile cu, String initialSuggestedName) {
        Object[] keys = new String[]{cu.getElementName()};
        String message = MessageFormat.format((String)NewWizardMessages.CopyFilesAndFoldersOperation_inputDialogMessage, (Object[])keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createCompilationUnitNameValidator(cu), message, initialSuggestedName, this.getShell());
    }

    @Override
    public INewNameQuery createNewResourceNameQuery(IResource res, String initialSuggestedName) {
        Object[] keys = new String[]{res.getName()};
        String message = MessageFormat.format((String)NewWizardMessages.CopyFilesAndFoldersOperation_inputDialogMessage, (Object[])keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createResourceNameValidator(res), message, initialSuggestedName, this.getShell());
    }

    @Override
    public INewNameQuery createNewPackageNameQuery(IPackageFragment pack, String initialSuggestedName) {
        Object[] keys = new String[]{pack.getElementName()};
        String message = MessageFormat.format((String)NewWizardMessages.CopyFilesAndFoldersOperation_inputDialogMessage, (Object[])keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createPackageNameValidator(pack), message, initialSuggestedName, this.getShell());
    }

    @Override
    public INewNameQuery createNewPackageFragmentRootNameQuery(IPackageFragmentRoot root, String initialSuggestedName) {
        Object[] keys = new String[]{root.getElementName()};
        String message = MessageFormat.format((String)NewWizardMessages.CopyFilesAndFoldersOperation_inputDialogMessage, (Object[])keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createPackageFragmentRootNameValidator(root), message, initialSuggestedName, this.getShell());
    }

    @Override
    public INewNameQuery createNullQuery() {
        return this.createStaticQuery(null);
    }

    @Override
    public INewNameQuery createStaticQuery(final String newName) {
        return new INewNameQuery(){

            @Override
            public String getNewName() {
                return newName;
            }
        };
    }

    private static INewNameQuery createStaticQuery(final IInputValidator validator, final String message, final String initial, final Shell shell) {
        return new INewNameQuery(){

            @Override
            public String getNewName() {
                InputDialog dialog = new InputDialog(shell, UINlsStrings.ReorgQueries_nameConflictMessage, message, initial, validator);
                if (dialog.open() == 1) {
                    throw new OperationCanceledException();
                }
                return dialog.getValue();
            }
        };
    }

    private static IInputValidator createResourceNameValidator(final IResource res) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(newText) || res.getParent() == null) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                if (res.getParent().findMember(newText) != null) {
                    return UINlsStrings.ReorgQueries_resourceWithThisNameAlreadyExists;
                }
                if (!res.getParent().getFullPath().isValidSegment(newText)) {
                    return UINlsStrings.ReorgQueries_invalidNameMessage;
                }
                IStatus status = res.getParent().getWorkspace().validateName(newText, res.getType());
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                if (res.getName().equalsIgnoreCase(newText)) {
                    return UINlsStrings.ReorgQueries_resourceExistsWithDifferentCaseMassage;
                }
                return null;
            }
        };
        return validator;
    }

    private static IInputValidator createCompilationUnitNameValidator(final IEGLFile cu) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(newText)) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                String newCuName = NewNameQueries.getRenamedCUName(cu, newText);
                IStatus status = EGLConventions.validateEGLFileName((String)newCuName);
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                RefactoringStatus refStatus = Checks.checkFileNewName(cu, newText);
                if (refStatus.hasFatalError()) {
                    return refStatus.getMessageMatchingSeverity(4);
                }
                return null;
            }
        };
        return validator;
    }

    private static String getRenamedCUName(IEGLFile cu, String newMainName) {
        String oldName = cu.getElementName();
        int i = oldName.lastIndexOf(46);
        if (i != -1) {
            return String.valueOf(newMainName) + oldName.substring(i);
        }
        return newMainName;
    }

    private static IInputValidator createPackageFragmentRootNameValidator(IPackageFragmentRoot root) {
        return new IInputValidator(root){
            IInputValidator resourceNameValidator;
            {
                this.resourceNameValidator = NewNameQueries.createResourceNameValidator(iPackageFragmentRoot.getResource());
            }

            public String isValid(String newText) {
                return this.resourceNameValidator.isValid(newText);
            }
        };
    }

    private static IInputValidator createPackageNameValidator(final IPackageFragment pack) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(newText)) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                IStatus status = EGLConventions.validatePackageName((String)newText);
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                if (pack.getElementName().equalsIgnoreCase(newText)) {
                    return NewWizardMessages.ValidatePageErrorFileNameExistsDiffCase;
                }
                return null;
            }
        };
        return validator;
    }
}

