/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.dialogs.EGLPartSelectionDialog;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizard;
import org.eclipse.edt.ide.ui.internal.wizards.EGLFileWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.BindingBaseConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLDDBindingConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EGLDDBindingWizardPage
extends EGLFileWizardPage {
    public static final String WIZPAGENAME_EGLDDBindingWizardPage = "WIZPAGENAME_EGLDDBindingWizardPage";
    protected int nColumns = 3;
    private Button fWSBindingButton;
    private Button fEGLBindingButton;
    private Button fNativeBindingButton;
    private Button fRestBindingButton;
    private Button fSQLDatabaseBindingButton;
    protected StringDialogField fNameField;
    protected StatusInfo fNameStatus;

    public EGLDDBindingWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.EGLDDBindingWizPageTitle);
        this.setDescription(NewWizardMessages.EGLDDBindingWizPageDescription);
        this.fNameStatus = new StatusInfo();
    }

    private EGLDDBindingConfiguration getConfiguration() {
        return (EGLDDBindingConfiguration)((EGLPartWizard)this.getWizard()).getConfiguration(this.getName());
    }

    protected EGLDDBindingConfiguration getEGLDDBindingConfiguration() {
        return (EGLDDBindingConfiguration)((EGLPartWizard)this.getWizard()).getConfiguration(WIZPAGENAME_EGLDDBindingWizardPage);
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGLDDWIZ_ADDBINDING);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createChooseBindingTypeControl(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
    }

    protected void createChooseBindingTypeControl(Composite parent) {
        Group grp = new Group(parent, 0);
        grp.setText(NewWizardMessages.ModuleChooseBindingTypes);
        GridLayout groupLayout = new GridLayout();
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        grp.setLayout((Layout)groupLayout);
        grp.setLayoutData((Object)gd);
        this.fRestBindingButton = this.createBindingRadioButton(grp, NewWizardMessages.RestBindingBtnLabel, 1);
        this.fSQLDatabaseBindingButton = this.createBindingRadioButton(grp, NewWizardMessages.SQLDatabaseBindingBtnLabel, 4);
        this.selectBindingTypeButton(this.getConfiguration().getBindingType());
    }

    private void selectBindingTypeButton(int bindingType) {
        switch (bindingType) {
            case 0: {
                this.fWSBindingButton.setSelection(true);
                break;
            }
            case 1: {
                this.fRestBindingButton.setSelection(true);
                break;
            }
            case 2: {
                this.fEGLBindingButton.setSelection(true);
                break;
            }
            case 3: {
                this.fNativeBindingButton.setSelection(true);
                break;
            }
            case 4: {
                this.fSQLDatabaseBindingButton.setSelection(true);
            }
        }
    }

    private Button createBindingRadioButton(Group grp, String btnText, final int bindingType) {
        Button btn = new Button((Composite)grp, 16);
        btn.setText(btnText);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    EGLDDBindingWizardPage.this.HandleBindingTypeChanged(bindingType);
                }
            }
        });
        return btn;
    }

    protected void HandleBindingTypeChanged(int bindingType) {
        this.getConfiguration().setBindingType(bindingType);
        this.updateWizardDialogButtons((IWizardPage)this);
    }

    protected void updateWizardDialogButtons(IWizardPage currWizPage) {
        IWizard wiz = this.getWizard();
        if (wiz instanceof EGLDDBindingWizard) {
            ((EGLDDBindingWizard)wiz).updatePagePathAndNextPage(currWizPage);
        }
        IWizardContainer wizDlg = this.getWizard().getContainer();
        wizDlg.updateButtons();
    }

    protected void createComponentNameControl(Composite parent, String labelName, BindingBaseConfiguration esConfig) {
        this.createComponentNameNoBrowseControl(parent, labelName, esConfig);
    }

    protected void createComponentNameNoBrowseControl(Composite parent, String labelName, final BindingBaseConfiguration esConfig) {
        this.fNameField = new StringDialogField();
        this.fNameField.setLabelText(labelName);
        this.fNameField.setText(esConfig.getBindingName());
        this.fNameField.setDialogFieldListener(new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                EGLDDBindingWizardPage.this.HandleBindingNameChanged(esConfig);
            }
        });
        this.fNameField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fNameField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
    }

    protected void validateBindingName(StatusInfo statusinfo) {
        if (this.fNameField != null) {
            String currname = this.fNameField.getText();
            if (currname == null || currname.trim().length() == 0) {
                statusinfo.setError(NewWizardMessages.EGLDDBindingWizPageValidationSetBindingName);
            } else {
                Binding binding = EGLDDRootHelper.getBindingByName(this.getEGLDDBindingConfiguration().getDeploymentRoot(), currname);
                if (binding != null) {
                    statusinfo.setError(NewWizardMessages.bind((String)NewWizardMessages.EGLDDBindingWizPageValidationBindingExisted, (Object)currname));
                }
            }
        }
    }

    protected void createStringDialogField(Composite parent, StringDialogField field, IDialogFieldListener fieldAdapter) {
        field.setDialogFieldListener(fieldAdapter);
        field.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)field.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)field.getTextControl(null));
    }

    protected void HandleBindingNameChanged(BindingBaseConfiguration esConfig) {
        esConfig.setBindingName(this.fNameField.getText());
    }

    protected IPart browsedEGLPartFQValue(IProject project, int eglPartType, boolean isWorkspaceScope) {
        return this.browsedEGLPartFQValue(project, eglPartType, isWorkspaceScope, null);
    }

    protected IPart browsedEGLPartFQValue(IProject project, int eglPartType, boolean isWorkspaceScope, String helpId) {
        Object[] results;
        IPart newPart = null;
        EGLPartSelectionDialog dialog = this.getEGLPartSelectionDialog(eglPartType, NewWizardMessages.NewTypeWizardPageInterfaceDialogTitle, NewWizardMessages.NewTypeWizardPageInterfaceDialogLabel, project, isWorkspaceScope, helpId);
        if (dialog.open() == 0 && (results = dialog.getResult()).length > 0) {
            newPart = (IPart)results[0];
        }
        return newPart;
    }

    protected EGLPartSelectionDialog getEGLPartSelectionDialog(int elemKind, String title, String message, IProject project, boolean isWorkspaceScope) {
        return this.getEGLPartSelectionDialog(elemKind, title, message, project, isWorkspaceScope, null);
    }

    protected EGLPartSelectionDialog getEGLPartSelectionDialog(int elemKind, String title, String message, IProject project, boolean isWorkspaceScope, final String helpId) {
        Shell shell = this.getShell();
        EGLFileConfiguration fileConfig = new EGLFileConfiguration();
        IWizardContainer context = this.getWizard().getContainer();
        IEGLSearchScope searchScope = null;
        if (isWorkspaceScope) {
            searchScope = SearchEngine.createWorkspaceScope();
        } else {
            IEGLProject eglProj = EGLCore.create((IProject)project);
            searchScope = SearchEngine.createEGLSearchScope((IEGLElement[])new IEGLElement[]{eglProj}, (boolean)true);
        }
        EGLPartSelectionDialog dialog = new EGLPartSelectionDialog(shell, (IRunnableContext)context, elemKind, "", null, searchScope, fileConfig){

            public Control createDialogArea(Composite parent) {
                Control control = super.createDialogArea(parent);
                if (helpId != null) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(control, helpId);
                }
                return control;
            }
        };
        dialog.setTitle(title);
        dialog.setMessage(message);
        return dialog;
    }
}

