/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.packageexplorer.EGLElementContentProvider;
import org.eclipse.edt.ide.ui.internal.packageexplorer.EGLElementLabelProvider;
import org.eclipse.edt.ide.ui.internal.packageexplorer.EGLElementSorter;
import org.eclipse.edt.ide.ui.internal.wizards.EGLContainerWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLFileWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPackageWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.TypedElementSelectionValidator;
import org.eclipse.edt.ide.ui.internal.wizards.TypedViewerFilter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLWizardUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class EGLPackageWizardPage
extends EGLContainerWizardPage {
    private int nColumns = 4;
    private IPackageFragmentRoot fCurrRoot;
    protected StringButtonDialogField fContainerDialogField;
    protected Button fCheckBoxUpdateEGLPath;
    protected StatusInfo fContainerStatus;
    private StringDialogField fPackageDialogField;
    protected StatusInfo fPackageStatus;
    private PackageFieldAdapter adapter = new PackageFieldAdapter();

    public EGLPackageWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewPackageWizardPageTitle);
        this.setDescription(NewWizardMessages.NewPackageWizardPageDescription);
        this.fContainerStatus = new StatusInfo();
        this.fPackageStatus = new StatusInfo();
        this.fCurrRoot = null;
    }

    private EGLPackageConfiguration getConfiguration() {
        return ((EGLPackageWizard)this.getWizard()).getConfiguration();
    }

    protected EGLPackageConfiguration getPackageConfiguration() {
        return this.getConfiguration();
    }

    @Override
    public void updateControlValues() {
        if (this.fContainerDialogField != null && this.fContainerDialogField.getText() != null && !this.fContainerDialogField.getText().equals(this.getPackageConfiguration().getContainerName())) {
            this.fContainerDialogField.setText(this.getPackageConfiguration().getContainerName());
        }
        if (this.fPackageDialogField != null && this.fPackageDialogField.getText() != null && !this.fPackageDialogField.getText().equals(this.getPackageConfiguration().getFPackage())) {
            this.fPackageDialogField.setText(this.getPackageConfiguration().getFPackage());
        }
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_PACKAGE_DEFINITION);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 64);
        label.setText(NewWizardMessages.NewPackageWizardPageInfo);
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.horizontalSpan = this.nColumns;
        label.setLayoutData((Object)gd);
        this.createContainerControls(composite, this.nColumns);
        this.createPackageControls(composite);
        this.setControl((Control)composite);
        this.internalValidatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fPackageDialogField != null) {
            this.fPackageDialogField.setFocus();
        }
    }

    protected void createContainerControls(Composite parent, int nColumns) {
        this.createContainerControls(parent, nColumns, NewWizardMessages.NewContainerWizardPageContainerLabel);
    }

    protected void createContainerControls(Composite parent, int nColumns, String textLabel) {
        this.fContainerDialogField = new StringButtonDialogField(this.adapter);
        this.fContainerDialogField.setLabelText(textLabel);
        this.fContainerDialogField.setButtonLabel(NewWizardMessages.NewContainerWizardPageContainerButton);
        String str = this.getPackageConfiguration().getContainerName();
        this.fContainerDialogField.setText(str);
        this.updatePFragmentRoot(str);
        this.fContainerDialogField.setDialogFieldListener(this.adapter);
        this.fContainerDialogField.doFillIntoGrid(parent, nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fContainerDialogField.getTextControl(null));
    }

    protected void createUpdateEGLPathControls(Composite parent) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = this.nColumns - 1;
        this.fCheckBoxUpdateEGLPath = new Button(parent, 32);
        this.fCheckBoxUpdateEGLPath.setLayoutData((Object)gd);
        this.fCheckBoxUpdateEGLPath.setText(NewWizardMessages.NewContainerWizardPageUpdateEGLPath);
        this.getPackageConfiguration().setNeed2UpdateEGLPath(true);
        this.fCheckBoxUpdateEGLPath.setVisible(false);
        this.fCheckBoxUpdateEGLPath.addSelectionListener(new SelectionListener(){

            private void updateConfiguration(SelectionEvent e) {
                Button btn = (Button)e.getSource();
                EGLPackageWizardPage.this.getPackageConfiguration().setUpdateEGLPath(btn.getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createPackageControls(Composite parent) {
        this.fPackageDialogField = new StringDialogField();
        this.fPackageDialogField.setDialogFieldListener(this.adapter);
        this.fPackageDialogField.setLabelText(NewWizardMessages.NewPackageWizardPagePackageLabel);
        this.fPackageDialogField.setText(this.getPackageConfiguration().getFPackage());
        this.fPackageDialogField.doFillIntoGrid(parent, this.nColumns - 2);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fPackageDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fPackageDialogField.getTextControl(null));
    }

    private void handleContainerBrowseButtonSelected(IEGLElement initElement) {
        ElementTreeSelectionDialog dialog = this.openContainerDialog(initElement);
        if (dialog.open() == 0) {
            IEGLProject projectSelection = null;
            IPackageFragmentRoot sourceFolderSelection = null;
            Object element = dialog.getFirstResult();
            if (element instanceof IEGLProject) {
                projectSelection = (IEGLProject)element;
            } else if (element instanceof IPackageFragmentRoot) {
                sourceFolderSelection = (IPackageFragmentRoot)element;
            }
            if (projectSelection != null) {
                this.getPackageConfiguration().setProjectName(projectSelection.getProject().getName());
                this.getPackageConfiguration().setSourceFolderName("");
            }
            if (sourceFolderSelection != null) {
                this.getPackageConfiguration().setProjectName(sourceFolderSelection.getEGLProject().getElementName());
                this.getPackageConfiguration().setSourceFolderName(sourceFolderSelection.getElementName());
            }
            this.fContainerDialogField.setText(this.getPackageConfiguration().getContainerName());
            this.internalValidatePage();
        }
    }

    protected void handleContainerDialogFieldChanged() {
        String newContainerValue = this.fContainerDialogField.getText();
        this.getPackageConfiguration().setContainerName(newContainerValue);
        if (this.fCheckBoxUpdateEGLPath != null) {
            this.fCheckBoxUpdateEGLPath.setVisible(false);
            IResource newfolder = this.fWorkspaceRoot.findMember((IPath)new Path(newContainerValue));
            if (newfolder != null) {
                String newProjName = newfolder.getProject().getName();
                String originalProjName = this.getPackageConfiguration().getInitialProjectName();
                if (!originalProjName.equals(newProjName)) {
                    IProject currProject = this.fWorkspaceRoot.getProject(newProjName);
                    IEGLProject currEGLProj = EGLCore.create((IProject)currProject);
                    IProject initialProj = this.fWorkspaceRoot.getProject(originalProjName);
                    IEGLPathEntry newEntry = EGLCore.newProjectEntry((IPath)initialProj.getFullPath());
                    if (!currEGLProj.isOnEGLPath((IResource)initialProj) && !currEGLProj.hasEGLPathCycle(new IEGLPathEntry[]{newEntry})) {
                        this.fCheckBoxUpdateEGLPath.setVisible(true);
                        this.fCheckBoxUpdateEGLPath.setSelection(this.getPackageConfiguration().isUpdateEGLPath());
                    }
                }
            }
        }
        this.fCurrRoot = null;
        String str = this.getPackageConfiguration().getContainerName();
        this.updatePFragmentRoot(str);
    }

    protected void updatePFragmentRoot(String str) {
        IProject proj;
        int resType;
        Path path;
        IResource res;
        if (str.length() > 0 && (res = this.fWorkspaceRoot.findMember((IPath)(path = new Path(str)))) != null && ((resType = res.getType()) == 4 || resType == 2) && (proj = res.getProject()).isOpen()) {
            IEGLProject eglProj = EGLCore.create((IProject)proj);
            this.fCurrRoot = eglProj.getPackageFragmentRoot(res);
        }
        this.internalValidatePage();
    }

    private void handlePackageDialogFieldChanged(EGLPackageConfiguration config) {
        config.setFPackage(this.fPackageDialogField.getText());
        this.internalValidatePage();
    }

    private ElementTreeSelectionDialog openContainerDialog(IEGLElement initElement) {
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IEGLProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IEGLProject) {
                        IEGLProject eproject = (IEGLProject)element;
                        IPath path = eproject.getProject().getFullPath();
                        return eproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (EGLModelException e) {
                    EGLLogger.log((Object)this, e);
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IEGLModel.class, IPackageFragmentRoot.class, IEGLProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, null){

            @Override
            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (EGLModelException e) {
                        EGLLogger.log((Object)this, e);
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        EGLElementLabelProvider lp = new EGLElementLabelProvider(EGLElementLabelProvider.SHOW_DEFAULT);
        EGLElementContentProvider cp = new EGLElementContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setSorter((ViewerSorter)new EGLElementSorter());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPageChooseSourceContainerDialogTitle);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPageChooseSourceContainerDialogDescription);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)EGLCore.create((IWorkspaceRoot)this.fWorkspaceRoot));
        if (initElement != null) {
            dialog.setInitialSelection((Object)initElement);
        }
        return dialog;
    }

    private boolean internalValidatePage() {
        return this.validatePage();
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fCurrRoot;
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot root, boolean canBeModified) {
        this.fCurrRoot = root;
        String str = root == null ? "" : root.getPath().makeRelative().toString();
        this.fContainerDialogField.setText(str);
        this.fContainerDialogField.setEnabled(canBeModified);
    }

    protected boolean validatePage() {
        IProject initialProj;
        IEGLPathEntry newEntry;
        IProject currProject;
        IEGLProject currEGLProj;
        String originalProjName;
        this.fContainerStatus.setOK();
        this.fPackageStatus.setOK();
        String projectName = this.getPackageConfiguration().getProjectName();
        String containerName = this.getPackageConfiguration().getContainerName().trim();
        String sourceFolderName = this.getPackageConfiguration().getSourceFolderName();
        String packageName = this.getPackageConfiguration().getFPackage();
        boolean ret = true;
        if (this.fCheckBoxUpdateEGLPath != null && !(originalProjName = this.getPackageConfiguration().getInitialProjectName()).equals(projectName) && (currEGLProj = EGLCore.create((IProject)(currProject = this.fWorkspaceRoot.getProject(projectName)))).hasEGLPathCycle(new IEGLPathEntry[]{newEntry = EGLCore.newProjectEntry((IPath)(initialProj = this.fWorkspaceRoot.getProject(originalProjName)).getFullPath())})) {
            this.fPackageStatus.setError(NewWizardMessages.bind((String)NewWizardMessages.NewContainerWizardPageErrorCircularLink, (Object[])new String[]{originalProjName, projectName}));
            ret = false;
        }
        if (ret && (ret = EGLWizardUtilities.validatePackage(projectName, containerName, sourceFolderName, packageName, this.fContainerStatus, this.fPackageStatus, (Object)this)) && !(this instanceof EGLFileWizardPage)) {
            this.setErrorForBlankName(packageName);
        }
        this.updateStatus(new IStatus[]{this.fContainerStatus, this.fPackageStatus});
        return ret;
    }

    protected StringButtonDialogField createStringBrowseButtonDialogField(Composite parent, IStringBrowseButtonFieldAdapter adapter, String textLabel, String initText, int nCols) {
        return this.createStringBrowseButtonDialogField(parent, adapter, textLabel, initText, nCols, NewWizardMessages.NewContainerWizardPageContainerButton);
    }

    protected StringButtonDialogField createStringBrowseButtonDialogField(Composite parent, IStringBrowseButtonFieldAdapter adapter, String textLabel, String initText, int nCols, String buttonLabel) {
        StringButtonDialogField stringButtonDialogField = new StringButtonDialogField(adapter);
        stringButtonDialogField.setDialogFieldListener(adapter);
        stringButtonDialogField.setLabelText(textLabel);
        stringButtonDialogField.setButtonLabel(buttonLabel);
        stringButtonDialogField.setText(initText);
        stringButtonDialogField.doFillIntoGrid(parent, nCols);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)stringButtonDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)stringButtonDialogField.getTextControl(null));
        return stringButtonDialogField;
    }

    protected void setErrorForBlankName(String packageName) {
        if (packageName.trim().length() == 0) {
            this.fPackageStatus.setError(NewWizardMessages.NewPackageWizardPageErrorEnterName);
        }
    }

    protected static interface IStringBrowseButtonFieldAdapter
    extends IDialogFieldListener,
    IStringButtonAdapter {
    }

    private class PackageFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private PackageFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            String projectName = EGLPackageWizardPage.this.getPackageConfiguration().getProjectName();
            if (projectName != null && projectName.length() > 0) {
                EGLPackageWizardPage.this.handleContainerBrowseButtonSelected((IEGLElement)EGLCore.create((IProject)EGLPackageWizardPage.this.fWorkspaceRoot.getProject(projectName)));
            } else {
                EGLPackageWizardPage.this.handleContainerBrowseButtonSelected(null);
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            if (field == EGLPackageWizardPage.this.fPackageDialogField) {
                EGLPackageWizardPage.this.handlePackageDialogFieldChanged(EGLPackageWizardPage.this.getPackageConfiguration());
            } else if (field == EGLPackageWizardPage.this.fContainerDialogField) {
                EGLPackageWizardPage.this.handleContainerDialogFieldChanged();
            }
        }
    }
}

