/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.util.List;
import org.eclipse.edt.compiler.internal.core.builder.AccumulatingProblemrRequestor;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.EGLFileWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.EGLPartConfiguration;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

public class EGLPartWizardPage
extends EGLFileWizardPage {
    private boolean useDefaultTemplate = false;
    private static final String PAGE_NAME = "NewPartWizardPage";
    private static final String SETTINGS_DEFAULT_TEMPLATE = "default_template";
    private int nColumns = 5;
    private Group fTemplateSelectionGroup;
    private Button fUseDefaultTemplateButton;
    private Button fUseCustomTemplateButton;

    public EGLPartWizardPage(String pageName) {
        super(pageName);
    }

    public void init() {
        IDialogSettings section = this.getDialogSettings().getSection(PAGE_NAME);
        if (section != null) {
            this.useDefaultTemplate = section.getBoolean(SETTINGS_DEFAULT_TEMPLATE);
        }
    }

    private EGLPartConfiguration getConfiguration() {
        return (EGLPartConfiguration)((EGLPartWizard)this.getWizard()).getConfiguration();
    }

    protected void createTemplateSelectionControls(Composite parent) {
        Composite templateSelectionComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.nColumns;
        templateSelectionComposite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        templateSelectionComposite.setLayoutData((Object)gd);
        GridLayout groupLayout = new GridLayout();
        layout.numColumns = this.nColumns;
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        this.fTemplateSelectionGroup = new Group(templateSelectionComposite, 0);
        this.fTemplateSelectionGroup.setText(NewWizardMessages.NewEGLPartWizardPageTemplateSelectionLabel);
        this.fTemplateSelectionGroup.setLayout((Layout)groupLayout);
        this.fTemplateSelectionGroup.setLayoutData((Object)gd);
        this.fUseDefaultTemplateButton = new Button((Composite)this.fTemplateSelectionGroup, 16);
        this.fUseDefaultTemplateButton.setText(NewWizardMessages.NewEGLPartWizardPageTemplateSelectionDefault);
        this.fUseDefaultTemplateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EGLPartWizardPage.this.getConfiguration().setChosenTemplateSelection(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fUseDefaultTemplateButton.setSelection(this.useDefaultTemplate);
        this.fUseCustomTemplateButton = new Button((Composite)this.fTemplateSelectionGroup, 16);
        this.fUseCustomTemplateButton.setText(NewWizardMessages.NewEGLPartWizardPageTemplateSelectionCustom);
        this.fUseCustomTemplateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EGLPartWizardPage.this.getConfiguration().setChosenTemplateSelection(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fUseCustomTemplateButton.setSelection(!this.useDefaultTemplate);
    }

    public boolean handleTemplateError(String errorPart, String errorDescription) {
        MessageBox templateErrorDialog = new MessageBox(this.getShell(), 65729);
        String compositeMessage = String.valueOf(NewWizardMessages.NewEGLPartWizardPageTemplateSelectionErrorPrepart) + " " + errorPart + " " + NewWizardMessages.NewEGLPartWizardPageTemplateSelectionErrorPartdescription + errorDescription + NewWizardMessages.NewEGLPartWizardPageTemplateSelectionErrorPostdescription;
        templateErrorDialog.setMessage(compositeMessage);
        if (templateErrorDialog.open() != 64) {
            return false;
        }
        this.getConfiguration().setChosenTemplateSelection(0);
        this.validatePage();
        return true;
    }

    public void finishPage() {
        IDialogSettings section = this.getDialogSettings().getSection(PAGE_NAME);
        if (section == null) {
            section = this.getDialogSettings().addNewSection(PAGE_NAME);
        }
        section.put(SETTINGS_DEFAULT_TEMPLATE, this.getConfiguration().getChosenTemplateSelection() == 0);
    }

    protected void validateEGLName(String name, int nameValidatorConstant, StatusInfo status) {
        AccumulatingProblemrRequestor pRequestor = new AccumulatingProblemrRequestor();
        ICompilerOptions compilerOptions = new ICompilerOptions(){

            public boolean isVAGCompatible() {
                return false;
            }

            public boolean isAliasJSFNames() {
                return false;
            }
        };
        EGLNameValidator.validate((String)name, (int)nameValidatorConstant, (IProblemRequestor)pRequestor, (ICompilerOptions)compilerOptions);
        List validationList = pRequestor.getProblems();
        if (!validationList.isEmpty()) {
            int currentSeverity = -1;
            Problem problem = null;
            int i = 0;
            while (i < validationList.size()) {
                if (((Problem)validationList.get(i)).getSeverity() == 2) {
                    currentSeverity = 2;
                    problem = (Problem)validationList.get(i);
                    break;
                }
                if (((Problem)validationList.get(i)).getSeverity() == 1 && (currentSeverity == 0 || currentSeverity == -1)) {
                    currentSeverity = 1;
                    problem = (Problem)validationList.get(i);
                } else if (((Problem)validationList.get(i)).getSeverity() == 0 && currentSeverity == -1) {
                    currentSeverity = 0;
                    problem = (Problem)validationList.get(i);
                }
                ++i;
            }
            if (problem != null) {
                String messageFromBundle = DefaultProblemRequestor.getMessageFromBundle((int)problem.getProblemKind(), (String[])problem.getInserts());
                if (currentSeverity == 2) {
                    status.setError(messageFromBundle);
                } else if (currentSeverity == 1) {
                    status.setWarning(messageFromBundle);
                } else if (currentSeverity == 0) {
                    status.setInfo(messageFromBundle);
                }
            }
        }
    }
}

