/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.util.ExternalType2RuiInterfaceConverter;
import org.eclipse.edt.ide.ui.internal.wizards.ExtractInterfaceFrExternalTypeWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.ExtractInterfaceWizard;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceFrExternalTypeConfiguration;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceFrExternalTypeOperation;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class ExtractInterfaceFrExternalTypeWizard
extends ExtractInterfaceWizard {
    @Override
    public EGLPackageConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new ExtractInterfaceFrExternalTypeConfiguration();
        }
        return this.configuration;
    }

    private ExtractInterfaceFrExternalTypeConfiguration getExtractInterfaceFrExternalTypeConfiguration() {
        return (ExtractInterfaceFrExternalTypeConfiguration)this.getConfiguration();
    }

    @Override
    public void addPages() {
        this.addPage((IWizardPage)new ExtractInterfaceFrExternalTypeWizardPage("WIZPAGENAME_ExtractInterfaceFrExternalTypeWizardPage"));
    }

    @Override
    protected boolean runExtractInterfaceOp() {
        IFile interfacefile = null;
        try {
            interfacefile = ExtractInterfaceFrExternalTypeWizard.executeExtractInterfaceOp((IRunnableContext)this.getContainer(), this.getExtractInterfaceFrExternalTypeConfiguration());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            EGLLogger.log((Object)this, e);
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), null, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                EGLLogger.log((Object)this, e);
                e.printStackTrace();
            }
            return false;
        }
        this.openResource(interfacefile);
        return true;
    }

    public static IFile executeExtractInterfaceOp(IRunnableContext runnable, ExtractInterfaceFrExternalTypeConfiguration config) throws InvocationTargetException, InterruptedException {
        String interfacePkg = config.getFPackage();
        String fileName = config.getFileName();
        Map filecontents = ExternalType2RuiInterfaceConverter.convert(config);
        StringBuffer interfaceContent = new StringBuffer();
        ArrayList<String> additionalFiles = new ArrayList<String>();
        for (String key : filecontents.keySet()) {
            if (key.compareToIgnoreCase(interfacePkg) != 0) {
                additionalFiles.add(key);
                continue;
            }
            interfaceContent = (StringBuffer)filecontents.get(key);
        }
        ExtractInterfaceFrExternalTypeOperation op = new ExtractInterfaceFrExternalTypeOperation((EGLFileConfiguration)config, interfaceContent);
        runnable.run(false, true, (IRunnableWithProgress)op);
        IFile interfacefile = config.getFile();
        for (String pkgName : additionalFiles) {
            config.setFileName(String.valueOf(fileName) + "_Data");
            config.setFPackage(pkgName);
            StringBuffer fileContent_Data = (StringBuffer)filecontents.get(pkgName);
            ExtractInterfaceFrExternalTypeOperation addtionalFileOp = new ExtractInterfaceFrExternalTypeOperation((EGLFileConfiguration)config, fileContent_Data);
            runnable.run(false, true, (IRunnableWithProgress)addtionalFileOp);
        }
        return interfacefile;
    }
}

