/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.LibraryWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.LibraryConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class LibraryWizardPage
extends EGLPartWizardPage {
    private int libraryType = 0;
    private int nColumns = 5;
    private StringDialogField fLibraryDialogField;
    private StatusInfo fLibraryStatus;
    private Group fLibraryTypeGroup;
    private LibraryFieldAdapter adapter = new LibraryFieldAdapter();

    protected LibraryWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewEGLLibraryWizardPageTitle);
        this.setDescription(NewWizardMessages.NewEGLLibraryWizardPageDescription);
        this.fLibraryStatus = new StatusInfo();
    }

    private LibraryConfiguration getConfiguration() {
        return (LibraryConfiguration)((LibraryWizard)this.getWizard()).getConfiguration();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_LIBRARY_DEFINITION);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, this.nColumns);
        this.createPackageControls(composite);
        this.createSeparator(composite, this.nColumns);
        this.createEGLFileControls(composite);
        this.createLibraryControls(composite);
        this.modifyFileListeners();
        this.createLibraryTypeControls(composite);
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    protected void createLibraryControls(Composite parent) {
        this.fLibraryDialogField = new StringDialogField();
        this.fLibraryDialogField.setDialogFieldListener(this.adapter);
        this.fLibraryDialogField.setLabelText(NewWizardMessages.NewEGLLibraryWizardPagePartlabel);
        this.fLibraryDialogField.setText(this.getConfiguration().getLibraryName());
        this.fLibraryDialogField.setEnabled(false);
        this.fLibraryDialogField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fLibraryDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fLibraryDialogField.getTextControl(null));
    }

    private void createLibraryTypeControls(Composite parent) {
        Composite libraryTypeComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.nColumns;
        libraryTypeComposite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        libraryTypeComposite.setLayoutData((Object)gd);
        GridLayout groupLayout = new GridLayout();
        layout.numColumns = this.nColumns;
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        this.fLibraryTypeGroup = new Group(libraryTypeComposite, 0);
        this.fLibraryTypeGroup.setText(NewWizardMessages.NewEGLLibraryWizardPageLibraryTypeLabel);
        this.fLibraryTypeGroup.setLayout((Layout)groupLayout);
        this.fLibraryTypeGroup.setLayoutData((Object)gd);
        boolean isRuiProject = this.getPackageFragmentRoot().getEGLProject().isRuiProject();
        if (isRuiProject) {
            this.createLibraryChoiceButton((Composite)this.fLibraryTypeGroup, NewWizardMessages.NewEGLLibraryWizardPageLibraryTypeBasic, 0);
            this.createLibraryChoiceButton((Composite)this.fLibraryTypeGroup, NewWizardMessages.NewEGLLibraryWizardPageLibraryTypeRUIProp, 2);
        } else {
            libraryTypeComposite.setVisible(false);
        }
    }

    private Button createLibraryChoiceButton(Composite grp, String btnLabel, final int libType) {
        Button btn = new Button(grp, 16);
        btn.setText(btnLabel);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryWizardPage.this.getConfiguration().setLibraryType(libType);
            }
        });
        btn.setSelection(this.libraryType == libType);
        return btn;
    }

    protected void modifyFileListeners() {
        this.fEGLFileDialogField.getTextControl(null).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LibraryWizardPage.this.fLibraryDialogField.setText(LibraryWizardPage.this.fEGLFileDialogField.getText());
            }
        });
    }

    private void handleLibraryDialogFieldChanged() {
        this.getConfiguration().setLibraryName(this.fLibraryDialogField.getText());
        this.validatePage();
    }

    @Override
    protected boolean validatePage() {
        if (super.validatePage()) {
            this.fLibraryStatus.setOK();
            String partName = this.getConfiguration().getLibraryName();
            if (partName.length() == 0) {
                this.fLibraryStatus.setError(NewWizardMessages.NewTypeWizardPageErrorEnterPartName);
            } else if (partName.indexOf(46) != -1) {
                this.fLibraryStatus.setError(NewWizardMessages.NewTypeWizardPageErrorQualifiedName);
            } else {
                this.validateEGLName(partName, 22, this.fLibraryStatus);
            }
            this.updateStatus(new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fEGLFileStatus, this.fLibraryStatus});
            return this.fLibraryStatus.getSeverity() != 4;
        }
        return false;
    }

    private class LibraryFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private LibraryFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            LibraryWizardPage.this.handleLibraryDialogFieldChanged();
        }

        public void doubleClicked(ListDialogField field) {
        }
    }
}

