/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.RUIWidgetWizard;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.RUIWidgetConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class RUIWidgetWizardPage
extends EGLPartWizardPage {
    private static final String PAGE_NAME = "NewRUIWidgetWizardPage";
    private int nColumns = 5;
    private StringDialogField fWidgetDialogField;
    private StatusInfo fProgramStatus;

    protected RUIWidgetWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewEGLRUIWidgetWizardPageTitle);
        this.setDescription(NewWizardMessages.NewEGLRUIWidgetWizardPageDescription);
        this.fProgramStatus = new StatusInfo();
    }

    @Override
    public void init() {
    }

    private RUIWidgetConfiguration getConfiguration() {
        return (RUIWidgetConfiguration)((RUIWidgetWizard)this.getWizard()).getConfiguration();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.init();
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_RUI_WIDGET_DEFINITION);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, this.nColumns);
        this.createPackageControls(composite);
        this.createSeparator(composite, this.nColumns);
        this.createEGLFileControls(composite);
        this.createProgramPartControls(composite);
        this.modifyFileListeners();
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    private void createProgramPartControls(Composite parent) {
        this.fWidgetDialogField = new StringDialogField();
        this.fWidgetDialogField.setDialogFieldListener(new HandlerDialogFieldAdapter());
        this.fWidgetDialogField.setLabelText(NewWizardMessages.NewEGLRUIWidgetWizardPagePartlabel);
        this.fWidgetDialogField.setEnabled(false);
        this.fWidgetDialogField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fWidgetDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fWidgetDialogField.getTextControl(null));
        this.fWidgetDialogField.setText(this.getConfiguration().getWidgetName());
    }

    private void modifyFileListeners() {
        this.fEGLFileDialogField.getTextControl(null).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RUIWidgetWizardPage.this.fWidgetDialogField.setText(RUIWidgetWizardPage.this.fEGLFileDialogField.getText());
            }
        });
    }

    private void handleWidgetDialogFieldChanged() {
        this.getConfiguration().setWidgetName(this.fWidgetDialogField.getText());
        this.validatePage();
    }

    @Override
    protected boolean validatePage() {
        if (super.validatePage()) {
            this.fProgramStatus.setOK();
            String partName = this.getConfiguration().getWidgetName();
            if (partName.length() == 0) {
                this.fProgramStatus.setError(NewWizardMessages.NewTypeWizardPageErrorEnterPartName);
            } else if (partName.indexOf(46) != -1) {
                this.fProgramStatus.setError(NewWizardMessages.NewTypeWizardPageErrorQualifiedName);
            } else {
                this.validateEGLName(partName, 2, this.fProgramStatus);
            }
            this.updateStatus(new IStatus[]{this.fProgramStatus});
            return this.fProgramStatus.getSeverity() != 4;
        }
        return false;
    }

    @Override
    public void finishPage() {
        super.finishPage();
        IDialogSettings section = this.getDialogSettings().getSection(PAGE_NAME);
        if (section == null) {
            section = this.getDialogSettings().addNewSection(PAGE_NAME);
        }
    }

    private class HandlerDialogFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private HandlerDialogFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
        }

        @Override
        public void selectionChanged(ListDialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            RUIWidgetWizardPage.this.handleWidgetDialogFieldChanged();
        }

        @Override
        public void doubleClicked(ListDialogField field) {
        }
    }
}

