/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.core.EDTCorePreferenceConstants;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.internal.util.CoreUtility;
import org.eclipse.edt.ide.ui.wizards.EGLSourceFolderConfiguration;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class EGLSourceFolderOperation
extends WorkspaceModifyOperation {
    private EGLSourceFolderConfiguration configuration;

    public EGLSourceFolderOperation(EGLSourceFolderConfiguration configuration) {
        this.configuration = configuration;
    }

    public EGLSourceFolderOperation(EGLSourceFolderConfiguration configuration, ISchedulingRule rule) {
        super(rule);
        this.configuration = configuration;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            Path path = new Path(this.configuration.getProjectName());
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.toString());
            IEGLProject fCurrEProject = EGLCore.create((IProject)project);
            IEGLPathEntry[] fEntries = fCurrEProject.getRawEGLPath();
            IPath fOutputLocation = fCurrEProject.getOutputLocation();
            path = path.append(this.configuration.getSourceFolderName());
            IEGLPathEntry newEntry = EGLCore.newSourceEntry((IPath)path.makeAbsolute());
            IPath projPath = fCurrEProject.getProject().getFullPath();
            ArrayList<IEGLPathEntry> newEntries = new ArrayList<IEGLPathEntry>(fEntries.length + 1);
            int projectEntryIndex = -1;
            int i = 0;
            while (i < fEntries.length) {
                IEGLPathEntry curr = fEntries[i];
                if (curr.getEntryKind() == 3 && projPath.equals((Object)curr.getPath())) {
                    projectEntryIndex = i;
                }
                newEntries.add(curr);
                ++i;
            }
            if (projectEntryIndex != -1) {
                newEntries.set(projectEntryIndex, newEntry);
            } else {
                newEntries.add(EGLCore.newSourceEntry((IPath)path.makeAbsolute()));
            }
            IEGLPathEntry[] fNewEntries = newEntries.toArray(new IEGLPathEntry[newEntries.size()]);
            IPath fNewOutputLocation = fOutputLocation;
            IEGLModelStatus status = EGLConventions.validateEGLPath((IEGLProject)fCurrEProject, (IEGLPathEntry[])fNewEntries, (IPath)fNewOutputLocation);
            if (!status.isOK() && fOutputLocation.equals((Object)projPath)) {
                fNewOutputLocation = projPath.append(EDTCorePreferenceConstants.getPreferenceStore().getString("eglOutputFolder"));
            }
            String relPath = this.configuration.getSourceFolderName();
            IFolder folder = fCurrEProject.getProject().getFolder(relPath);
            if (!folder.exists()) {
                CoreUtility.createFolder(folder, true, true, null);
            }
            fCurrEProject.setRawEGLPath(fNewEntries, fNewOutputLocation, monitor);
        }
        finally {
            monitor.done();
        }
    }
}

