/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.edt.compiler.internal.EGLAliasJsfNamesSetting;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.PPListElement;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.EGLFileWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.project.templates.BasicProjectTemplate;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLFileOperation;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPackageOperation;
import org.eclipse.edt.ide.ui.wizards.EGLSourceFolderConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLSourceFolderOperation;
import org.eclipse.edt.ide.ui.wizards.FileRemoveOperation;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.edt.ide.ui.wizards.ProjectFinishUtility;
import org.eclipse.edt.ide.ui.wizards.ProjectRemoveOperation;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class EGLWizardUtilities {
    public static final int EGLFEATURE_EGLDD_MASK = 16;
    public static final int EGLFEATURE_BIRT_MASK = 8;
    public static final int EGLFEATURE_JASPER_MASK = 4;
    public static final int EGLFEATURE_MQ_MASK = 32;
    public static final int EGLFEATURE_LDAP_MASK = 64;
    public static final int EGLFEATURE_i5OS_MASK = 128;
    public static String[] JASPER_RUNTIMEJARS = new String[]{"commons-beanutils-1.5.jar", "commons-collections-2.1.jar", "commons-digester-1.3.jar", "commons-logging-1.0.2.jar", "commons-logging-api-1.0.2.jar", "jasperreports-0.6.1.jar"};
    public static String[] SOA_WS_CLIENT_JARS = new String[]{"axis.jar", "commons-discovery-0.2.jar", "jaxrpc.jar", "saaj.jar", "wsdl4j-1.5.1.jar"};
    public static String[] SOA_WS_CLIENT_JARS_NONWEB = new String[]{"commons-logging-1.0.4.jar"};
    public static String[] SOA_WS_CLIENT_EGL_JARS = new String[]{"eglwsdl.jar"};
    private static Map FACET_RUNTIME_MAP = Collections.EMPTY_MAP;
    public static final String WAS_RUNTIME_TYPE = "WAS";
    public static final String TOMCAT_RUNTIME_TYPE = "TOMCAT";
    public static final String TOMCAT_RUNTIME_ID = "org.eclipse.jst.server.tomcat";
    public static final String WAS_RUNTIME_ID = "com.ibm.ws.ast.st.runtime";

    public static void createProject(String name) throws CoreException, InterruptedException, InvocationTargetException {
        EGLWizardUtilities.createProject(name, EGLWizardUtilities.getEGLFeatureMaskFrPreference(false));
    }

    public static void createProject(String name, int eglFeatureMask) throws CoreException, InterruptedException, InvocationTargetException {
        EGLWizardUtilities.createProject(name, new ArrayList<String>(), eglFeatureMask);
    }

    public static void createProject(String name, List<String> dependencies) throws CoreException, InterruptedException, InvocationTargetException {
        EGLWizardUtilities.createProject(name, dependencies, EGLWizardUtilities.getEGLFeatureMaskFrPreference(false));
    }

    public static void createProject(String name, List<String> dependencies, int eglFeatureMask) throws CoreException, InterruptedException, InvocationTargetException {
        ProjectConfiguration conf = new ProjectConfiguration();
        conf.setDefaultAttributes();
        conf.setProjectName(name);
        EGLWizardUtilities.createProject(name, dependencies, conf, eglFeatureMask);
    }

    public static void createProject(String name, List<String> dependencies, ProjectConfiguration projConfig) throws CoreException, InterruptedException, InvocationTargetException {
        EGLWizardUtilities.createProject(name, dependencies, projConfig, EGLWizardUtilities.getEGLFeatureMaskFrPreference(false));
    }

    public static void createProject(String name, List<String> dependencies, ProjectConfiguration projConfig, int eglFeatureMask) throws CoreException, InterruptedException, InvocationTargetException {
        List<PPListElement> requiredProjs = projConfig.getRequiredProjects();
        List<PPListElement> projectDependencies = null;
        if (!dependencies.isEmpty()) {
            projectDependencies = EGLWizardUtilities.getProjectDependencies(name, dependencies);
        }
        HashSet<PPListElement> set = new HashSet<PPListElement>();
        if (requiredProjs != null && !requiredProjs.isEmpty()) {
            set.addAll(requiredProjs);
        }
        if (projectDependencies != null && !projectDependencies.isEmpty()) {
            set.addAll(projectDependencies);
        }
        if (!set.isEmpty()) {
            ArrayList<PPListElement> mergedProjDependencies = new ArrayList<PPListElement>();
            mergedProjDependencies.addAll(set);
            projConfig.setRequiredProjects(mergedProjDependencies);
        }
        ISchedulingRule rule = null;
        Job job = Job.getJobManager().currentJob();
        if (job != null) {
            rule = job.getRule();
        }
        if (rule == null) {
            rule = ResourcesPlugin.getWorkspace().getRoot();
        }
        BasicProjectTemplate projectTemplate = new BasicProjectTemplate();
        List<WorkspaceModifyOperation> ops = ProjectFinishUtility.getCreateProjectFinishOperations(projectTemplate, projConfig, eglFeatureMask, rule);
        for (WorkspaceModifyOperation obj : ops) {
            if (!(obj instanceof WorkspaceModifyOperation)) continue;
            WorkspaceModifyOperation op = obj;
            op.run((IProgressMonitor)new NullProgressMonitor());
        }
        IProject myProject = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (myProject.exists() && !myProject.isOpen()) {
            myProject.open((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static int getEGLFeatureMaskFrPreference(boolean isWebProject) {
        int eglfeatureMask = EGLBasePlugin.getPlugin().getPreferenceStore().getInt("EGLFeatureMask");
        if (isWebProject) {
            eglfeatureMask &= 0xFFFFFFFB;
        }
        return eglfeatureMask;
    }

    public static void createSourceFolder(String name, String projectName) throws CoreException, InterruptedException, InvocationTargetException {
        EGLSourceFolderConfiguration conf = new EGLSourceFolderConfiguration();
        conf.init(null, null);
        conf.setProjectName(projectName);
        conf.setSourceFolderName(name);
        EGLSourceFolderOperation op = new EGLSourceFolderOperation(conf);
        op.execute((IProgressMonitor)new NullProgressMonitor());
    }

    public static void createPackage(String name, String projectName) throws CoreException, InterruptedException, InvocationTargetException {
        EGLPackageConfiguration conf = new EGLPackageConfiguration();
        conf.init(null, null);
        conf.setProjectName(projectName);
        conf.setFPackage(name);
        EGLPackageOperation op = new EGLPackageOperation(conf);
        op.execute((IProgressMonitor)new NullProgressMonitor());
    }

    public static void createPackage(String name, String projectName, String sourceFolderName) throws CoreException, InterruptedException, InvocationTargetException {
        EGLPackageConfiguration conf = new EGLPackageConfiguration();
        conf.init(null, null);
        conf.setProjectName(projectName);
        conf.setSourceFolderName(sourceFolderName);
        conf.setFPackage(name);
        EGLPackageOperation op = new EGLPackageOperation(conf);
        op.execute((IProgressMonitor)new NullProgressMonitor());
    }

    public static IFile createEGLFile(String name, String projectName, String packageName) throws CoreException, InterruptedException, InvocationTargetException {
        return EGLWizardUtilities.createEGLFile(name, projectName, packageName, EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("eglSourceFolder"));
    }

    public static IFile createEGLFile(String name, String projectName, String packageName, String sourceFolderName) throws CoreException, InterruptedException, InvocationTargetException {
        EGLFileConfiguration conf = new EGLFileConfiguration();
        conf.init(null, null);
        conf.setProjectName(projectName);
        conf.setSourceFolderName(sourceFolderName);
        conf.setFPackage(packageName);
        conf.setFileName(name);
        EGLFileOperation op = new EGLFileOperation(conf);
        op.execute((IProgressMonitor)new NullProgressMonitor());
        return conf.getFile();
    }

    public static IFile createEGLBuildFile(String name, String projectName) throws CoreException, InterruptedException, InvocationTargetException {
        return EGLWizardUtilities.createEGLBuildFile(name, projectName, null, null);
    }

    public static IFile createEGLBuildFile(String name, String projectName, String packageName) throws CoreException, InterruptedException, InvocationTargetException {
        return EGLWizardUtilities.createEGLBuildFile(name, projectName, packageName, EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("eglSourceFolder"));
    }

    public static IFile createEGLBuildFile(String name, String projectName, String packageName, String sourceFolderName) throws CoreException, InterruptedException, InvocationTargetException {
        IFolder container;
        IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = fWorkspaceRoot.getProject(projectName);
        IEGLProject thisProject = EGLCore.create((IProject)project);
        IPath srcPath = thisProject.getPath().append(sourceFolderName);
        IPackageFragmentRoot eglSrcFolder = thisProject.getPackageFragmentRoot(srcPath);
        if (sourceFolderName == null) {
            container = (IFolder)project.getRawLocation().makeAbsolute();
        } else if (packageName == null || packageName.compareTo("") == 0) {
            container = (IFolder)eglSrcFolder.getUnderlyingResource();
        } else {
            IPackageFragment pFrag = eglSrcFolder.getPackageFragment(packageName);
            container = (IFolder)pFrag.getUnderlyingResource();
        }
        IFile file = container.getFile((IPath)new Path(String.valueOf(name) + ".eglbld"));
        String encodingName = EGLBasePlugin.getPlugin().getPreferenceStore().getString("outputCodeset");
        try {
            String bdContents = EGLWizardUtilities.getBuildDescriptorFileHeader(encodingName);
            if (encodingName.equals("UTF-16") || encodingName.equals("UTF-16BE")) {
                encodingName = "UnicodeBig";
            } else if (encodingName.equals("UTF-16LE")) {
                encodingName = "UnicodeLittle";
            }
            Charset charset = Charset.forName(encodingName);
            ByteBuffer buffer = charset.encode(bdContents.trim());
            ByteArrayInputStream stream = new ByteArrayInputStream(buffer.array(), 0, buffer.limit());
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                file.create((InputStream)stream, true, (IProgressMonitor)new NullProgressMonitor());
            }
            ((InputStream)stream).close();
        }
        catch (IOException iOException) {}
        return file;
    }

    public static void removeProject(String name) throws CoreException, InterruptedException, InvocationTargetException {
        ProjectConfiguration conf = new ProjectConfiguration();
        conf.setProjectName(name);
        ProjectRemoveOperation op = new ProjectRemoveOperation(conf);
        op.execute((IProgressMonitor)new NullProgressMonitor());
    }

    public static void removeSourceFolder(String name, String projectName) throws CoreException, InterruptedException, InvocationTargetException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IEGLProject eproject = EGLCore.create((IProject)project);
        IPackageFragmentRoot root = eproject.getPackageFragmentRoot((IPath)new Path(name));
        IEGLModel model = EGLCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IEGLElement[] elements = new IEGLElement[]{root};
        model.delete(elements, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void removePackage(String name, String projectName) throws CoreException, InterruptedException, InvocationTargetException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IEGLProject eproject = EGLCore.create((IProject)project);
        IPackageFragmentRoot[] roots = eproject.getPackageFragmentRoots();
        IPackageFragment packageFragment = roots[0].getPackageFragment(name);
        IEGLModel model = EGLCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IEGLElement[] elements = new IEGLElement[]{packageFragment};
        model.delete(elements, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void removePackage(String name, String projectName, String sourceFolderName) throws CoreException, InterruptedException, InvocationTargetException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IEGLProject eproject = EGLCore.create((IProject)project);
        IPackageFragmentRoot roots = eproject.getPackageFragmentRoot((IPath)new Path(sourceFolderName));
        IPackageFragment packageFragment = roots.getPackageFragment(name);
        IEGLModel model = EGLCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IEGLElement[] elements = new IEGLElement[]{packageFragment};
        model.delete(elements, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void removeEGLFile(String name, String projectName, String packageName) throws CoreException, InterruptedException, InvocationTargetException {
        EGLFileConfiguration conf = new EGLFileConfiguration();
        conf.init(null, null);
        conf.setProjectName(projectName);
        conf.setFPackage(packageName);
        conf.setFileName(name);
        FileRemoveOperation op = new FileRemoveOperation(conf);
        op.execute((IProgressMonitor)new NullProgressMonitor());
    }

    public static void removeEGLFile(String name, String projectName, String packageName, String sourceFolderName) throws CoreException, InterruptedException, InvocationTargetException {
        EGLFileConfiguration conf = new EGLFileConfiguration();
        conf.init(null, null);
        conf.setProjectName(projectName);
        conf.setSourceFolderName(sourceFolderName);
        conf.setFPackage(packageName);
        conf.setFileName(name);
        FileRemoveOperation op = new FileRemoveOperation(conf);
        op.execute((IProgressMonitor)new NullProgressMonitor());
    }

    private static String getBuildDescriptorFileHeader(String encodingName) {
        String DTDKey = "-//IBM Corporation, Inc.//DTD EGL Build Parts 6.0//EN";
        String XMLHeader = "<?xml version=\"1.0\" encoding=\"" + encodingName + "\"?>\n\n" + "<!DOCTYPE EGL PUBLIC \"" + DTDKey + "\" \"\">\n\n";
        return XMLHeader;
    }

    public static List<PPListElement> getProjectDependencies(String projectName, List<String> dependencies) throws CoreException {
        ArrayList<Object> projectDependencies = new ArrayList();
        ArrayList<PPListElement> newEGLPath = null;
        IPath newPath = null;
        IPath currPath = null;
        PPListElement newElement = null;
        PPListElement currElement = null;
        newEGLPath = EGLWizardUtilities.getExistingProjectDependencies(projectName);
        if (!dependencies.isEmpty()) {
            projectDependencies = EGLWizardUtilities.getNewProjectDependencies(projectName, dependencies);
            boolean found = false;
            int i = 0;
            while (i < projectDependencies.size()) {
                newElement = (PPListElement)projectDependencies.get(i);
                newPath = newElement.getEGLPathEntry().getPath();
                found = false;
                int j = 0;
                while (j < newEGLPath.size() && !found) {
                    currElement = (PPListElement)newEGLPath.get(j);
                    currPath = currElement.getEGLPathEntry().getPath();
                    if (currPath.equals((Object)newPath)) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    newEGLPath.add(newElement);
                }
                ++i;
            }
        }
        return newEGLPath;
    }

    public static ArrayList<PPListElement> getExistingProjectDependencies(String projectName) throws CoreException {
        IProject project = null;
        IEGLProject eglProject = null;
        IEGLPathEntry[] eglPathEntries = null;
        ArrayList<PPListElement> newEGLPath = new ArrayList<PPListElement>();
        IResource resource = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        resource = root.findMember((IPath)new Path(projectName));
        if (resource == null) {
            return newEGLPath;
        }
        project = resource.getProject();
        eglProject = EGLCore.create((IProject)project);
        eglPathEntries = eglProject.getRawEGLPath();
        if (eglPathEntries != null) {
            int i = 0;
            while (i < eglPathEntries.length) {
                IEGLPathEntry curr = eglPathEntries[i];
                newEGLPath.add(PPListElement.createFromExisting((IEGLPathEntry)curr, (IEGLProject)eglProject));
                ++i;
            }
        }
        return newEGLPath;
    }

    public static ArrayList<PPListElement> getNewProjectDependencies(String projectName, List<String> dependencies) {
        Iterator<String> dependenciesIterator = null;
        String dependentProjectName2 = "";
        IProject dependentProject = null;
        PPListElement currentDependent = null;
        IResource resource = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        ArrayList<PPListElement> projectDependencies = new ArrayList<PPListElement>();
        for (String dependentProjectName2 : dependencies) {
            if (projectName.equalsIgnoreCase(dependentProjectName2)) continue;
            resource = root.findMember((IPath)new Path(dependentProjectName2));
            dependentProject = resource.getProject();
            currentDependent = new PPListElement(null, 2, dependentProject.getFullPath(), (IResource)dependentProject);
            projectDependencies.add(currentDependent);
        }
        return projectDependencies;
    }

    public static void createFolderRecursiveIfNeeded(IContainer folder) throws CoreException {
        if (folder.getParent() != null && !folder.getParent().exists()) {
            EGLWizardUtilities.createFolderRecursiveIfNeeded(folder.getParent());
        }
        if (folder instanceof IFolder && !folder.exists()) {
            ((IFolder)folder).create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static boolean validateProject(String projName, String projLocation, boolean isUseDefaults, StatusInfo projNameStatus, StatusInfo locationStatus, String strMessage, String strErrorMessage) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (projName.equals("")) {
            strMessage = NewWizardMessages.WizardNewProjectCreationPage_projectNameEmpty;
            projNameStatus.setError(strMessage);
        } else {
            IStatus nameStatus = workspace.validateName(projName, 4);
            if (nameStatus.getSeverity() != 4 && projName.indexOf("-") != -1) {
                projNameStatus.setWarning(NewWizardMessages.NewProjectCreationWizardPageWarningNamecontainsdash);
            }
            if (!nameStatus.isOK()) {
                if (nameStatus.getSeverity() == 4) {
                    projNameStatus.setError(nameStatus.getMessage());
                } else if (nameStatus.getSeverity() == 2) {
                    projNameStatus.setWarning(nameStatus.getMessage());
                }
            } else if (projLocation.equals("")) {
                strMessage = NewWizardMessages.WizardNewProjectCreationPage_projectLocationEmpty;
                locationStatus.setError(strMessage);
            } else {
                Path path = new Path("");
                if (!path.isValidPath(projLocation)) {
                    locationStatus.setError(NewWizardMessages.WizardNewProjectCreationPage_locationError);
                } else {
                    Path projectPath = new Path(projLocation);
                    if (!isUseDefaults && Platform.getLocation().isPrefixOf((IPath)projectPath)) {
                        locationStatus.setError(NewWizardMessages.WizardNewProjectCreationPage_defaultLocationError);
                    } else {
                        IProject handle = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
                        if (handle.exists()) {
                            projNameStatus.setError(NewWizardMessages.WizardNewProjectCreationPage_projectExistsMessage);
                        } else if (!isUseDefaults) {
                            IStatus currLocationStatus = workspace.validateProjectLocation(handle, (IPath)projectPath);
                            if (!currLocationStatus.isOK()) {
                                locationStatus.setError(currLocationStatus.getMessage());
                            } else {
                                strErrorMessage = "";
                                strMessage = "";
                            }
                        }
                    }
                }
            }
        }
        return projNameStatus.getSeverity() != 4 && locationStatus.getSeverity() != 4;
    }

    public static boolean validateEglSourceFolder(String projName, String sourceFolderName) {
        IEGLProject eglProject;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(projName);
        boolean isEglSource = false;
        if (project != null && (eglProject = EGLCore.create((IProject)project)) != null) {
            try {
                IPackageFragmentRoot[] sources = eglProject.getAllPackageFragmentRoots();
                int idx = 0;
                while (sources != null && idx < sources.length) {
                    if (sourceFolderName.equalsIgnoreCase(sources[idx].getElementName())) {
                        isEglSource = true;
                        break;
                    }
                    ++idx;
                }
            }
            catch (EGLModelException eGLModelException) {}
        }
        return isEglSource;
    }

    public static boolean validatePackage(String projName, String containerName, String sourceFolderName, String packageName, StatusInfo containerStatus, StatusInfo pkgStatus, Object callingobj) {
        block26: {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IPackageFragmentRoot currRoot = null;
            if (containerName.length() == 0) {
                containerStatus.setError(NewWizardMessages.NewContainerWizardPageErrorEnterContainerName);
            } else if (containerName.indexOf("\\\\") != -1) {
                containerStatus.setError(NewWizardMessages.NewContainerWizardPageErrorBackSlash);
            } else {
                Path path = new Path(containerName);
                IResource res = workspaceRoot.findMember((IPath)path);
                if (res != null) {
                    int resType = res.getType();
                    if (resType == 4 || resType == 2) {
                        IProject proj = res.getProject();
                        if (!proj.isOpen()) {
                            containerStatus.setError(NewWizardMessages.bind((String)NewWizardMessages.NewContainerWizardPageErrorProjectClosed, (Object)proj.getFullPath().toString()));
                        } else {
                            IEGLProject eproject = EGLCore.create((IProject)proj);
                            currRoot = eproject.getPackageFragmentRoot(res);
                            if (res.exists()) {
                                try {
                                    if (!proj.hasNature(EGLCore.NATURE_ID)) {
                                        if (resType == 4) {
                                            containerStatus.setError(NewWizardMessages.NewContainerWizardPageWarningNotAnEGLProject);
                                        } else {
                                            containerStatus.setWarning(NewWizardMessages.NewContainerWizardPageWarningNotInAnEGLProject);
                                        }
                                    }
                                }
                                catch (CoreException coreException) {
                                    containerStatus.setWarning(NewWizardMessages.NewContainerWizardPageWarningNotAnEGLProject);
                                }
                                if (!eproject.isOnEGLPath((IEGLElement)currRoot)) {
                                    containerStatus.setError(NewWizardMessages.bind((String)NewWizardMessages.NewContainerWizardPageWarningNotOnEGLPath, (Object)containerName));
                                }
                                if (currRoot.isArchive()) {
                                    containerStatus.setError(NewWizardMessages.bind((String)NewWizardMessages.NewContainerWizardPageErrorContainerIsBinary, (Object)containerName));
                                }
                            }
                        }
                    } else {
                        containerStatus.setError(NewWizardMessages.bind((String)NewWizardMessages.NewContainerWizardPageErrorNotAFolder, (Object)containerName));
                    }
                } else {
                    containerStatus.setError(NewWizardMessages.bind((String)NewWizardMessages.NewContainerWizardPageErrorContainerDoesNotExist, (Object)containerName));
                }
            }
            if (packageName.length() > 0) {
                ICompilerOptions compilerOption = new ICompilerOptions(){

                    public boolean isVAGCompatible() {
                        return false;
                    }

                    public boolean isAliasJSFNames() {
                        return EGLAliasJsfNamesSetting.isAliasJsfNames();
                    }
                };
                NameValidatorProblemRequestor nameValidaRequestor = new NameValidatorProblemRequestor(pkgStatus);
                EGLNameValidator.validate((String)packageName, (int)30, (IProblemRequestor)nameValidaRequestor, (ICompilerOptions)compilerOption);
                try {
                    if (projName == null || projName.equals("")) {
                        pkgStatus.setError(NewWizardMessages.NewSourceFolderWizardPageErrorEnterProjectName);
                        break block26;
                    }
                    IEGLProject project = EGLCore.create((IProject)workspaceRoot.getProject(projName));
                    IPackageFragmentRoot root = project.getPackageFragmentRoot((IPath)new Path(sourceFolderName));
                    if (root == null) break block26;
                    IPackageFragment pack = root.getPackageFragment(packageName);
                    try {
                        IPath rootPath = root.getPath();
                        IPath outputPath = root.getEGLProject().getOutputLocation();
                        if (rootPath.equals((Object)outputPath)) break block26;
                        IPath packagePath = pack.getPath();
                        if (outputPath.isPrefixOf(packagePath)) {
                            pkgStatus.setError(NewWizardMessages.NewPackageWizardPageErrorIsOutputFolder);
                            break block26;
                        }
                        if (!pack.exists() || callingobj instanceof EGLFileWizardPage) break block26;
                        if (pack.containsEGLResources() || !pack.hasSubpackages()) {
                            pkgStatus.setError(NewWizardMessages.NewPackageWizardPageErrorPackageExists);
                            break block26;
                        }
                        pkgStatus.setError(NewWizardMessages.NewPackageWizardPageWarningPackageNotShown);
                    }
                    catch (EGLModelException e) {
                        EGLLogger.log(callingobj, e);
                    }
                }
                catch (EGLModelException e) {
                    EGLLogger.log(callingobj, e);
                }
            }
        }
        return containerStatus.getSeverity() != 4 && pkgStatus.getSeverity() != 4;
    }

    public static boolean validateFile(String projName, String containerName, String pkgName, String fileName, String fileExtension, StatusInfo fileStatus, Object callingobj, boolean checkExistance) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (fileName.length() == 0) {
            fileStatus.setError(NewWizardMessages.NewTypeWizardPageErrorEnterTypeName);
        } else if (fileName.indexOf(46) != -1) {
            fileStatus.setError(NewWizardMessages.NewTypeWizardPageErrorQualifiedName);
        } else {
            ICompilerOptions compilerOption = new ICompilerOptions(){

                public boolean isVAGCompatible() {
                    return false;
                }

                public boolean isAliasJSFNames() {
                    return EGLAliasJsfNamesSetting.isAliasJsfNames();
                }
            };
            NameValidatorProblemRequestor nameValidaRequestor = new NameValidatorProblemRequestor(fileStatus);
            EGLNameValidator.validate((String)(String.valueOf(fileName) + "." + fileExtension), (int)31, (IProblemRequestor)nameValidaRequestor, (ICompilerOptions)compilerOption);
            IFile filehandler = null;
            IProject project = workspaceRoot.getProject(projName);
            IEGLProject eproject = EGLCore.create((IProject)project);
            try {
                Path sourcePath = new Path(containerName);
                IPackageFragmentRoot froot = eproject.findPackageFragmentRoot(sourcePath.makeAbsolute());
                if (froot != null) {
                    IResource packFolder;
                    IPackageFragment pack = froot.getPackageFragment(pkgName);
                    if (pack != null && (packFolder = pack.getResource()) != null) {
                        IContainer container = (IContainer)packFolder;
                        Path filepath = new Path(fileName);
                        filepath = filepath.addFileExtension(fileExtension);
                        filehandler = container.getFile((IPath)filepath);
                    }
                } else {
                    IPath filePath = sourcePath.append(fileName);
                    filePath = filePath.addFileExtension(fileExtension);
                    filehandler = workspaceRoot.getFile(filePath);
                }
            }
            catch (EGLModelException e) {
                e.printStackTrace();
                EGLLogger.log(callingobj, e);
            }
            try {
                URI fileLocation;
                IFileStore filestore;
                if (filehandler != null && !filehandler.exists() && (filestore = EFS.getStore((URI)(fileLocation = filehandler.getLocationURI()))).fetchInfo().exists()) {
                    fileStatus.setError(NewWizardMessages.ValidatePageErrorFileNameExistsDiffCase);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (checkExistance && filehandler != null && filehandler.exists()) {
                fileStatus.setError(NewWizardMessages.NewTypeWizardPageErrorTypeNameExists);
            }
        }
        return fileStatus.getSeverity() != 4;
    }

    public static boolean validateFile(String projName, String containerName, String pkgName, String fileName, StatusInfo fileStatus, Object callingobj, boolean checkExistance) {
        return EGLWizardUtilities.validateFile(projName, containerName, pkgName, fileName, "egl", fileStatus, callingobj, checkExistance);
    }

    public static class NameValidatorProblemRequestor
    extends DefaultProblemRequestor {
        private StatusInfo fStatusInfo;

        public NameValidatorProblemRequestor(StatusInfo statusInfo) {
            this.fStatusInfo = statusInfo;
        }

        public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts) {
            String[] shiftedInserts = NameValidatorProblemRequestor.shiftInsertsIfNeccesary((int)problemKind, (String[])inserts);
            String problemMsg = NameValidatorProblemRequestor.getMessageFromBundle((int)problemKind, (String[])shiftedInserts);
            switch (severity) {
                case 2: {
                    this.fStatusInfo.setError(problemMsg);
                    break;
                }
                case 1: {
                    this.fStatusInfo.setWarning(problemMsg);
                    break;
                }
                case 0: {
                    this.fStatusInfo.setInfo(problemMsg);
                }
            }
        }
    }
}

