/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.ui.internal.deployment.Deployment;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.Parameters;
import org.eclipse.edt.ide.ui.internal.deployment.Service;
import org.eclipse.edt.ide.ui.internal.deployment.Services;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.wizards.EGLPartConfiguration;

public class WebServicesConfiguration
extends EGLPartConfiguration {
    private List fServicesNeed2BeWS;
    private List fSelectedServices2BeWS;
    private EGLDeploymentRoot fDeploymentRoot;
    private HashSet fWSSet;
    private int fInitialAvailableServicesCnt;
    private boolean bGenAsRest = true;
    private boolean bGenAsSOAP = false;

    public void init(EGLDeploymentRoot deploymentRoot, List allEGLServicesList) {
        this.fDeploymentRoot = deploymentRoot;
        this.initWebServicesSet(deploymentRoot);
        this.calculateServicesNeed2BeWS(deploymentRoot, allEGLServicesList);
        this.bGenAsRest = true;
        this.bGenAsSOAP = false;
        this.fInitialAvailableServicesCnt = this.getServicesNeed2BeWS().size();
    }

    public int getInitialAvailableServicesCount() {
        return this.fInitialAvailableServicesCnt;
    }

    private void initWebServicesSet(EGLDeploymentRoot deploymentRoot) {
        Deployment deployment;
        Services wss;
        if (this.fWSSet == null) {
            this.fWSSet = new HashSet();
        }
        if ((wss = (deployment = deploymentRoot.getDeployment()).getServices()) != null) {
            for (Service service : wss.getService()) {
                this.fWSSet.add(service.getImplementation());
            }
        }
    }

    private void calculateServicesNeed2BeWS(EGLDeploymentRoot root, List allEGLServicesList) {
        this.fServicesNeed2BeWS = this.getServicesNeed2BeWS();
        for (PartDeclarationInfo partInfo : allEGLServicesList) {
            String serviceFQName = partInfo.getFullyQualifiedName();
            if (this.fWSSet.contains(serviceFQName)) continue;
            this.fServicesNeed2BeWS.add(partInfo);
        }
    }

    public List getServicesNeed2BeWS() {
        if (this.fServicesNeed2BeWS == null) {
            this.fServicesNeed2BeWS = new ArrayList();
        }
        return this.fServicesNeed2BeWS;
    }

    public List getSelectedServices2BeWS() {
        if (this.fSelectedServices2BeWS == null) {
            this.fSelectedServices2BeWS = new ArrayList();
        }
        return this.fSelectedServices2BeWS;
    }

    public void moveServices2BeWS(List sels) {
        this.getSelectedServices2BeWS().addAll(sels);
        this.getServicesNeed2BeWS().removeAll(sels);
    }

    public void moveAllServices2BeWS() {
        this.getSelectedServices2BeWS().addAll(this.getServicesNeed2BeWS());
        this.getServicesNeed2BeWS().clear();
    }

    public void moveServicesNot2BeWS(List sels) {
        this.getServicesNeed2BeWS().addAll(sels);
        this.getSelectedServices2BeWS().removeAll(sels);
    }

    public void moveAllServicesNot2BeWS() {
        this.getServicesNeed2BeWS().addAll(this.getSelectedServices2BeWS());
        this.getSelectedServices2BeWS().clear();
    }

    public boolean isGenAsSOAP() {
        return this.bGenAsSOAP;
    }

    public void setGenAsSOAP(boolean newVal) {
        this.bGenAsSOAP = newVal;
    }

    public boolean isGenAsRest() {
        return this.bGenAsRest;
    }

    public void setGenAsRest(boolean newVal) {
        this.bGenAsRest = newVal;
    }

    public String executeAddWebServicesOperation() {
        Deployment deployment = this.fDeploymentRoot.getDeployment();
        DeploymentFactory factory = DeploymentFactory.eINSTANCE;
        Services services = deployment.getServices();
        if (services == null) {
            services = factory.createServices();
            deployment.setServices(services);
        }
        List sel = this.getSelectedServices2BeWS();
        Object newWS = null;
        Service newRS = null;
        for (PartDeclarationInfo partinfo : sel) {
            char parttype = partinfo.getPartType();
            String fqImpl = partinfo.getFullyQualifiedName();
            newRS = factory.createService();
            Parameters params = DeploymentFactory.eINSTANCE.createParameters();
            newRS.setParameters(params);
            newRS.setType(org.eclipse.edt.ide.deployment.core.model.Service.SERVICE_REST);
            newRS.setImplementation(fqImpl);
            EGLDDRootHelper.addOrUpdateParameter(params, "uriFragment", partinfo.getPartName());
            EGLDDRootHelper.addOrUpdateParameter(params, "enableGeneration", this.isGenAsRest());
            EGLDDRootHelper.addOrUpdateParameter(params, "implType", parttype);
            services.getService().add((Object)newRS);
        }
        return newWS == null ? newRS.getImplementation() : newWS.getImplementation();
    }
}

