/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.TimestampType;
import org.eclipse.edt.mof.egl.Type;

public class TimestampTypeTemplate
extends JavaTemplate {
    public void genConstructorOptions(TimestampType type, Context ctx, TabbedWriter out) {
        this.generateOptions(type, ctx, out);
    }

    public void genTypeDependentOptions(TimestampType type, Context ctx, TabbedWriter out) {
        out.print(", ");
        this.generateOptions(type, ctx, out);
    }

    public void genJsonTypeDependentOptions(TimestampType type, Context ctx, TabbedWriter out) {
        String pattern = "yyyyMMddhhmmss";
        if (type.getPattern() != null && !type.getPattern().equalsIgnoreCase("null")) {
            pattern = type.getPattern();
        }
        out.print("\"");
        out.print(TimestampTypeTemplate.getStartPattern(pattern));
        out.print("\", \"");
        out.print(TimestampTypeTemplate.getEndPattern(pattern));
        out.print("\"");
    }

    protected void generateOptions(TimestampType type, Context ctx, TabbedWriter out) {
        String pattern = "yyyyMMddhhmmss";
        if (type.getPattern() != null && !type.getPattern().equalsIgnoreCase("null")) {
            pattern = type.getPattern();
        }
        ctx.invoke("genRuntimeTypeName", (Type)type, new Object[]{ctx, out, JavaTemplate.TypeNameKind.EGLImplementation});
        out.print(".");
        out.print(TimestampTypeTemplate.getStartPattern(pattern));
        out.print(", ");
        ctx.invoke("genRuntimeTypeName", (Type)type, new Object[]{ctx, out, JavaTemplate.TypeNameKind.EGLImplementation});
        out.print(".");
        out.print(TimestampTypeTemplate.getEndPattern(pattern));
    }

    public static String getStartPattern(String pattern) {
        if (pattern.startsWith("yyyy")) {
            return "YEAR_CODE";
        }
        if (pattern.startsWith("MM")) {
            return "MONTH_CODE";
        }
        if (pattern.startsWith("dd")) {
            return "DAY_CODE";
        }
        if (pattern.startsWith("HH")) {
            return "HOUR_CODE";
        }
        if (pattern.startsWith("mm")) {
            return "MINUTE_CODE";
        }
        if (pattern.startsWith("ss")) {
            return "SECOND_CODE";
        }
        if (pattern.startsWith("f")) {
            return "FRACTION1_CODE";
        }
        return "";
    }

    public static String getEndPattern(String pattern) {
        if (pattern.endsWith("yyyy")) {
            return "YEAR_CODE";
        }
        if (pattern.endsWith("MM")) {
            return "MONTH_CODE";
        }
        if (pattern.endsWith("dd")) {
            return "DAY_CODE";
        }
        if (pattern.endsWith("HH")) {
            return "HOUR_CODE";
        }
        if (pattern.endsWith("mm")) {
            return "MINUTE_CODE";
        }
        if (pattern.endsWith("ss")) {
            return "SECOND_CODE";
        }
        if (pattern.endsWith("ffffff")) {
            return "FRACTION6_CODE";
        }
        if (pattern.endsWith("fffff")) {
            return "FRACTION5_CODE";
        }
        if (pattern.endsWith("ffff")) {
            return "FRACTION4_CODE";
        }
        if (pattern.endsWith("fff")) {
            return "FRACTION3_CODE";
        }
        if (pattern.endsWith("ff")) {
            return "FRACTION2_CODE";
        }
        if (pattern.endsWith("f")) {
            return "FRACTION1_CODE";
        }
        return "";
    }
}

