/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.SettingsBlockLocator;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class EGLRUIWidgetDeleteStrategy {
    private IEGLDocument currentDocument;
    private Handler handler;
    private String deletedWidgetName;
    private int currentSetting = 0;

    public EGLRUIWidgetDeleteStrategy(Handler handler, IEGLDocument document) {
        this.currentDocument = document;
        this.handler = handler;
    }

    public void deleteTargetWidget() {
        SettingsBlockLocator locator = new SettingsBlockLocator();
        this.handler.accept((IASTVisitor)locator);
        if (locator.getSettingsBlock() != null) {
            locator.getSettingsBlock().accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(SettingsBlock settingsBlock) {
                    return true;
                }

                public boolean visit(SetValuesExpression setvalues) {
                    EGLRUIWidgetDeleteStrategy eGLRUIWidgetDeleteStrategy = EGLRUIWidgetDeleteStrategy.this;
                    eGLRUIWidgetDeleteStrategy.currentSetting = eGLRUIWidgetDeleteStrategy.currentSetting + 1;
                    return false;
                }

                public boolean visit(Assignment assignment) {
                    try {
                        EGLRUIWidgetDeleteStrategy eGLRUIWidgetDeleteStrategy = EGLRUIWidgetDeleteStrategy.this;
                        eGLRUIWidgetDeleteStrategy.currentSetting = eGLRUIWidgetDeleteStrategy.currentSetting + 1;
                        if (assignment.getLeftHandSide().isName() && InternUtil.intern((String)"targetWidget") == ((Name)assignment.getLeftHandSide()).getIdentifier()) {
                            EGLRUIWidgetDeleteStrategy.this.deletedWidgetName = assignment.getRightHandSide().getCanonicalString();
                            int referenceOffset = assignment.getOffset();
                            int referenceLength = assignment.getLength();
                            List settings = ((SettingsBlock)assignment.getParent()).getSettings();
                            if (EGLRUIWidgetDeleteStrategy.this.currentSetting == settings.size()) {
                                Node preNode = (Node)settings.get(EGLRUIWidgetDeleteStrategy.this.currentSetting - 2);
                                referenceLength += referenceOffset - (preNode.getOffset() + preNode.getLength());
                                referenceOffset = preNode.getOffset() + preNode.getLength();
                            } else {
                                Node nextNode = (Node)settings.get(EGLRUIWidgetDeleteStrategy.this.currentSetting);
                                referenceLength = nextNode.getOffset() - referenceOffset;
                            }
                            EGLRUIWidgetDeleteStrategy.this.currentDocument.replace(referenceOffset, referenceLength, "");
                        }
                    }
                    catch (Exception e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Handler Update: Error deleting item from RUIhandler", (Throwable)e));
                    }
                    return false;
                }
            });
        }
    }

    public String getDeletedWidgetName() {
        return this.deletedWidgetName;
    }
}

