/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.AssignmentLocator;
import org.eclipse.edt.ide.rui.document.utils.DocumentUtil;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.rui.server.EventValue;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class GetEventValueOperation {
    private IEGLDocument currentDocument;
    private IFile currentFile;
    private EventValue eventValue = null;

    public GetEventValueOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public EventValue getEventValue(final String eventName, int widgetOffset, int widgetLength) {
        if (widgetOffset <= 0 || widgetLength <= 0) {
            return null;
        }
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    Node widgetReference = DocumentUtil.getWidgetNode(this.currentDocument, widgetOffset, widgetLength);
                    if (widgetReference != null) {
                        widgetReference.accept((IASTVisitor)new DefaultASTVisitor(){

                            public boolean visit(NewExpression newExpression) {
                                GetEventValueOperation.this.processNewExpression(eventName, newExpression);
                                return false;
                            }

                            public boolean visit(SimpleName simpleName) {
                                Node parentNode = simpleName.getParent();
                                if (parentNode != null) {
                                    parentNode.accept((IASTVisitor)new DefaultASTVisitor(){

                                        public boolean visit(ClassDataDeclaration classDataDeclaration) {
                                            boolean foundEvent = false;
                                            if (classDataDeclaration.hasSettingsBlock()) {
                                                AssignmentLocator locator = new AssignmentLocator(InternUtil.intern((String)eventName));
                                                classDataDeclaration.getSettingsBlockOpt().accept((IASTVisitor)locator);
                                                if (locator.getAssignment() != null) {
                                                    foundEvent = true;
                                                    EventValueVisitor visitor = new EventValueVisitor();
                                                    visitor.processExpression(locator.getAssignment().getRightHandSide());
                                                    GetEventValueOperation.this.eventValue = new EventValue(visitor.getResult(), true);
                                                }
                                            }
                                            if (!foundEvent && classDataDeclaration.hasInitializer()) {
                                                Expression initializer = classDataDeclaration.getInitializer();
                                                initializer.accept((IASTVisitor)new DefaultASTVisitor(){

                                                    public boolean visit(NewExpression newExpression) {
                                                        GetEventValueOperation.this.processNewExpression(eventName, newExpression);
                                                        return false;
                                                    }
                                                });
                                            }
                                            return false;
                                        }

                                        public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                                            boolean foundEvent = false;
                                            if (functionDataDeclaration.hasSettingsBlock()) {
                                                AssignmentLocator locator = new AssignmentLocator(InternUtil.intern((String)eventName));
                                                functionDataDeclaration.getSettingsBlockOpt().accept((IASTVisitor)locator);
                                                if (locator.getAssignment() != null) {
                                                    foundEvent = true;
                                                    EventValueVisitor visitor = new EventValueVisitor();
                                                    visitor.processExpression(locator.getAssignment().getRightHandSide());
                                                    GetEventValueOperation.this.eventValue = new EventValue(visitor.getResult(), true);
                                                }
                                            }
                                            if (!foundEvent && functionDataDeclaration.hasInitializer()) {
                                                Expression initializer = functionDataDeclaration.getInitializer();
                                                initializer.accept((IASTVisitor)new DefaultASTVisitor(){

                                                    public boolean visit(NewExpression newExpression) {
                                                        GetEventValueOperation.this.processNewExpression(eventName, newExpression);
                                                        return false;
                                                    }
                                                });
                                            }
                                            return false;
                                        }
                                    });
                                }
                                return false;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Event Value: Error accessing event value", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (EGLModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Event Value: Error creating working copy", (Throwable)e));
        }
        return this.eventValue;
    }

    private void processNewExpression(String eventName, NewExpression newExpression) {
        if (newExpression.hasSettingsBlock()) {
            AssignmentLocator locator = new AssignmentLocator(InternUtil.intern((String)eventName));
            newExpression.getSettingsBlock().accept((IASTVisitor)locator);
            if (locator.getAssignment() != null) {
                EventValueVisitor visitor = new EventValueVisitor();
                visitor.processExpression(locator.getAssignment().getRightHandSide());
                this.eventValue = new EventValue(visitor.getResult(), true);
            }
        }
    }

    private class EventValueVisitor
    extends DefaultASTVisitor {
        private String result = "";

        public String getResult() {
            return this.result;
        }

        public void processExpression(Expression expression) {
            expression.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(Delegate delegate) {
                    EventValueVisitor.this.result = delegate.getPartTypeName();
                    return false;
                }

                public boolean visit(FunctionInvocation functionInvocation) {
                    EventValueVisitor.this.result = functionInvocation.getCanonicalString();
                    return false;
                }

                public boolean visit(SimpleName simpleName) {
                    EventValueVisitor.this.result = simpleName.getCanonicalString();
                    return false;
                }

                public boolean visit(QualifiedName qualifiedName) {
                    EventValueVisitor.this.result = qualifiedName.getCanonicalString();
                    return false;
                }
            });
        }
    }
}

