/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.AddImportOperation;
import org.eclipse.edt.ide.rui.document.utils.TypeNameResolver;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;

public class InsertFieldOperation {
    private IEGLDocument currentDocument;
    private IFile currentFile;

    public InsertFieldOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public void insertField(String fieldTypePackage, String fieldName, String fieldType, String template, int index) {
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.open(null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    File fileAST = this.currentDocument.getNewModelEGLFile();
                    String partName = new Path(this.currentFile.getName()).removeFileExtension().toString();
                    Part part = this.getPart(fileAST, partName);
                    this.addField(fieldTypePackage, fieldName, fieldType, template, fileAST, part, index);
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Insert Field: Error inserting field", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Insert Event Field: Error creating working copy", (Throwable)e));
        }
    }

    private Part getPart(File fileAST, String partName) {
        Part part = null;
        List parts = fileAST.getParts();
        for (Part nextPart : parts) {
            if (nextPart.getIdentifier() != InternUtil.intern((String)partName)) continue;
            part = nextPart;
            break;
        }
        return part;
    }

    private void addField(String fieldTypePackage, String fieldName, String fieldType, String template, File fileAST, Part part, int index) throws EGLModelException, MalformedTreeException, BadLocationException {
        boolean isRequireQualifiedImport = false;
        if (fieldTypePackage != null && fieldTypePackage.length() > 0) {
            String typeName;
            TypeNameResolver typeNameResolver = new TypeNameResolver(this.currentFile);
            typeNameResolver.resolveTypeName(fieldTypePackage, fieldType);
            if (typeNameResolver.requiresQualifiedImport()) {
                isRequireQualifiedImport = true;
            }
            if ((typeName = typeNameResolver.getTypeName()) != null && typeName.contains(".")) {
                template = String.valueOf(fieldTypePackage) + "." + template;
            }
        }
        ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
        rewrite.addClassFieldAtIndex(part, fieldName, template, null, index);
        rewrite.rewriteAST((IDocument)this.currentDocument).apply((IDocument)this.currentDocument);
        if (isRequireQualifiedImport) {
            AddImportOperation addImportOperation = new AddImportOperation(this.currentDocument, this.currentFile);
            addImportOperation.addFullyQualifiedImport(String.valueOf(fieldTypePackage) + "." + fieldType);
        }
    }
}

