/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocument;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;

public class TypeNameResolver {
    private static final String TEMP_FIELD_NAME = "eze$$temp";
    private IFile currentFile;
    private String typeName;
    private boolean qualifiedImportRequired = false;

    public TypeNameResolver(IFile currentFile) {
        this.currentFile = currentFile;
    }

    public void resolveTypeName(String widgetPackageName, String widgetTypeName) {
        if (widgetPackageName.length() == 0) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Type Name Resolver: Cannot resolve a type name if it is in a default package"));
            return;
        }
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.open(null);
            sharedWorkingCopy.reconcile(false, null);
            IEGLFile tempWorkingCopy = (IEGLFile)modelFile.getWorkingCopy();
            tempWorkingCopy.getBuffer().setContents(sharedWorkingCopy.getBuffer().getContents());
            try {
                try {
                    String partName = new Path(this.currentFile.getName()).removeFileExtension().toString();
                    this.doResolveTypeName(modelFile.getEGLProject().getProject(), this.currentFile, tempWorkingCopy, ((EGLFile)modelFile).getPackageName(), partName, widgetPackageName, widgetTypeName);
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Type Name Resolver: Error resolving type name", (Throwable)e));
                    tempWorkingCopy.destroy();
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                tempWorkingCopy.destroy();
                sharedWorkingCopy.destroy();
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Type Name Resolver: Error resolving type name", (Throwable)e));
        }
    }

    private Part getPart(File fileAST, String partName) {
        Part part = null;
        List parts = fileAST.getParts();
        for (Part nextPart : parts) {
            if (nextPart.getIdentifier() != InternUtil.intern((String)partName)) continue;
            part = nextPart;
            break;
        }
        return part;
    }

    private void doResolveTypeName(IProject project, IFile file, IEGLFile workingCopy, String[] partPackageName, String partName, String widgetPackageName, String widgetTypeName) throws EGLModelException, MalformedTreeException, BadLocationException {
        EGLDocument tempDocument = new EGLDocument(workingCopy.getBuffer().getContents());
        File fileAST = tempDocument.getNewModelEGLFile();
        Part part = this.getPart(fileAST, partName);
        ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
        rewrite.addClassFieldAtIndex(part, TEMP_FIELD_NAME, widgetTypeName, null, 0);
        rewrite.rewriteAST((IDocument)tempDocument).apply((IDocument)tempDocument);
        workingCopy.getBuffer().setContents(tempDocument.get());
        BoundFieldLocator locator = new BoundFieldLocator(TEMP_FIELD_NAME);
        WorkingCopyCompiler.getInstance().compilePart(project, partPackageName, file, new IWorkingCopy[]{workingCopy}, partName, (IWorkingCopyCompileRequestor)locator);
        if (locator.getField() != null) {
            if (Binding.isValidBinding((IBinding)locator.getField().getType().resolveTypeBinding())) {
                this.typeName = locator.getField().getType().resolveTypeBinding().getPackageName() != InternUtil.intern((String[])widgetPackageName.split("\\.")) ? this.getFullyQualifiedTypeName(widgetPackageName, widgetTypeName) : widgetTypeName;
                this.qualifiedImportRequired = false;
            } else {
                this.typeName = widgetTypeName;
                this.qualifiedImportRequired = true;
            }
        } else {
            this.typeName = this.getFullyQualifiedTypeName(widgetPackageName, widgetTypeName);
            this.qualifiedImportRequired = false;
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean requiresQualifiedImport() {
        return this.qualifiedImportRequired;
    }

    private String getFullyQualifiedTypeName(String widgetPackageName, String widgetTypeName) {
        return String.valueOf(widgetPackageName) + "." + widgetTypeName;
    }

    private class BoundFieldLocator
    implements IWorkingCopyCompileRequestor {
        private ClassDataDeclaration field = null;
        private String fieldName;

        public BoundFieldLocator(String fieldName) {
            this.fieldName = fieldName;
        }

        public void acceptResult(WorkingCopyCompilationResult result) {
            List contents = ((Handler)result.getBoundPart()).getContents();
            for (Node nextNode : contents) {
                nextNode.accept((IASTVisitor)new DefaultASTVisitor(){

                    public boolean visit(ClassDataDeclaration classDataDeclaration) {
                        if (classDataDeclaration.getNames().size() == 1 && BoundFieldLocator.this.fieldName.equals(((Name)classDataDeclaration.getNames().get(0)).getIdentifier())) {
                            BoundFieldLocator.this.field = classDataDeclaration;
                        }
                        return false;
                    }
                });
                if (this.field != null) break;
            }
        }

        public ClassDataDeclaration getField() {
            return this.field;
        }
    }
}

