/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.project;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.rui.internal.project.CommonUtilities;
import org.eclipse.edt.ide.rui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ImportRUIProjectsOperation
extends WorkspaceModifyOperation {
    private String resourcePluginName = "org.eclipse.edt.ide.ui.resources";
    private String libraryResourceFolder = "/org.eclipse.edt.ide.ui.rui/";
    private String widgetsProjectName;

    public ImportRUIProjectsOperation(ISchedulingRule rule, String resourcePluginName, String libraryResourceFolder, String widgetsProjectName) {
        super(rule);
        this.resourcePluginName = resourcePluginName;
        this.libraryResourceFolder = libraryResourceFolder;
        this.widgetsProjectName = widgetsProjectName;
    }

    public ImportRUIProjectsOperation(ISchedulingRule rule, String widgetsProjectName) {
        super(rule);
        this.widgetsProjectName = widgetsProjectName;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        if (this.widgetsProjectName != null) {
            this.importWidgetsProject(monitor, this.widgetsProjectName);
        }
    }

    private void importWidgetsProject(IProgressMonitor monitor, String projectName) {
        IProject widgetsProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(String.valueOf(NewWizardMessages.ImportTask) + projectName, 10);
        if (!widgetsProject.exists()) {
            try {
                try {
                    monitor.subTask(NewWizardMessages.ImportTask_Unzip);
                    this.unzipWidgets(projectName);
                    monitor.worked(6);
                    if (!widgetsProject.exists()) {
                        widgetsProject.create((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (!widgetsProject.isOpen()) {
                        widgetsProject.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    EGLCore.create((IProject)widgetsProject);
                    widgetsProject.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
                    if (!description.isAutoBuilding()) {
                        widgetsProject.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
                catch (Exception e) {
                    EGLLogger.log((Object)((Object)this), (Throwable)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void unzipWidgets(String projectName) throws IOException {
        URL url = CommonUtilities.getWidgetProjectURL(this.resourcePluginName, this.libraryResourceFolder, projectName);
        if (url != null) {
            IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            ZipFile sampleSource = new ZipFile(url.getFile());
            try {
                Enumeration<? extends ZipEntry> entries = sampleSource.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(projectName)) continue;
                    if (entry.isDirectory()) {
                        workspaceLocation.append(entry.getName()).toFile().mkdir();
                        continue;
                    }
                    File file = workspaceLocation.append(entry.getName()).toFile();
                    file.getParentFile().mkdirs();
                    BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(file));
                    InputStream inStream = sampleSource.getInputStream(entry);
                    try {
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = inStream.read(buffer)) >= 0) {
                            ((OutputStream)outStream).write(buffer, 0, len);
                        }
                    }
                    finally {
                        ((OutputStream)outStream).close();
                        inStream.close();
                    }
                }
            }
            finally {
                sampleSource.close();
            }
        }
    }
}

