/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.testserver;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.edt.ide.rui.internal.testserver.TestServer;
import org.eclipse.edt.javart.ide.IDEResourceLocator;
import org.eclipse.edt.javart.services.servlet.rest.rpc.PreviewServiceServlet;

public class ConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = 10L;
    public static final String SERVLET_PATH = "/config";
    public static final String ARG_DEFAULT_DD = "defaultDD";
    public static final String ARG_DD_ADDED = "ddAdded";
    public static final String ARG_DD_REMOVED = "ddRemoved";
    public static final String ARG_MAPPING_ADDED = "mappingAdded";
    public static final String ARG_MAPPING_REMOVED = "mappingRemoved";
    public static final String MAPPING_ARG_DELIMETER = "|";
    public static final String MAPPING_DELIMETER = ";";
    private final PreviewServiceServlet previewServlet;
    private final IDEResourceLocator resourceLocator;

    public ConfigServlet(PreviewServiceServlet previewServlet, IDEResourceLocator resourceLocator) {
        this.previewServlet = previewServlet;
        this.resourceLocator = resourceLocator;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String addedMappings = req.getParameter(ARG_MAPPING_ADDED);
        String removedMappings = req.getParameter(ARG_MAPPING_REMOVED);
        String addedDDs = req.getParameter(ARG_DD_ADDED);
        String removedDDs = req.getParameter(ARG_DD_REMOVED);
        String defaultDD = req.getParameter(ARG_DEFAULT_DD);
        if (addedMappings != null && addedMappings.length() > 0) {
            this.parseMappings(addedMappings, true);
        }
        if (removedMappings != null && removedMappings.length() > 0) {
            this.parseMappings(removedMappings, false);
        }
        if (addedDDs != null && addedDDs.length() > 0) {
            this.parseDDFiles(addedDDs, true);
        }
        if (removedDDs != null && removedDDs.length() > 0) {
            this.parseDDFiles(removedDDs, false);
        }
        if (defaultDD != null) {
            TestServer.log("Default DD changed: " + defaultDD);
            this.resourceLocator.setDefaultDD(defaultDD);
        }
    }

    public void parseMappings(String mappings, boolean added) {
        StringTokenizer tok = new StringTokenizer(mappings, MAPPING_ARG_DELIMETER);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            StringTokenizer subtok = new StringTokenizer(token, MAPPING_DELIMETER);
            if (subtok.countTokens() == 3) {
                String uri = subtok.nextToken();
                String className = subtok.nextToken();
                boolean stateful = Boolean.valueOf(subtok.nextToken());
                try {
                    uri = URLDecoder.decode(uri, "UTF-8");
                    className = URLDecoder.decode(className, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    uri = uri.replaceAll("%7C", MAPPING_ARG_DELIMETER).replaceAll("%3B", MAPPING_DELIMETER).replaceAll("%25", "%");
                }
                if (added) {
                    TestServer.log("Service mapping added or changed: " + uri + ", " + className);
                    this.previewServlet.addServiceMapping(uri, className, stateful);
                    continue;
                }
                TestServer.log("Service mapping removed: " + uri + ", " + className);
                this.previewServlet.removeServiceMapping(uri);
                continue;
            }
            TestServer.log("Invalid number of tokens in service mapping " + (added ? "addition: " : "removal: ") + token);
        }
    }

    public void parseDDFiles(String ddFiles, boolean added) {
        List parsed = this.resourceLocator.parseDDArgument(ddFiles, added);
        for (String[] next : parsed) {
            if (added) {
                TestServer.log("DD file added or changed: " + next[0] + ", " + next[1]);
                continue;
            }
            TestServer.log("DD file removed: " + next[0] + ", " + next[1]);
        }
    }
}

